/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import java.util.Arrays;
import picard.PicardException;
import picard.illumina.parser.IntensityChannel;

public class FourChannelIntensityData {
    private short[] a;
    private short[] c;
    private short[] g;
    private short[] t;

    public FourChannelIntensityData(int numberOfCycles) {
        this.a = new short[numberOfCycles];
        this.c = new short[numberOfCycles];
        this.g = new short[numberOfCycles];
        this.t = new short[numberOfCycles];
    }

    public short[] getChannel(IntensityChannel channel) {
        switch (channel) {
            case A: {
                return this.a;
            }
            case C: {
                return this.c;
            }
            case G: {
                return this.g;
            }
            case T: {
                return this.t;
            }
        }
        throw new PicardException("Unexpected intensity channel " + (Object)((Object)channel));
    }

    public short[] getA() {
        return this.a;
    }

    public short[] getC() {
        return this.c;
    }

    public short[] getG() {
        return this.g;
    }

    public short[] getT() {
        return this.t;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        FourChannelIntensityData that = (FourChannelIntensityData)o2;
        return Arrays.equals(this.a, that.a) && Arrays.equals(this.c, that.c) && Arrays.equals(this.g, that.g) && Arrays.equals(this.t, that.t);
    }

    public int hashCode() {
        int ret = 0;
        ret = ret * 31 + Arrays.hashCode(this.a);
        ret += ret * 31 + Arrays.hashCode(this.c);
        ret += ret * 31 + Arrays.hashCode(this.g);
        ret += ret * 31 + Arrays.hashCode(this.t);
        return ret;
    }
}

