/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.traverse;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.jgrapht.DirectedGraph;
import org.jgrapht.traverse.CrossComponentIterator;
import org.jgrapht.util.ModifiableInteger;

public class TopologicalOrderIterator<V, E>
extends CrossComponentIterator<V, E, Object> {
    private Queue<V> queue;
    private Map<V, ModifiableInteger> inDegreeMap;

    public TopologicalOrderIterator(DirectedGraph<V, E> directedGraph) {
        this(directedGraph, (V)new LinkedListQueue());
    }

    public TopologicalOrderIterator(DirectedGraph<V, E> directedGraph, Queue<V> queue) {
        this(directedGraph, queue, new HashMap());
    }

    private TopologicalOrderIterator(DirectedGraph<V, E> directedGraph, Queue<V> queue, Map<V, ModifiableInteger> map) {
        this(directedGraph, TopologicalOrderIterator.initialize(directedGraph, queue, map));
        this.queue = queue;
        this.inDegreeMap = map;
        assert (directedGraph.vertexSet().isEmpty() || !queue.isEmpty());
    }

    private TopologicalOrderIterator(DirectedGraph<V, E> directedGraph, V v2) {
        super(directedGraph, v2);
    }

    @Override
    protected boolean isConnectedComponentExhausted() {
        return this.queue.isEmpty();
    }

    @Override
    protected void encounterVertex(V v2, E e2) {
        this.putSeenData(v2, null);
        this.decrementInDegree(v2);
    }

    @Override
    protected void encounterVertexAgain(V v2, E e2) {
        this.decrementInDegree(v2);
    }

    @Override
    protected V provideNextVertex() {
        return this.queue.remove();
    }

    private void decrementInDegree(V v2) {
        ModifiableInteger modifiableInteger = this.inDegreeMap.get(v2);
        if (modifiableInteger.value > 0) {
            --modifiableInteger.value;
            if (modifiableInteger.value == 0) {
                this.queue.offer(v2);
            }
        }
    }

    private static <V, E> V initialize(DirectedGraph<V, E> directedGraph, Queue<V> queue, Map<V, ModifiableInteger> map) {
        for (Object v2 : directedGraph.vertexSet()) {
            int n2 = directedGraph.inDegreeOf(v2);
            map.put((ModifiableInteger)v2, new ModifiableInteger(n2));
            if (n2 != 0) continue;
            queue.offer(v2);
        }
        if (queue.isEmpty()) {
            return null;
        }
        return queue.peek();
    }

    private static class LinkedListQueue<T>
    extends LinkedList<T>
    implements Queue<T> {
        private static final long serialVersionUID = 4217659843476891334L;

        private LinkedListQueue() {
        }

        @Override
        public T element() {
            return (T)this.getFirst();
        }

        @Override
        public boolean offer(T t2) {
            return this.add(t2);
        }

        @Override
        public T peek() {
            if (this.isEmpty()) {
                return null;
            }
            return (T)this.getFirst();
        }

        @Override
        public T poll() {
            if (this.isEmpty()) {
                return null;
            }
            return (T)this.removeFirst();
        }

        @Override
        public T remove() {
            return (T)this.removeFirst();
        }
    }
}

