/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.traverse;

import java.util.ArrayDeque;
import java.util.Deque;
import org.jgrapht.Graph;
import org.jgrapht.traverse.CrossComponentIterator;
import org.jgrapht.util.TypeUtil;

public class DepthFirstIterator<V, E>
extends CrossComponentIterator<V, E, CrossComponentIterator.VisitColor> {
    public static final Object SENTINEL = new Object();
    private Deque<Object> stack = new ArrayDeque<Object>();
    private transient TypeUtil<V> vertexTypeDecl = null;

    public DepthFirstIterator(Graph<V, E> graph) {
        this(graph, null);
    }

    public DepthFirstIterator(Graph<V, E> graph, V v2) {
        super(graph, v2);
    }

    @Override
    protected boolean isConnectedComponentExhausted() {
        while (!this.stack.isEmpty()) {
            if (this.stack.getLast() != SENTINEL) {
                return false;
            }
            this.stack.removeLast();
            this.recordFinish();
        }
        return true;
    }

    @Override
    protected void encounterVertex(V v2, E e2) {
        this.putSeenData(v2, CrossComponentIterator.VisitColor.WHITE);
        this.stack.addLast(v2);
    }

    @Override
    protected void encounterVertexAgain(V v2, E e2) {
        CrossComponentIterator.VisitColor visitColor = (CrossComponentIterator.VisitColor)((Object)this.getSeenData(v2));
        if (visitColor != CrossComponentIterator.VisitColor.WHITE) {
            return;
        }
        boolean bl = this.stack.removeLastOccurrence(v2);
        assert (bl);
        this.stack.addLast(v2);
    }

    @Override
    protected V provideNextVertex() {
        Object object;
        while ((object = this.stack.removeLast()) == SENTINEL) {
            this.recordFinish();
        }
        V v2 = TypeUtil.uncheckedCast(object, this.vertexTypeDecl);
        this.stack.addLast(v2);
        this.stack.addLast(SENTINEL);
        this.putSeenData(v2, CrossComponentIterator.VisitColor.GRAY);
        return v2;
    }

    private void recordFinish() {
        V v2 = TypeUtil.uncheckedCast(this.stack.removeLast(), this.vertexTypeDecl);
        this.putSeenData(v2, CrossComponentIterator.VisitColor.BLACK);
        this.finishVertex(v2);
    }

    public Deque<Object> getStack() {
        return this.stack;
    }
}

