/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.util.Collection;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graph;
import org.jgrapht.graph.AbstractGraph;
import org.jgrapht.graph.MaskEdgeSet;
import org.jgrapht.graph.MaskFunctor;
import org.jgrapht.graph.MaskVertexSet;

public class MaskSubgraph<V, E>
extends AbstractGraph<V, E> {
    private static final String UNMODIFIABLE = "this graph is unmodifiable";
    private Graph<V, E> base;
    private Set<E> edges;
    private MaskFunctor<V, E> mask;
    private Set<V> vertices;

    public MaskSubgraph(Graph<V, E> graph, MaskFunctor<V, E> maskFunctor) {
        this.base = graph;
        this.mask = maskFunctor;
        this.vertices = new MaskVertexSet<V, E>(graph.vertexSet(), maskFunctor);
        this.edges = new MaskEdgeSet<V, E>(graph, graph.edgeSet(), maskFunctor);
    }

    @Override
    public E addEdge(V v2, V v3) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    @Override
    public boolean addEdge(V v2, V v3, E e2) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    @Override
    public boolean addVertex(V v2) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    @Override
    public boolean containsEdge(E e2) {
        return this.edgeSet().contains(e2);
    }

    @Override
    public boolean containsVertex(V v2) {
        return !this.mask.isVertexMasked(v2) && this.base.containsVertex(v2);
    }

    public int degreeOf(V v2) {
        return this.edgesOf(v2).size();
    }

    @Override
    public Set<E> edgeSet() {
        return this.edges;
    }

    @Override
    public Set<E> edgesOf(V v2) {
        this.assertVertexExist(v2);
        return new MaskEdgeSet<V, E>(this.base, this.base.edgesOf(v2), this.mask);
    }

    @Override
    public Set<E> getAllEdges(V v2, V v3) {
        Set<E> set = null;
        if (this.containsVertex(v2) && this.containsVertex(v3)) {
            return new MaskEdgeSet<V, E>(this.base, this.base.getAllEdges(v2, v3), this.mask);
        }
        return set;
    }

    @Override
    public E getEdge(V v2, V v3) {
        Set<E> set = this.getAllEdges(v2, v3);
        if (set == null || set.isEmpty()) {
            return null;
        }
        return set.iterator().next();
    }

    @Override
    public EdgeFactory<V, E> getEdgeFactory() {
        return this.base.getEdgeFactory();
    }

    @Override
    public V getEdgeSource(E e2) {
        assert (this.edgeSet().contains(e2));
        return this.base.getEdgeSource(e2);
    }

    @Override
    public V getEdgeTarget(E e2) {
        assert (this.edgeSet().contains(e2));
        return this.base.getEdgeTarget(e2);
    }

    @Override
    public double getEdgeWeight(E e2) {
        assert (this.edgeSet().contains(e2));
        return this.base.getEdgeWeight(e2);
    }

    public Set<E> incomingEdgesOf(V v2) {
        this.assertVertexExist(v2);
        return new MaskEdgeSet<V, E>(this.base, ((DirectedGraph)this.base).incomingEdgesOf(v2), this.mask);
    }

    public int inDegreeOf(V v2) {
        return this.incomingEdgesOf(v2).size();
    }

    public int outDegreeOf(V v2) {
        return this.outgoingEdgesOf(v2).size();
    }

    public Set<E> outgoingEdgesOf(V v2) {
        this.assertVertexExist(v2);
        return new MaskEdgeSet<V, E>(this.base, ((DirectedGraph)this.base).outgoingEdgesOf(v2), this.mask);
    }

    @Override
    public boolean removeAllEdges(Collection<? extends E> collection) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    @Override
    public Set<E> removeAllEdges(V v2, V v3) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    @Override
    public boolean removeAllVertices(Collection<? extends V> collection) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    @Override
    public boolean removeEdge(E e2) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    @Override
    public E removeEdge(V v2, V v3) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    @Override
    public boolean removeVertex(V v2) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    @Override
    public Set<V> vertexSet() {
        return this.vertices;
    }
}

