/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.sam;

import java.util.Arrays;
import org.broadinstitute.gatk.utils.sam.GATKSAMRecord;

public class ClippedGATKSAMRecord
extends GATKSAMRecord {
    private byte[] insertionQuals;
    private byte[] deletionQuals;

    public ClippedGATKSAMRecord(GATKSAMRecord read, int start, int end) {
        super(read.getHeader(), read.getReferenceIndex(), read.getAlignmentStart() + start, (short)read.getReadNameLength(), (short)100, -1, read.getCigarLength(), read.getFlags(), end - start, read.getMateReferenceIndex(), read.getMateAlignmentStart(), read.getInferredInsertSize(), new byte[0]);
        this.setReadBases(Arrays.copyOfRange(read.getReadBases(), start, end));
        this.setBaseQualities(Arrays.copyOfRange(read.getBaseQualities(), start, end));
        this.setReadName(read.getReadName());
        this.insertionQuals = Arrays.copyOfRange(read.getBaseInsertionQualities(), start, end);
        this.deletionQuals = Arrays.copyOfRange(read.getBaseDeletionQualities(), start, end);
    }

    @Override
    public byte[] getBaseDeletionQualities() {
        return this.deletionQuals;
    }

    @Override
    public byte[] getBaseInsertionQualities() {
        return this.insertionQuals;
    }

    @Override
    public int getMappingQuality() {
        return 100;
    }

    @Override
    public int hashCode() {
        return this.getReadName().hashCode();
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 instanceof GATKSAMRecord) {
            return this.getReadName().equals(((GATKSAMRecord)o2).getReadName());
        }
        return false;
    }
}

