/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.commandline;

import java.lang.reflect.Type;
import org.broadinstitute.gatk.utils.classloader.JVMUtils;
import org.broadinstitute.gatk.utils.commandline.ArgumentMatches;
import org.broadinstitute.gatk.utils.commandline.ArgumentSource;
import org.broadinstitute.gatk.utils.commandline.ArgumentTypeDescriptor;
import org.broadinstitute.gatk.utils.commandline.ParsingEngine;
import org.broadinstitute.gatk.utils.commandline.RodBinding;
import org.broadinstitute.gatk.utils.commandline.Tags;

class RodBindingArgumentTypeDescriptor
extends ArgumentTypeDescriptor {
    RodBindingArgumentTypeDescriptor() {
    }

    @Override
    public boolean supports(Class type) {
        return RodBindingArgumentTypeDescriptor.isRodBinding(type);
    }

    public static boolean isRodBinding(Class type) {
        return RodBinding.class.isAssignableFrom(type);
    }

    @Override
    public boolean createsTypeDefault(ArgumentSource source) {
        return !source.isRequired();
    }

    @Override
    public Object createTypeDefault(ParsingEngine parsingEngine, ArgumentSource source, Type type) {
        Class parameterType = JVMUtils.getParameterizedTypeClass(type);
        return RodBinding.makeUnbound(parameterType);
    }

    @Override
    public String typeDefaultDocString(ArgumentSource source) {
        return "none";
    }

    @Override
    public Object parse(ParsingEngine parsingEngine, ArgumentSource source, Type type, ArgumentMatches matches) {
        Tags tags = this.getArgumentTags(matches);
        RodBinding rbind = (RodBinding)this.parseBinding(source, type, matches, tags);
        parsingEngine.addTags(rbind, tags);
        parsingEngine.addRodBinding(rbind);
        return rbind;
    }
}

