/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools.sort;

import java.io.File;
import org.apache.log4j.Logger;
import org.broad.igv.feature.tribble.MUTCodec;
import org.broad.igv.gwas.GWASParser;
import org.broad.igv.tools.sort.BAMSorter;
import org.broad.igv.tools.sort.BedSorter;
import org.broad.igv.tools.sort.CNSorter;
import org.broad.igv.tools.sort.EQTLSorter;
import org.broad.igv.tools.sort.GFFSorter;
import org.broad.igv.tools.sort.GWASSorter;
import org.broad.igv.tools.sort.GenericSorter;
import org.broad.igv.tools.sort.InteractionSorter;
import org.broad.igv.tools.sort.MUTSorter;
import org.broad.igv.tools.sort.SAMSorter;
import org.broad.igv.tools.sort.Sorter;
import org.broad.igv.tools.sort.VCFSorter;
import org.broad.igv.track.GFFFeatureSource;
import org.broad.igv.util.ResourceLocator;

public class SorterFactory {
    private static Logger log = Logger.getLogger(SorterFactory.class);

    public static Sorter getSorter(File inputFile, File outputFile) {
        String shortFN = inputFile.getName().toLowerCase();
        if (shortFN.endsWith(".txt")) {
            shortFN = shortFN.substring(0, shortFN.length() - 4);
        }
        if (shortFN.endsWith(".cn") || shortFN.endsWith(".xcn") || shortFN.endsWith(".snp") || shortFN.endsWith(".igv")) {
            return new CNSorter(inputFile, outputFile);
        }
        if (shortFN.endsWith(".sam")) {
            return new SAMSorter(inputFile, outputFile);
        }
        if (shortFN.endsWith(".aligned") || shortFN.endsWith(".bed") || shortFN.endsWith(".bedgraph") || shortFN.endsWith(".bdg")) {
            return new BedSorter(inputFile, outputFile);
        }
        if (GFFFeatureSource.isGFF(shortFN)) {
            return new GFFSorter(inputFile, outputFile);
        }
        if (shortFN.endsWith(".vcf")) {
            return new VCFSorter(inputFile, outputFile);
        }
        if (shortFN.endsWith(".psl") || shortFN.endsWith(".pslx")) {
            return new BedSorter(inputFile, outputFile);
        }
        if (shortFN.endsWith(".eqtl")) {
            return new EQTLSorter(inputFile, outputFile);
        }
        if (shortFN.endsWith(".snp")) {
            return new GenericSorter(inputFile, outputFile, 1, 2);
        }
        if (GWASParser.isGWASFile(shortFN)) {
            return new GWASSorter(inputFile, outputFile);
        }
        if (MUTCodec.isMutationAnnotationFile(new ResourceLocator(inputFile.getAbsolutePath()))) {
            return new MUTSorter(inputFile, outputFile);
        }
        if (shortFN.endsWith(".interaction")) {
            return new InteractionSorter(inputFile, outputFile);
        }
        if (shortFN.endsWith(".bam")) {
            return new BAMSorter(inputFile, outputFile);
        }
        log.error("Unknown file type or sorting not supported for: " + inputFile.getName());
        return null;
    }
}

