/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import htsjdk.tribble.Feature;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.SpliceJunctionFeature;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.SpliceJunctionRenderer;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.CoverageTrack;
import org.broad.igv.sam.IAlignmentDataManager;
import org.broad.igv.sam.SpliceJunctionHelper;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.PackedFeaturesSpliceJunctions;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.SashimiPlot;
import org.broad.igv.ui.event.AlignmentTrackEvent;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.ResourceLocator;

public class SpliceJunctionTrack
extends FeatureTrack {
    private static Logger log = Logger.getLogger(SpliceJunctionTrack.class);
    private static StrandOption strandOption;
    private AlignmentTrack alignmentTrack;
    private IAlignmentDataManager dataManager;
    private boolean removed = false;
    private JComponent dataPanel;

    public static void setStrandOption(StrandOption so) {
        strandOption = so;
    }

    public static StrandOption getStrandOption() {
        return strandOption;
    }

    public SpliceJunctionTrack(ResourceLocator locator, String name, IAlignmentDataManager dataManager, AlignmentTrack alignmentTrack, StrandOption ignoreStrand) {
        super(locator, locator.getPath() + "_junctions", name);
        super.setDataRange(new DataRange(0.0f, 0.0f, 60.0f));
        this.setRendererClass(SpliceJunctionRenderer.class);
        this.dataManager = dataManager;
        this.alignmentTrack = alignmentTrack;
        strandOption = ignoreStrand;
    }

    @Override
    protected boolean isShowFeatures(RenderContext context) {
        float maxRange = PreferenceManager.getInstance().getAsFloat("SAM.MAX_VISIBLE_RANGE");
        float minVisibleScale = maxRange * 1000.0f / 700.0f;
        return context.getScale() < (double)minVisibleScale;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void clear() {
        this.packedFeaturesMap.clear();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.removed = true;
        this.dataManager = null;
        this.alignmentTrack = null;
        this.setVisible(false);
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        IGVPopupMenu popupMenu = new IGVPopupMenu();
        JLabel popupTitle = new JLabel("  " + this.getName(), 0);
        Font newFont = popupMenu.getFont().deriveFont(1, 12.0f);
        popupTitle.setFont(newFont);
        if (popupTitle != null) {
            popupMenu.add(popupTitle);
        }
        popupMenu.addSeparator();
        ArrayList<Track> tmp = new ArrayList<Track>();
        tmp.add(this);
        TrackMenuUtils.addStandardItems(popupMenu, tmp, te);
        popupMenu.addSeparator();
        popupMenu.add(this.getChangeAutoScale());
        popupMenu.addSeparator();
        JMenuItem sashimi = new JMenuItem("Sashimi Plot");
        sashimi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                SashimiPlot.getSashimiPlot(null);
            }
        });
        popupMenu.add(sashimi);
        if (this.alignmentTrack != null) {
            popupMenu.addSeparator();
            final JCheckBoxMenuItem alignmentItem = new JCheckBoxMenuItem("Show Alignment Track");
            alignmentItem.setSelected(this.alignmentTrack.isVisible());
            alignmentItem.setEnabled(!this.alignmentTrack.isRemoved());
            alignmentItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    SpliceJunctionTrack.this.alignmentTrack.onAlignmentTrackEvent(new AlignmentTrackEvent(SpliceJunctionTrack.this, AlignmentTrackEvent.Type.VISIBLE, alignmentItem.isSelected()));
                    if (alignmentItem.isSelected()) {
                        SpliceJunctionTrack.this.alignmentTrack.onAlignmentTrackEvent(new AlignmentTrackEvent(SpliceJunctionTrack.this, AlignmentTrackEvent.Type.RELOAD));
                    }
                }
            });
            popupMenu.add(alignmentItem);
            final CoverageTrack coverageTrack = this.alignmentTrack.getCoverageTrack();
            if (coverageTrack != null) {
                final JCheckBoxMenuItem coverageItem = new JCheckBoxMenuItem("Show Coverage Track");
                coverageItem.setSelected(coverageTrack.isVisible());
                coverageItem.setEnabled(!coverageTrack.isRemoved());
                coverageItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e2) {
                        UIUtilities.invokeOnEventThread(new Runnable(){

                            @Override
                            public void run() {
                                coverageTrack.setVisible(coverageItem.isSelected());
                                IGV.getInstance().getMainPanel().revalidate();
                            }
                        });
                    }
                });
                popupMenu.add(coverageItem);
            }
            JMenuItem junctionItem = new JMenuItem("Hide Track");
            junctionItem.setEnabled(!this.isRemoved());
            junctionItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    SpliceJunctionTrack.this.alignmentTrack.onAlignmentTrackEvent(new AlignmentTrackEvent(SpliceJunctionTrack.this, AlignmentTrackEvent.Type.SPLICE_JUNCTION, false));
                    IGV.getInstance().getMainPanel().revalidate();
                }
            });
            popupMenu.add(junctionItem);
        }
        return popupMenu;
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type, String frameName) {
        return 0.0f;
    }

    @Override
    protected String getZoomInMessage(String chr) {
        return "Zoom in to see junctions.";
    }

    @Override
    protected void loadFeatures(String chr, int start, int end, ReferenceFrame referenceFrame) {
        AlignmentInterval loadedInterval = this.dataManager.getLoadedInterval(referenceFrame.getCurrentRange());
        if (loadedInterval == null) {
            return;
        }
        SpliceJunctionHelper helper = loadedInterval.getSpliceJunctionHelper();
        List<SpliceJunctionFeature> features = helper.getFilteredJunctions(strandOption);
        if (features == null) {
            features = Collections.emptyList();
        }
        int intervalStart = loadedInterval.getStart();
        int intervalEnd = loadedInterval.getEnd();
        PackedFeaturesSpliceJunctions<SpliceJunctionFeature> pf = new PackedFeaturesSpliceJunctions<SpliceJunctionFeature>(chr, intervalStart, intervalEnd, features.iterator(), this.getName());
        this.packedFeaturesMap.put(referenceFrame.getName(), pf);
    }

    @Override
    public String getExportTrackLine() {
        return "track graphType=junctions";
    }

    @Override
    public boolean handleDataClick(TrackClickEvent te) {
        boolean result = super.handleDataClick(te);
        if (this.dataPanel != null) {
            this.dataPanel.repaint();
        }
        return result;
    }

    @Override
    public List<Feature> getFeatures(String chr, int start, int end) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        try {
            Iterator iter = this.source.getFeatures(chr, start, end);
            while (iter.hasNext()) {
                features.add((Feature)iter.next());
            }
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        return features;
    }

    private JMenuItem getChangeAutoScale() {
        final JCheckBoxMenuItem autoscaleItem = new JCheckBoxMenuItem("Autoscale");
        boolean autoScale = this.getAutoScale();
        autoscaleItem.setSelected(autoScale);
        autoscaleItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                boolean autoScale = SpliceJunctionTrack.this.getAutoScale();
                TrackProperties tp = new TrackProperties();
                if (autoScale) {
                    tp.setAutoScale(false);
                    autoscaleItem.setSelected(false);
                } else {
                    tp.setAutoScale(true);
                    autoscaleItem.setSelected(true);
                }
                tp.setRendererClass(SpliceJunctionRenderer.class);
                SpliceJunctionTrack.this.setProperties(tp);
                if (SpliceJunctionTrack.this.dataPanel != null) {
                    SpliceJunctionTrack.this.dataPanel.repaint();
                }
            }
        });
        return autoscaleItem;
    }

    public static enum StrandOption {
        COMBINE,
        FORWARD,
        REVERSE,
        BOTH;

    }
}

