/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.methyl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.broad.igv.bbfile.BBFileReader;
import org.broad.igv.bbfile.BedFeature;
import org.broad.igv.bbfile.BigBedIterator;
import org.broad.igv.data.AbstractDataSource;
import org.broad.igv.data.DataTile;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.track.TrackType;
import org.broad.igv.util.collections.FloatArrayList;
import org.broad.igv.util.collections.IntArrayList;

public class ZillerDataSource2
extends AbstractDataSource {
    static Pattern percentPattern = Pattern.compile("%");
    BBFileReader reader;
    private Map<String, String> chrNameMap = new HashMap<String, String>();
    private RawDataInterval currentInterval = null;

    public ZillerDataSource2(String path, Genome genome) throws IOException {
        super(genome);
        this.reader = new BBFileReader(path);
        this.init(genome);
    }

    private void init(Genome genome) {
        ArrayList<String> seqNames;
        this.chrNameMap = new HashMap<String, String>();
        if (genome != null && (seqNames = this.reader.getChromosomeNames()) != null) {
            for (String seqName : seqNames) {
                String igvChr = genome.getCanonicalChrName(seqName);
                if (igvChr == null || igvChr.equals(seqName)) continue;
                this.chrNameMap.put(igvChr, seqName);
            }
        }
    }

    @Override
    protected DataTile getRawData(String chr, int start, int end) {
        if (chr.equals("All")) {
            return null;
        }
        if (this.currentInterval != null && this.currentInterval.contains(chr, start, end)) {
            return this.currentInterval.tile;
        }
        IntArrayList startsList = new IntArrayList(100000);
        IntArrayList endsList = new IntArrayList(100000);
        FloatArrayList valuesList = new FloatArrayList(100000);
        String chrAlias = this.chrNameMap.containsKey(chr) ? this.chrNameMap.get(chr) : chr;
        BigBedIterator bedIterator = this.reader.getBigBedIterator(chrAlias, start, chrAlias, end, false);
        while (bedIterator.hasNext()) {
            BedFeature feat = (BedFeature)bedIterator.next();
            startsList.add(feat.getStartBase());
            endsList.add(feat.getEndBase());
        }
        DataTile tile = new DataTile(startsList.toArray(), endsList.toArray(), valuesList.toArray(), null);
        this.currentInterval = new RawDataInterval(chr, start, end, tile);
        return tile;
    }

    @Override
    protected List<LocusScore> getPrecomputedSummaryScores(String chr, int startLocation, int endLocation, int zoom) {
        return null;
    }

    @Override
    public int getLongestFeature(String chr) {
        return 1;
    }

    @Override
    public double getDataMax() {
        return 100.0;
    }

    @Override
    public double getDataMin() {
        return 0.0;
    }

    @Override
    public TrackType getTrackType() {
        return null;
    }

    static class RawDataInterval {
        String chr;
        int start;
        int end;
        DataTile tile;

        RawDataInterval(String chr, int start, int end, DataTile tile) {
            this.chr = chr;
            this.start = start;
            this.end = end;
            this.tile = tile;
        }

        public boolean contains(String chr, int start, int end) {
            return chr.equals(this.chr) && start >= this.start && end <= this.end;
        }
    }
}

