/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.maf;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.TextCigarCodec;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.broad.igv.Globals;
import org.broad.igv.feature.genome.ChromosomeNameComparator;
import org.broad.igv.tools.sort.SAMSorter;
import org.broad.igv.tools.sort.Sorter;
import org.broad.igv.tools.sort.SorterFactory;
import org.broad.igv.util.ParsingUtils;

public class MAFtoSAM {
    public static void main(String[] args) throws IOException {
        String inputPath = args[0];
        String outputPath = args.length > 1 ? args[1] : null;
        MAFtoSAM.convert(inputPath, outputPath, true, false);
    }

    public static void convert(String path, String outputPath, boolean includeSequence, boolean groupByReadName) throws IOException {
        String line;
        String samOutput = outputPath.endsWith(".sam") ? outputPath : outputPath + ".sam";
        String unsortedOutput = outputPath + ".unsorted.sam";
        String sortedOutput = outputPath + "sorted.sam";
        boolean readCounter = true;
        BufferedReader reader = ParsingUtils.openBufferedReader(path);
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(unsortedOutput)));
        LinkedHashMap<String, Integer> sequenceDictionary = new LinkedHashMap<String, Integer>();
        while ((line = reader.readLine()) != null) {
            if (!line.startsWith("a ")) continue;
            MAFtoSAM.parseBlock(reader, out, sequenceDictionary, includeSequence);
        }
        out.flush();
        out.close();
        reader.close();
        if (groupByReadName) {
            unsortedOutput = MAFtoSAM.combineReads(unsortedOutput);
        }
        Sorter sorter = SorterFactory.getSorter(new File(unsortedOutput), new File(sortedOutput));
        sorter.run();
        out = new PrintWriter(new BufferedWriter(new FileWriter(samOutput)));
        MAFtoSAM.outputHeader(sequenceDictionary, out);
        reader = ParsingUtils.openBufferedReader(sortedOutput);
        while ((line = reader.readLine()) != null) {
            out.println(line);
        }
        out.flush();
        out.close();
        reader.close();
        new File(unsortedOutput).deleteOnExit();
        new File(sortedOutput).deleteOnExit();
    }

    private static String combineReads(String unsortedOutput) throws IOException {
        String line;
        String groupedOutput = unsortedOutput + ".grouped.sam";
        String combinedOutput = unsortedOutput + ".combined.sam";
        Sorter sorter = SorterFactory.getSorter(new File(unsortedOutput), new File(groupedOutput));
        sorter.setComparator(SAMSorter.ReadNameComparator);
        sorter.run();
        BufferedReader reader = new BufferedReader(new FileReader(groupedOutput));
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(combinedOutput)));
        String[] lastRecord = null;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("@")) {
                out.println(line);
                continue;
            }
            String[] record = Globals.tabPattern.split(line);
            if (lastRecord != null && lastRecord[0].equals(record[0])) {
                String newCigar;
                Cigar lastCigar = TextCigarCodec.decode(lastRecord[5]);
                int lastEnd = Integer.parseInt(lastRecord[3]) + lastCigar.getReferenceLength() - 1;
                int gap = Integer.parseInt(record[3]) - lastEnd - 1;
                if (gap < 1) {
                    MAFtoSAM.printRecord(out, lastRecord);
                    lastRecord = record;
                    continue;
                }
                lastRecord[5] = newCigar = lastRecord[5] + gap + "D" + record[5];
                if (lastRecord[9].equals("*") || record[9].equals("*")) {
                    lastRecord[9] = "*";
                    continue;
                }
                lastRecord[9] = lastRecord[9] + record[9];
                continue;
            }
            if (lastRecord != null) {
                MAFtoSAM.printRecord(out, lastRecord);
            }
            lastRecord = record;
        }
        if (lastRecord != null) {
            MAFtoSAM.printRecord(out, lastRecord);
        }
        out.flush();
        out.close();
        new File(combinedOutput).deleteOnExit();
        return combinedOutput;
    }

    private static void printRecord(PrintWriter out, String[] record) {
        out.print(record[0]);
        for (int i2 = 1; i2 < record.length; ++i2) {
            out.print("\t" + record[i2]);
        }
        out.println();
    }

    private static SAMRecord combineRecords(SAMRecord lastRecord, SAMRecord record) {
        return null;
    }

    private static void parseBlock(BufferedReader reader, PrintWriter out, Map<String, Integer> sequenceDictionary, boolean includeSequence) throws IOException {
        String line;
        SequenceLine referenceLine = null;
        byte[] refBytes = null;
        String chr = null;
        while ((line = reader.readLine()) != null) {
            if (line.trim().length() == 0) {
                return;
            }
            if (!line.startsWith("s ")) continue;
            if (null == referenceLine) {
                referenceLine = MAFtoSAM.parseSequenceLine(line);
                refBytes = referenceLine.text.getBytes();
                if (referenceLine.src.contains(".")) {
                    int idx = referenceLine.src.lastIndexOf(46) + 1;
                    chr = referenceLine.src.substring(idx);
                } else {
                    chr = referenceLine.src;
                }
                sequenceDictionary.put(chr, referenceLine.srcSize);
                continue;
            }
            SequenceLine queryLine = MAFtoSAM.parseSequenceLine(line);
            byte[] queryBytes = queryLine.text.getBytes();
            if (queryBytes.length != refBytes.length) {
                throw new RuntimeException("Query and ref sequence unequal length");
            }
            String cigarString = "";
            for (int i2 = 0; i2 < queryBytes.length; ++i2) {
                byte q2 = queryBytes[i2];
                byte ref = refBytes[i2];
                if (q2 == 45) {
                    if (ref == 45) continue;
                    cigarString = cigarString + "D";
                    continue;
                }
                cigarString = ref == 45 ? cigarString + "I" : cigarString + "M";
            }
            cigarString = MAFtoSAM.collapseCigar(cigarString);
            String qname = queryLine.src;
            int flag = 0;
            int start = referenceLine.start + 1;
            int mapq = 30;
            String rnext = "*";
            int pnext = 0;
            int tlen = 0;
            String seq = includeSequence ? MAFtoSAM.collapseSequence(queryLine.text) : "*";
            String qual = "*";
            out.println(qname + "\t" + flag + "\t" + chr + "\t" + start + "\t" + mapq + "\t" + cigarString + "\t" + rnext + "\t" + pnext + "\t" + tlen + "\t" + seq + "\t" + qual);
        }
    }

    private static void outputHeader(Map<String, Integer> sequenceDictionary, PrintWriter out) {
        ArrayList<String> chrNames = new ArrayList<String>(sequenceDictionary.keySet());
        Collections.sort(chrNames, ChromosomeNameComparator.get());
        out.println("@HD\tVN:1.5\t SO:coordinate");
        for (String chr : chrNames) {
            out.println("@SQ\tSN:" + chr + "\tLN:" + sequenceDictionary.get(chr));
        }
    }

    private static String collapseCigar(String cigarString) {
        if (cigarString.length() == 0) {
            return "";
        }
        String collapsedCigar = "";
        char lastOperator = cigarString.charAt(0);
        int counter = 1;
        for (int i2 = 1; i2 < cigarString.length(); ++i2) {
            if (cigarString.charAt(i2) == lastOperator) {
                ++counter;
                continue;
            }
            collapsedCigar = collapsedCigar + "" + counter + lastOperator;
            lastOperator = cigarString.charAt(i2);
            counter = 1;
        }
        collapsedCigar = collapsedCigar + "" + counter + lastOperator;
        return collapsedCigar;
    }

    private static String collapseSequence(String text) {
        return text.replaceAll("-", "");
    }

    private static SequenceLine parseSequenceLine(String line) throws IOException {
        String[] tokens = Globals.whitespacePattern.split(line);
        SequenceLine sl = new SequenceLine();
        sl.src = tokens[1];
        sl.start = Integer.parseInt(tokens[2]);
        sl.size = Integer.parseInt(tokens[3]);
        sl.strand = tokens[4].charAt(0);
        sl.srcSize = Integer.parseInt(tokens[5]);
        sl.text = tokens[6];
        return sl;
    }

    static class SequenceLine {
        String src;
        int start;
        int size;
        char strand;
        int srcSize;
        String text;

        SequenceLine() {
        }
    }
}

