/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import org.broad.igv.Globals;
import org.broad.igv.feature.UCSCSnpFeature;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.UCSCCodec;

public class UCSCSnpCodec
extends UCSCCodec<UCSCSnpFeature> {
    private Genome genome;

    public UCSCSnpCodec(Genome genome) {
        super(UCSCSnpFeature.class);
        this.genome = genome;
    }

    @Override
    public UCSCSnpFeature decode(String s2) {
        String[] tokens = Globals.tabPattern.split(s2);
        if (tokens.length < 25) {
            return null;
        }
        String chr = tokens[1];
        if (this.genome != null) {
            chr = this.genome.getCanonicalChrName(chr);
        }
        int start = Integer.parseInt(tokens[2]);
        int end = Integer.parseInt(tokens[3]);
        return new UCSCSnpFeature(chr, start, end, tokens);
    }

    @Override
    public boolean canDecode(String path) {
        String fn = path.toLowerCase();
        if (fn.endsWith(".gz")) {
            fn = fn.substring(0, fn.length() - 3);
        }
        return fn.toLowerCase().endsWith(".snp");
    }
}

