/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import org.broad.igv.Globals;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.PSLRecord;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.UCSCCodec;

public class PSLCodec
extends UCSCCodec<BasicFeature> {
    Genome genome;
    boolean keepText;

    public PSLCodec() {
        this((Genome)null);
    }

    public PSLCodec(Genome genome) {
        this(genome, false);
    }

    public PSLCodec(Genome genome, boolean keepText) {
        super(BasicFeature.class);
        this.genome = genome;
        this.keepText = keepText;
    }

    @Override
    public PSLRecord decode(String line) {
        PSLRecord f2 = null;
        try {
            if (line.trim().length() == 0 || line.startsWith("#") || line.startsWith("track") || line.startsWith("browser") || line.startsWith("psLayout") || line.startsWith("match") || line.startsWith("---")) {
                return null;
            }
            String[] tokens = Globals.singleTabMultiSpacePattern.split(line);
            int nTokens = tokens.length;
            if (nTokens < 21) {
                return null;
            }
            int tSize = Integer.parseInt(tokens[14]);
            String chrToken = tokens[13];
            String chr = this.genome == null ? chrToken : this.genome.getCanonicalChrName(chrToken);
            int start = Integer.parseInt(tokens[15]);
            String strandString = tokens[8];
            Strand strand = strandString.startsWith("+") ? Strand.POSITIVE : Strand.NEGATIVE;
            boolean gNeg = false;
            if (strandString.length() > 1) {
                gNeg = strandString.charAt(1) == '-';
            }
            f2 = new PSLRecord();
            f2.setName(tokens[9]);
            f2.setChr(chr);
            f2.setStart(start);
            f2.setEnd(Integer.parseInt(tokens[16]));
            f2.setStrand(strand);
            int exonCount = Integer.parseInt(tokens[17]);
            String[] exonSizes = tokens[18].split(",");
            String[] startsBuffer = tokens[20].split(",");
            if (startsBuffer.length == exonSizes.length && exonCount == startsBuffer.length) {
                for (int i2 = 0; i2 < startsBuffer.length; ++i2) {
                    int exonSize = Integer.parseInt(exonSizes[i2]);
                    int exonStart = Integer.parseInt(startsBuffer[i2]);
                    if (gNeg) {
                        exonStart = tSize - exonStart - exonSize;
                    }
                    int exonEnd = exonStart + exonSize;
                    Exon exon = new Exon(chr, exonStart, exonEnd, strand);
                    f2.addExon(exon);
                }
            }
            int match = Integer.parseInt(tokens[0]);
            int misMatch = Integer.parseInt(tokens[1]);
            int repMatch = Integer.parseInt(tokens[2]);
            int ns = Integer.parseInt(tokens[3]);
            int qGapCount = Integer.parseInt(tokens[4]);
            int qGapBases = Integer.parseInt(tokens[5]);
            int tGapCount = Integer.parseInt(tokens[6]);
            int tGapBases = Integer.parseInt(tokens[7]);
            int qSize = Integer.parseInt(tokens[10]);
            float score = 1000.0f * (float)(match + repMatch - misMatch - qGapCount - tGapCount) / (float)qSize;
            f2.setMatch(match);
            f2.setMisMatch(misMatch);
            f2.setRepMatch(repMatch);
            f2.setNs(ns);
            f2.setQGapCount(qGapCount);
            f2.setQGapBases(qGapBases);
            f2.setTGapCount(tGapCount);
            f2.setTGapBases(tGapBases);
            f2.setQSize(qSize);
            f2.setScore(score);
            StringBuffer desc = new StringBuffer();
            desc.append("matches = " + tokens[0]);
            desc.append("<br>");
            desc.append("mismatches = " + tokens[1]);
            desc.append("<br>");
            desc.append("repeat matches = " + tokens[2]);
            desc.append("<br>");
            desc.append("# inserts in query = " + tokens[4]);
            desc.append("<br>");
            desc.append("# inserts in target = " + tokens[6]);
            f2.setDescription(desc.toString());
            if (this.keepText) {
                f2.setText(line);
            }
        }
        catch (NumberFormatException e2) {
            return null;
        }
        return f2;
    }

    @Override
    public boolean canDecode(String path) {
        return path.toLowerCase().endsWith(".psl") || path.toLowerCase().endsWith(".psl.gz");
    }
}

