/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.basepair;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.basepair.BasePairData;
import org.broad.igv.feature.basepair.BasePairFeature;
import org.broad.igv.track.RenderContext;

public class BasePairRenderer {
    private static Logger log = Logger.getLogger(BasePairRenderer.class);
    Color ARC_COLOR_A = new Color(50, 50, 150, 140);
    Color ARC_COLOR_B = new Color(150, 50, 50, 140);
    Color ARC_COLOR_C = new Color(50, 0, 50, 250);
    int dir = -1;
    Color COLOR_CENTERLINE = new Color(0, 0, 0, 100);

    public int getDirection() {
        return this.dir;
    }

    public void setDirection(int d2) {
        this.dir = d2;
    }

    public void draw(BasePairData data, RenderContext context, Rectangle trackRectangle) {
        int start;
        double nucsPerPixel = context.getScale();
        double origin = context.getOrigin();
        int end = (int)(origin + (double)trackRectangle.width * nucsPerPixel) + 1;
        if (end <= (start = Math.max(0, (int)origin - 1))) {
            return;
        }
        List<BasePairFeature> featureList = data.getFeatures(context.getChr());
        if (featureList != null) {
            for (BasePairFeature feature : featureList) {
                if ((double)feature.startLeft > context.getEndLocation()) break;
                if ((double)feature.endRight < context.getOrigin()) continue;
                int arcCount = 0;
                double startLeftPix = ((double)feature.startLeft - origin) / nucsPerPixel;
                double startRightPix = ((double)feature.startRight + 1.0 - origin) / nucsPerPixel;
                double endLeftPix = ((double)feature.endLeft - origin) / nucsPerPixel;
                double endRightPix = ((double)feature.endRight + 1.0 - origin) / nucsPerPixel;
                this.drawArc(startLeftPix, startRightPix, endLeftPix, endRightPix, trackRectangle, context, feature.color);
                ++arcCount;
            }
        }
    }

    protected void drawArc(double startLeft, double startRight, double endLeft, double endRight, Rectangle trackRectangle, RenderContext context, Color featureColor) {
        Color color = featureColor != null ? featureColor : this.ARC_COLOR_A;
        Graphics2D g2D = context.getGraphic2DForColor(color);
        if (PreferenceManager.getInstance().getAsBoolean("ENABLE_ANTIALIASING")) {
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        int maxPossibleArcHeight = (trackRectangle.height - 1) / 2;
        double handleLengthFactor = 4.0 * (Math.sqrt(2.0) - 1.0) / 3.0;
        double outerRadius = (endRight - startLeft) / 2.0;
        double innerRadius = (endLeft - startRight) / 2.0;
        double arcWidth = Math.max(1.0, startRight - startLeft);
        int y = 0;
        y = this.dir > 0 ? (int)trackRectangle.getMaxY() : (int)trackRectangle.getMinY();
        int outerLX = (int)(trackRectangle.getX() + startLeft);
        int outerLY = y;
        int outerLC1X = (int)(trackRectangle.getX() + (double)outerLX);
        int outerLC1Y = (int)((double)outerLY - (double)this.dir * handleLengthFactor * outerRadius);
        int outerLC2X = (int)(trackRectangle.getX() + (double)outerLX + outerRadius - handleLengthFactor * outerRadius);
        int outerLC2Y = (int)((double)outerLY - (double)this.dir * outerRadius);
        int outerCenterX = (int)(trackRectangle.getX() + (double)outerLX + outerRadius);
        int outerCenterY = (int)((double)outerLY - (double)this.dir * outerRadius);
        int outerRC1X = (int)(trackRectangle.getX() + (double)outerLX + outerRadius + handleLengthFactor * outerRadius);
        int outerRC1Y = (int)((double)outerLY - (double)this.dir * outerRadius);
        int outerRC2X = (int)(trackRectangle.getX() + endRight);
        int outerRC2Y = (int)((double)outerLY - (double)this.dir * handleLengthFactor * outerRadius);
        int outerRX = (int)(trackRectangle.getX() + endRight);
        int outerRY = outerLY;
        int innerRX = (int)(trackRectangle.getX() + endRight - arcWidth);
        int innerRY = outerLY;
        int innerRC1X = (int)(trackRectangle.getX() + (double)innerRX);
        int innerRC1Y = (int)((double)outerLY - (double)this.dir * handleLengthFactor * innerRadius);
        int innerRC2X = (int)(trackRectangle.getX() + (double)outerLX + outerRadius + handleLengthFactor * innerRadius);
        int innerRC2Y = (int)((double)outerCenterY + (double)this.dir * arcWidth);
        int innerCenterX = (int)(trackRectangle.getX() + (double)outerLX + outerRadius);
        int innerCenterY = (int)((double)outerCenterY + (double)this.dir * arcWidth);
        int innerLC1X = (int)(trackRectangle.getX() + (double)outerLX + outerRadius - handleLengthFactor * innerRadius);
        int innerLC1Y = (int)((double)outerCenterY + (double)this.dir * arcWidth);
        int innerLC2X = (int)(trackRectangle.getX() + startLeft + arcWidth);
        int innerLC2Y = (int)((double)outerLY - (double)this.dir * handleLengthFactor * innerRadius);
        int innerLX = (int)(trackRectangle.getX() + startLeft + arcWidth);
        int innerLY = outerLY;
        GeneralPath arcPath = new GeneralPath();
        arcPath.moveTo(outerLX, outerLY);
        arcPath.curveTo(outerLC1X, outerLC1Y, outerLC2X, outerLC2Y, outerCenterX, outerCenterY);
        arcPath.curveTo(outerRC1X, outerRC1Y, outerRC2X, outerRC2Y, outerRX, outerRY);
        arcPath.lineTo(innerRX, innerRY);
        arcPath.curveTo(innerRC1X, innerRC1Y, innerRC2X, innerRC2Y, innerCenterX, innerCenterY);
        arcPath.curveTo(innerLC1X, innerLC1Y, innerLC2X, innerLC2Y, innerLX, innerLY);
        arcPath.lineTo(outerLX, outerLY);
        arcPath.moveTo(outerLX, outerLY);
        arcPath.closePath();
        g2D.fill(arcPath);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
    }
}

