/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.cufflinks;

import java.awt.Color;
import java.util.List;
import org.broad.igv.data.cufflinks.CufflinksDataSource;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.track.DataTrack;
import org.broad.igv.track.Track;
import org.broad.igv.util.ResourceLocator;

public class CufflinksTrack
extends DataTrack {
    CufflinksDataSource dataSource;

    public CufflinksTrack(ResourceLocator locator, String id, String name, CufflinksDataSource dataSource) {
        super(locator, id, name);
        this.dataSource = dataSource;
    }

    @Override
    public List<LocusScore> getSummaryScores(String chr, int startLocation, int endLocation, int zoom) {
        return this.dataSource.getSummaryScoresForRange(chr, startLocation, endLocation, zoom);
    }

    static boolean isExpDiff(String path) {
        return path != null && path.toLowerCase().endsWith("_exp.diff");
    }

    public static void setCufflinksScale(Track inputTrack) {
        String path;
        String string = path = inputTrack.getResourceLocator() != null ? inputTrack.getResourceLocator().getPath() : null;
        if (CufflinksTrack.isExpDiff(path)) {
            float range = Math.min(5.0f, Math.abs(Math.max(inputTrack.getDataRange().getMinimum(), inputTrack.getDataRange().getMaximum())));
            inputTrack.setDataRange(new DataRange(-range, 0.0f, range));
            inputTrack.setColor(Color.RED);
            inputTrack.setAltColor(Color.BLUE);
            inputTrack.setColorScale(new ContinuousColorScale(-range, 0.0, range, Color.RED, Color.WHITE, Color.BLUE));
        } else {
            inputTrack.setDataRange(new DataRange(inputTrack.getDataRange().getMinimum(), 0.0f, inputTrack.getDataRange().getMaximum()));
        }
    }
}

