/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.tribble.readers.AsciiLineReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.data.ChromosomeData;
import org.broad.igv.data.ChromosomeSummary;
import org.broad.igv.data.GenomeSummaryData;
import org.broad.igv.data.IGVDataset;
import org.broad.igv.exceptions.ParserException;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.collections.FloatArrayList;
import org.broad.igv.util.collections.IntArrayList;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;

public class IGVDatasetParser {
    private static Logger log = Logger.getLogger(IGVDatasetParser.class);
    private ResourceLocator dataResourceLocator;
    private int chrColumn = -1;
    private int startColumn = -1;
    private int endColumn = -1;
    private int firstDataColumn = -1;
    private int lastDataColumn = -1;
    private int probeColumn = -1;
    private boolean hasEndLocations = false;
    private boolean hasCalls = false;
    private Genome genome;
    private IGV igv;
    private int startBase = 0;

    public IGVDatasetParser(ResourceLocator copyNoFile, Genome genome) {
        this.dataResourceLocator = copyNoFile;
        this.genome = genome;
        this.igv = IGV.hasInstance() ? IGV.getInstance() : null;
    }

    private void setColumnDefaults() {
        String tmp = (this.dataResourceLocator.getPath().endsWith(".txt") ? this.dataResourceLocator.getPath().substring(0, this.dataResourceLocator.getPath().length() - 4) : this.dataResourceLocator.getPath()).toLowerCase();
        if (tmp.endsWith(".igv")) {
            this.chrColumn = 0;
            this.startColumn = 1;
            this.endColumn = 2;
            this.probeColumn = 3;
            this.firstDataColumn = 4;
            this.hasEndLocations = true;
            this.hasCalls = false;
        } else if (tmp.endsWith(".xcn") || tmp.endsWith("cn") || tmp.endsWith(".snp") || tmp.endsWith(".loh")) {
            this.probeColumn = 0;
            this.chrColumn = 1;
            this.startColumn = 2;
            this.endColumn = -1;
            this.firstDataColumn = 3;
            this.hasEndLocations = false;
            this.hasCalls = tmp.endsWith(".xcn") || tmp.endsWith(".snp");
        } else if (tmp.endsWith(".expr")) {
            this.probeColumn = 0;
            this.chrColumn = 2;
            this.startColumn = 3;
            this.endColumn = 4;
            this.startBase = 1;
            this.firstDataColumn = 5;
            this.lastDataColumn = 5;
            this.hasEndLocations = true;
        } else {
            throw new ParserException("Unknown file type: ", 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean parsableMAGE_TAB(ResourceLocator file) throws IOException {
        AsciiLineReader reader = null;
        try {
            reader = ParsingUtils.openAsciiReader(file);
            String nextLine = null;
            reader.readLine();
            nextLine = reader.readLine();
            if (nextLine != null && (nextLine.contains("Reporter REF") || nextLine.contains("Composite Element REF") || nextLine.contains("Term Source REF") || nextLine.contains("CompositeElement REF") || nextLine.contains("TermSource REF") || nextLine.contains("Coordinates REF"))) {
                for (int count = 0; (nextLine = reader.readLine()) != null && count < 5; ++count) {
                    if (!(nextLine = nextLine.trim()).startsWith("SNP_A") && !nextLine.startsWith("CN_")) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return false;
    }

    public List<ChromosomeSummary> scan(IGVDataset dataset) {
        boolean logNormalized;
        int estLineCount = ParsingUtils.estimateLineCount(this.dataResourceLocator.getPath());
        HashMap<String, Integer> longestFeatureMap = new HashMap<String, Integer>();
        float dataMin = 0.0f;
        float dataMax = 0.0f;
        InputStream is = null;
        AsciiLineReader reader = null;
        String nextLine = null;
        ChromosomeSummary chrSummary = null;
        ArrayList<ChromosomeSummary> chrSummaries = new ArrayList<ChromosomeSummary>();
        String[] headings = null;
        WholeGenomeData wgData = null;
        int nRows = 0;
        int headerRows = 0;
        int count = 0;
        try {
            int skipColumns = this.hasCalls ? 2 : 1;
            is = ParsingUtils.openInputStreamGZ(this.dataResourceLocator);
            reader = new AsciiLineReader(is);
            if (this.isCopyNumberFileExt(this.dataResourceLocator.getPath())) {
                dataset.setTrackType(TrackType.COPY_NUMBER);
                dataset.getTrackProperties().setWindowingFunction(WindowFunction.mean);
            } else if (this.isLOHFileExt(this.dataResourceLocator.getPath())) {
                dataset.setTrackType(TrackType.LOH);
                dataset.getTrackProperties().setWindowingFunction(WindowFunction.mean);
            } else {
                dataset.getTrackProperties().setWindowingFunction(WindowFunction.mean);
            }
            nextLine = reader.readLine();
            while (nextLine.startsWith("#") || nextLine.trim().length() == 0) {
                ++headerRows;
                if (nextLine.length() > 0) {
                    this.parseDirective(nextLine, dataset);
                }
                nextLine = reader.readLine();
            }
            if (this.chrColumn < 0) {
                this.setColumnDefaults();
            }
            String[] data = nextLine.trim().split("\t");
            if (this.lastDataColumn < 0) {
                this.lastDataColumn = data.length - 1;
            }
            headings = this.getHeadings(data, skipColumns);
            dataset.setDataHeadings(headings);
            logNormalized = false;
            wgData = new WholeGenomeData(headings);
            int chrRowCount = 0;
            int updateCount = 5000;
            long lastPosition = 0L;
            while ((nextLine = reader.readLine()) != null) {
                String[] tokens;
                int nTokens;
                if (this.igv != null && ++count % updateCount == 0) {
                    this.igv.setStatusBarMessage("Loaded: " + count + " / " + estLineCount + " (est)");
                }
                if ((nTokens = (tokens = Globals.tabPattern.split(nextLine, -1)).length) > 0) {
                    String thisChr = this.genome.getCanonicalChrName(tokens[this.chrColumn]);
                    if (chrSummary == null || !thisChr.equals(chrSummary.getName())) {
                        if (chrSummary != null) {
                            this.updateWholeGenome(chrSummary.getName(), dataset, headings, wgData);
                            chrSummary.setNDataPoints(nRows);
                        }
                        chrSummary = new ChromosomeSummary(thisChr, lastPosition);
                        chrSummaries.add(chrSummary);
                        nRows = 0;
                        wgData = new WholeGenomeData(headings);
                        chrRowCount = 0;
                    }
                    lastPosition = reader.getPosition();
                    int location = -1;
                    try {
                        location = ParsingUtils.parseInt(tokens[this.startColumn]) - this.startBase;
                    }
                    catch (NumberFormatException numberFormatException) {
                        log.error("Column " + tokens[this.startColumn] + " is not a number");
                        throw new ParserException("Column " + (this.startColumn + 1) + " must contain an integer value." + " Found: " + tokens[this.startColumn], count + headerRows, nextLine);
                    }
                    int length = 1;
                    if (this.hasEndLocations) {
                        try {
                            length = ParsingUtils.parseInt(tokens[this.endColumn].trim()) - location + 1;
                        }
                        catch (NumberFormatException numberFormatException) {
                            log.error("Column " + tokens[this.endColumn] + " is not a number");
                            throw new ParserException("Column " + (this.endColumn + 1) + " must contain an integer value." + " Found: " + tokens[this.endColumn], count + headerRows, nextLine);
                        }
                    }
                    this.updateLongestFeature(longestFeatureMap, thisChr, length);
                    if (wgData.locations.size() > 0 && wgData.locations.get(wgData.locations.size() - 1) > location) {
                        throw new ParserException("File is not sorted, .igv and .cn files must be sorted by start position. Use igvtools (File > Run igvtools..) to sort the file.", count + headerRows);
                    }
                    wgData.locations.add(location);
                    for (int idx = 0; idx < headings.length; ++idx) {
                        float copyNo;
                        int i2 = this.firstDataColumn + idx * skipColumns;
                        float f2 = copyNo = i2 < tokens.length ? this.readFloat(tokens[i2]) : Float.NaN;
                        if (!Float.isNaN(copyNo)) {
                            dataMin = Math.min(dataMin, copyNo);
                            dataMax = Math.max(dataMax, copyNo);
                        }
                        if (copyNo < 0.0f) {
                            logNormalized = true;
                        }
                        String heading = headings[idx];
                        wgData.data.get(heading).add(copyNo);
                    }
                    ++nRows;
                }
                ++chrRowCount;
            }
            dataset.setLongestFeatureMap(longestFeatureMap);
        }
        catch (ParserException pe) {
            throw pe;
        }
        catch (FileNotFoundException e2) {
            log.error("File not found: " + this.dataResourceLocator);
            throw new RuntimeException(e2);
        }
        catch (Exception e3) {
            log.error("Exception when loading: " + this.dataResourceLocator.getPath(), e3);
            if (nextLine != null && count + headerRows != 0) {
                throw new ParserException(e3.getMessage(), (Throwable)e3, count + headerRows, nextLine);
            }
            throw new RuntimeException(e3);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e4) {
                    log.error("Error closing IGVDataset stream", e4);
                }
            }
        }
        if (chrSummary != null) {
            this.updateWholeGenome(chrSummary.getName(), dataset, headings, wgData);
            chrSummary.setNDataPoints(nRows);
        }
        dataset.setLogNormalized(logNormalized);
        dataset.setDataMin(dataMin);
        dataset.setDataMax(dataMax);
        return chrSummaries;
    }

    private void updateLongestFeature(Map<String, Integer> longestFeatureMap, String thisChr, int length) {
        if (longestFeatureMap.containsKey(thisChr)) {
            longestFeatureMap.put(thisChr, Math.max(longestFeatureMap.get(thisChr), length));
        } else {
            longestFeatureMap.put(thisChr, length);
        }
    }

    private float readFloat(String token) {
        float copyNo = Float.NaN;
        try {
            if (token != null) {
                copyNo = Float.parseFloat(token);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return copyNo;
    }

    public ChromosomeData loadChromosomeData(ChromosomeSummary chrSummary, String[] dataHeaders) {
        try {
            int skipColumns = this.hasCalls ? 2 : 1;
            int nRowsEst = chrSummary.getNDataPts();
            SeekableStream is = IGVSeekableStreamFactory.getInstance().getStreamFor(this.dataResourceLocator.getPath());
            is.seek(chrSummary.getStartPosition());
            AsciiLineReader reader = new AsciiLineReader(is);
            IntArrayList startLocations = new IntArrayList(nRowsEst);
            IntArrayList endLocations = this.hasEndLocations ? new IntArrayList(nRowsEst) : null;
            ArrayList<String> probes = new ArrayList<String>(nRowsEst);
            HashMap<String, FloatArrayList> dataMap = new HashMap<String, FloatArrayList>();
            for (String h2 : dataHeaders) {
                dataMap.put(h2, new FloatArrayList(nRowsEst));
            }
            String chromosome = chrSummary.getName();
            boolean chromosomeStarted = false;
            String nextLine = reader.readLine();
            while (nextLine != null && nextLine.trim().length() > 0) {
                if (!nextLine.startsWith("#")) {
                    try {
                        String[] tokens = Globals.tabPattern.split(nextLine, -1);
                        String thisChromosome = this.genome.getCanonicalChrName(tokens[this.chrColumn].trim());
                        if (thisChromosome.equals(chromosome)) {
                            chromosomeStarted = true;
                            String probe = new String(tokens[this.probeColumn]);
                            probes.add(probe);
                            int start = ParsingUtils.parseInt(tokens[this.startColumn].trim()) - this.startBase;
                            if (this.hasEndLocations) {
                                endLocations.add(ParsingUtils.parseInt(tokens[this.endColumn].trim()));
                            }
                            startLocations.add(start);
                            if (tokens.length <= this.firstDataColumn + (dataHeaders.length - 1) * skipColumns) {
                                String msg = "Line has too few data columns: " + nextLine;
                                log.error(msg);
                                throw new RuntimeException(msg);
                            }
                            for (int idx = 0; idx < dataHeaders.length; ++idx) {
                                int i2 = this.firstDataColumn + idx * skipColumns;
                                float copyNo = i2 <= this.lastDataColumn ? this.readFloat(tokens[i2]) : Float.NaN;
                                String heading = dataHeaders[idx];
                                ((FloatArrayList)dataMap.get(heading)).add(copyNo);
                            }
                        } else if (chromosomeStarted) {
                            break;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        log.info("Skipping line (NumberFormatException) " + nextLine);
                    }
                }
                nextLine = reader.readLine();
            }
            ChromosomeData cd = new ChromosomeData(chrSummary.getName());
            cd.setProbes(probes.toArray(new String[0]));
            cd.setStartLocations(startLocations.toArray());
            if (this.hasEndLocations) {
                cd.setEndLocations(endLocations.toArray());
            }
            for (String h3 : dataHeaders) {
                cd.setData(h3, ((FloatArrayList)dataMap.get(h3)).toArray());
            }
            return cd;
        }
        catch (IOException ex) {
            log.error("Error parsing cn file", ex);
            throw new RuntimeException("Error parsing cn file", ex);
        }
    }

    private void parseDirective(String comment, IGVDataset dataset) {
        String tmp = comment.substring(1, comment.length());
        if (tmp.startsWith("track")) {
            ParsingUtils.parseTrackLine(tmp, dataset.getTrackProperties());
        } else if (tmp.startsWith("columns")) {
            this.parseColumnLine(tmp);
        } else {
            String[] tokens = tmp.split("=");
            if (tokens.length != 2) {
                return;
            }
            String key = tokens[0].trim().toLowerCase();
            if (key.equals("name")) {
                dataset.setName(tokens[1].trim());
            } else if (key.equals("type")) {
                try {
                    dataset.setTrackType(TrackType.valueOf(tokens[1].trim().toUpperCase()));
                }
                catch (Exception exception) {}
            } else if (key.equals("coords")) {
                this.startBase = Integer.parseInt(tokens[1].trim());
            }
        }
    }

    private boolean isCopyNumberFileExt(String filename) {
        String tmp = (filename.endsWith(".txt") || filename.endsWith(".tab") || filename.endsWith(".xls") ? filename.substring(0, filename.length() - 4) : filename).toLowerCase();
        return tmp.endsWith(".cn") || tmp.endsWith(".xcn") || tmp.endsWith(".snp");
    }

    private boolean isLOHFileExt(String filename) {
        String tmp = filename.endsWith(".txt") || filename.endsWith(".tab") || filename.endsWith(".xls") ? filename.substring(0, filename.length() - 4) : filename;
        return tmp.endsWith(".loh");
    }

    public String[] getHeadings(String[] tokens, int skipColumns) {
        return this.getHeadings(tokens, skipColumns, false);
    }

    public String[] getHeadings(String[] tokens, int skipColumns, boolean removeDuplicates) {
        ArrayList<String> headings = new ArrayList<String>();
        String previousHeading = null;
        for (int i2 = this.firstDataColumn; i2 <= this.lastDataColumn; i2 += skipColumns) {
            if (removeDuplicates) {
                if (previousHeading != null && tokens[i2].equals(previousHeading) || tokens[i2].equals("")) continue;
                previousHeading = tokens[i2];
            }
            headings.add(tokens[i2].trim());
        }
        return headings.toArray(new String[0]);
    }

    private void parseColumnLine(String tmp) {
        String[] tokens = tmp.split("\\s+");
        String neg_colnum = "Error parsing column line: " + tmp + "<br>Column numbers must be > 0";
        if (tokens.length > 1) {
            for (int i2 = 1; i2 < tokens.length; ++i2) {
                String[] kv = tokens[i2].split("=");
                if (kv.length != 2) continue;
                if (kv[0].toLowerCase().equals("chr")) {
                    int c2 = Integer.parseInt(kv[1]);
                    if (c2 < 1) {
                        MessageUtils.showMessage(neg_colnum);
                        continue;
                    }
                    this.chrColumn = c2 - 1;
                    continue;
                }
                if (kv[0].toLowerCase().equals("start")) {
                    int c3 = Integer.parseInt(kv[1]);
                    if (c3 < 1) {
                        MessageUtils.showMessage(neg_colnum);
                        continue;
                    }
                    this.startColumn = c3 - 1;
                    continue;
                }
                if (kv[0].toLowerCase().equals("end")) {
                    int c4 = Integer.parseInt(kv[1]);
                    if (c4 < 1) {
                        MessageUtils.showMessage(neg_colnum);
                        continue;
                    }
                    this.endColumn = c4 - 1;
                    this.hasEndLocations = true;
                    continue;
                }
                if (kv[0].toLowerCase().equals("probe")) {
                    int c5 = Integer.parseInt(kv[1]);
                    if (c5 < 1) {
                        MessageUtils.showMessage(neg_colnum);
                        continue;
                    }
                    this.probeColumn = c5 - 1;
                    continue;
                }
                if (!kv[0].toLowerCase().equals("data")) continue;
                String[] se = kv[1].split("-");
                int c6 = Integer.parseInt(se[0]);
                if (c6 < 1) {
                    MessageUtils.showMessage(neg_colnum);
                } else {
                    this.firstDataColumn = c6 - 1;
                }
                if (se.length <= 1) continue;
                c6 = Integer.parseInt(se[1]);
                if (c6 < 1) {
                    MessageUtils.showMessage(neg_colnum);
                    continue;
                }
                this.lastDataColumn = c6 - 1;
            }
        }
    }

    private void updateWholeGenome(String currentChromosome, IGVDataset dataset, String[] headings, WholeGenomeData wgData) {
        if (!this.genome.getHomeChromosome().equals("All")) {
            return;
        }
        int[] locations = wgData.locations.toArray();
        if (locations.length > 0) {
            HashMap<String, float[]> tmp = new HashMap<String, float[]>(wgData.data.size());
            for (String s2 : wgData.headings) {
                tmp.put(s2, wgData.data.get(s2).toArray());
            }
            GenomeSummaryData genomeSummary = dataset.getGenomeSummary();
            if (genomeSummary == null) {
                genomeSummary = new GenomeSummaryData(this.genome, headings);
                dataset.setGenomeSummary(genomeSummary);
            }
            genomeSummary.addData(currentChromosome, locations, tmp);
        }
    }

    class WholeGenomeData {
        String[] headings;
        IntArrayList locations = new IntArrayList(50000);
        Map<String, FloatArrayList> data = new HashMap<String, FloatArrayList>();

        WholeGenomeData(String[] headings) {
            this.headings = headings;
            for (String h2 : headings) {
                this.data.put(h2, new FloatArrayList(50000));
            }
        }

        int size() {
            return this.locations.size();
        }
    }
}

