/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.util.ArrayList;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.RuntimeUtils;

public class DatasetSizeTest {
    static int nPoints = 100000;
    static int nSample = 1000;

    public static void main(String[] args) {
        int i2;
        for (i2 = 0; i2 < 5; ++i2) {
            DatasetSizeTest.testArrays();
        }
        for (i2 = 0; i2 < 5; ++i2) {
            DatasetSizeTest.testLocusScores();
        }
    }

    static void testArrays() {
        System.gc();
        int[] starts = new int[nPoints];
        int[] ends = new int[nPoints];
        float[][] values = new float[nPoints][nSample];
        String[] probes = new String[nPoints];
        for (int i2 = 0; i2 < nPoints; ++i2) {
            starts[i2] = i2;
            ends[i2] = i2;
            for (int j2 = 0; j2 < nSample; ++j2) {
                values[i2][j2] = i2 * j2;
            }
            probes[i2] = "probe" + i2;
        }
        long mem = RuntimeUtils.getAvailableMemory();
        ends = null;
        starts = null;
        values = null;
        probes = null;
        System.gc();
        System.gc();
        long mem2 = RuntimeUtils.getAvailableMemory();
        System.out.println("Memory used = " + (mem2 - mem) / 1000000L);
    }

    static void testLocusScores() {
        System.gc();
        ArrayList<TestScore> scores = new ArrayList<TestScore>(nPoints);
        for (int i2 = 0; i2 < nPoints; ++i2) {
            for (int j2 = 0; j2 < nSample; ++j2) {
                scores.add(new TestScore(i2, "probe" + i2, i2, i2));
            }
        }
        long mem = RuntimeUtils.getAvailableMemory();
        scores = null;
        System.gc();
        System.gc();
        long mem2 = RuntimeUtils.getAvailableMemory();
        System.out.println("Memory used = " + (mem2 - mem) / 1000000L);
    }

    static class TestScore
    implements LocusScore {
        int start;
        int end;
        float score;
        String name;

        TestScore(int end, String name, float score, int start) {
            this.end = end;
            this.name = name;
            this.score = score;
            this.start = start;
        }

        @Override
        public void setStart(int start) {
        }

        @Override
        public void setEnd(int end) {
        }

        @Override
        public float getScore() {
            return 0.0f;
        }

        public LocusScore copy() {
            return null;
        }

        @Override
        public String getValueString(double position, WindowFunction windowFunction) {
            return null;
        }

        @Override
        public String getChr() {
            return null;
        }

        @Override
        public String getContig() {
            return null;
        }

        @Override
        public int getStart() {
            return 0;
        }

        @Override
        public int getEnd() {
            return 0;
        }
    }
}

