/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.charts;

import java.util.LinkedHashMap;
import org.broad.igv.charts.ScatterPlotData;
import org.broad.igv.charts.ScatterPlotFrame;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.util.UIUtilities;

public class ScatterPlotDemo {
    private static int igvSampleCount;
    private static ScatterPlotData igvData;
    private static ScatterPlotFrame igvPlotFrame;

    public ScatterPlotDemo(int sampleCount) {
        igvData = this.getTestData(sampleCount);
        igvPlotFrame = new ScatterPlotFrame(igvData);
        UIUtilities.invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                igvPlotFrame.setVisible(true);
            }
        });
    }

    public ScatterPlotData getTestData(int sampleCount) {
        String[] samples = new String[sampleCount];
        double[] cnData = new double[sampleCount];
        double[] exprData = new double[sampleCount];
        double[] methData = new double[sampleCount];
        for (int i2 = 0; i2 < sampleCount; ++i2) {
            samples[i2] = "Sample " + i2;
            double x2 = (double)(i2 - sampleCount / 2) * 3.1415 / (double)sampleCount;
            double y = 5.0 * Math.sin(i2);
            cnData[i2] = x2;
            exprData[i2] = y;
            methData[i2] = y;
        }
        LinkedHashMap<String, double[]> dataMap = new LinkedHashMap<String, double[]>();
        dataMap.put(TrackType.COPY_NUMBER.toString(), cnData);
        dataMap.put(TrackType.GENE_EXPRESSION.toString(), exprData);
        dataMap.put(TrackType.DNA_METHYLATION.toString(), methData);
        String[] treated = new String[sampleCount];
        String[] hyperMutated = new String[sampleCount];
        String[] cluster = new String[sampleCount];
        for (int i3 = 0; i3 < sampleCount; ++i3) {
            double classValue;
            String string = treated[i3] = Math.random() > 0.5 ? "AA" : "B";
            if (i3 % 6 == 0) {
                treated[i3] = "null";
            }
            String string2 = hyperMutated[i3] = Math.random() > 0.9 ? "Y" : "N";
            if (i3 % 7 == 0) {
                hyperMutated[i3] = "null";
            }
            cluster[i3] = (classValue = Math.random()) > 0.9 ? "Proneural" : (classValue > 0.8 ? "neural" : (classValue > 0.6 ? "classical" : (classValue > 0.4 ? "mesenchymal" : "unknown")));
        }
        LinkedHashMap<String, String[]> symbolMap = new LinkedHashMap<String, String[]>();
        symbolMap.put("Treatment", treated);
        symbolMap.put("Hyper mutated", hyperMutated);
        symbolMap.put("Cluster Type", cluster);
        int[] mutationCount = new int[sampleCount];
        for (int i4 = 0; i4 < sampleCount; ++i4) {
            mutationCount[i4] = (int)(2.0 * Math.random());
        }
        return new ScatterPlotData("Test", samples, symbolMap, dataMap, mutationCount);
    }

    public static void main(String[] args) {
        int demoPoints = 500;
        ScatterPlotDemo demo = new ScatterPlotDemo(demoPoints);
    }
}

