/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.direct;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.optimization.GoalType;
import org.apache.commons.math.optimization.OptimizationException;
import org.apache.commons.math.optimization.RealPointValuePair;
import org.apache.commons.math.optimization.general.AbstractScalarDifferentiableOptimizer;
import org.apache.commons.math.optimization.univariate.AbstractUnivariateRealOptimizer;
import org.apache.commons.math.optimization.univariate.BracketFinder;
import org.apache.commons.math.optimization.univariate.BrentOptimizer;

public class PowellOptimizer
extends AbstractScalarDifferentiableOptimizer {
    public static final double DEFAULT_LS_RELATIVE_TOLERANCE = 1.0E-7;
    public static final double DEFAULT_LS_ABSOLUTE_TOLERANCE = 1.0E-11;
    private final LineSearch line;

    public PowellOptimizer() {
        this(1.0E-7, 1.0E-11);
    }

    public PowellOptimizer(double lsRelativeTolerance) {
        this(lsRelativeTolerance, 1.0E-11);
    }

    public PowellOptimizer(double lsRelativeTolerance, double lsAbsoluteTolerance) {
        this.line = new LineSearch(lsRelativeTolerance, lsAbsoluteTolerance);
    }

    protected RealPointValuePair doOptimize() throws FunctionEvaluationException, OptimizationException {
        double[] guess = (double[])this.point.clone();
        int n2 = guess.length;
        double[][] direc = new double[n2][n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            direc[i2][i2] = 1.0;
        }
        double[] x2 = guess;
        double fVal = this.computeObjectiveValue(x2);
        double[] x1 = (double[])x2.clone();
        while (true) {
            this.incrementIterationsCounter();
            double fX = fVal;
            double fX2 = 0.0;
            double delta = 0.0;
            int bigInd = 0;
            double alphaMin = 0.0;
            for (int i3 = 0; i3 < n2; ++i3) {
                double[] d2 = this.copyOf(direc[i3], n2);
                fX2 = fVal;
                this.line.search(x2, d2);
                fVal = this.line.getValueAtOptimum();
                alphaMin = this.line.getOptimum();
                double[][] result = this.newPointAndDirection(x2, d2, alphaMin);
                x2 = result[0];
                if (!(fX2 - fVal > delta)) continue;
                delta = fX2 - fVal;
                bigInd = i3;
            }
            RealPointValuePair previous = new RealPointValuePair(x1, fX);
            RealPointValuePair current = new RealPointValuePair(x2, fVal);
            if (this.getConvergenceChecker().converged(this.getIterations(), previous, current)) {
                if (this.goal == GoalType.MINIMIZE) {
                    return fVal < fX ? current : previous;
                }
                return fVal > fX ? current : previous;
            }
            double[] d3 = new double[n2];
            double[] x22 = new double[n2];
            for (int i4 = 0; i4 < n2; ++i4) {
                d3[i4] = x2[i4] - x1[i4];
                x22[i4] = 2.0 * x2[i4] - x1[i4];
            }
            x1 = (double[])x2.clone();
            fX2 = this.computeObjectiveValue(x22);
            if (!(fX > fX2)) continue;
            double t2 = 2.0 * (fX + fX2 - 2.0 * fVal);
            double temp = fX - fVal - delta;
            t2 *= temp * temp;
            temp = fX - fX2;
            if (!((t2 -= delta * temp * temp) < 0.0)) continue;
            this.line.search(x2, d3);
            fVal = this.line.getValueAtOptimum();
            alphaMin = this.line.getOptimum();
            double[][] result = this.newPointAndDirection(x2, d3, alphaMin);
            x2 = result[0];
            int lastInd = n2 - 1;
            direc[bigInd] = direc[lastInd];
            direc[lastInd] = result[1];
        }
    }

    private double[][] newPointAndDirection(double[] p2, double[] d2, double optimum) {
        int n2 = p2.length;
        double[][] result = new double[2][n2];
        double[] nP = result[0];
        double[] nD = result[1];
        for (int i2 = 0; i2 < n2; ++i2) {
            nD[i2] = d2[i2] * optimum;
            nP[i2] = p2[i2] + nD[i2];
        }
        return result;
    }

    private double[] copyOf(double[] source, int newLen) {
        double[] output = new double[newLen];
        System.arraycopy(source, 0, output, 0, Math.min(source.length, newLen));
        return output;
    }

    private class LineSearch {
        private final AbstractUnivariateRealOptimizer optim = new BrentOptimizer();
        private final BracketFinder bracket = new BracketFinder();
        private double optimum = Double.NaN;
        private double valueAtOptimum = Double.NaN;

        public LineSearch(double relativeTolerance, double absoluteTolerance) {
            this.optim.setRelativeAccuracy(relativeTolerance);
            this.optim.setAbsoluteAccuracy(absoluteTolerance);
        }

        public void search(final double[] p2, final double[] d2) throws OptimizationException, FunctionEvaluationException {
            this.optimum = Double.NaN;
            this.valueAtOptimum = Double.NaN;
            try {
                final int n2 = p2.length;
                UnivariateRealFunction f2 = new UnivariateRealFunction(){

                    public double value(double alpha) throws FunctionEvaluationException {
                        double[] x2 = new double[n2];
                        for (int i2 = 0; i2 < n2; ++i2) {
                            x2[i2] = p2[i2] + alpha * d2[i2];
                        }
                        double obj = PowellOptimizer.this.computeObjectiveValue(x2);
                        return obj;
                    }
                };
                this.bracket.search(f2, PowellOptimizer.this.goal, 0.0, 1.0);
                this.optimum = this.optim.optimize(f2, PowellOptimizer.this.goal, this.bracket.getLo(), this.bracket.getHi(), this.bracket.getMid());
                this.valueAtOptimum = this.optim.getFunctionValue();
            }
            catch (MaxIterationsExceededException e2) {
                throw new OptimizationException(e2);
            }
        }

        public double getOptimum() {
            return this.optimum;
        }

        public double getValueAtOptimum() {
            return this.valueAtOptimum;
        }
    }
}

