/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.linear.DecompositionSolver;
import org.apache.commons.math.linear.DefaultRealMatrixPreservingVisitor;
import org.apache.commons.math.linear.EigenDecomposition;
import org.apache.commons.math.linear.EigenDecompositionImpl;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealVector;
import org.apache.commons.math.linear.SingularValueDecomposition;
import org.apache.commons.math.util.FastMath;

public class SingularValueDecompositionImpl
implements SingularValueDecomposition {
    private int m;
    private int n;
    private EigenDecomposition eigenDecomposition;
    private double[] singularValues;
    private RealMatrix cachedU;
    private RealMatrix cachedUt;
    private RealMatrix cachedS;
    private RealMatrix cachedV;
    private RealMatrix cachedVt;

    public SingularValueDecompositionImpl(RealMatrix matrix) throws InvalidMatrixException {
        int i2;
        int p2;
        this.m = matrix.getRowDimension();
        this.n = matrix.getColumnDimension();
        this.cachedU = null;
        this.cachedS = null;
        this.cachedV = null;
        this.cachedVt = null;
        double[][] localcopy = matrix.getData();
        double[][] matATA = new double[this.n][this.n];
        for (int i3 = 0; i3 < this.n; ++i3) {
            for (int j2 = i3; j2 < this.n; ++j2) {
                matATA[i3][j2] = 0.0;
                for (int k2 = 0; k2 < this.m; ++k2) {
                    double[] dArray = matATA[i3];
                    int n2 = j2;
                    dArray[n2] = dArray[n2] + localcopy[k2][i3] * localcopy[k2][j2];
                }
                matATA[j2][i3] = matATA[i3][j2];
            }
        }
        double[][] matAAT = new double[this.m][this.m];
        for (int i4 = 0; i4 < this.m; ++i4) {
            for (int j3 = i4; j3 < this.m; ++j3) {
                matAAT[i4][j3] = 0.0;
                for (int k3 = 0; k3 < this.n; ++k3) {
                    double[] dArray = matAAT[i4];
                    int n3 = j3;
                    dArray[n3] = dArray[n3] + localcopy[i4][k3] * localcopy[j3][k3];
                }
                matAAT[j3][i4] = matAAT[i4][j3];
            }
        }
        if (this.m >= this.n) {
            p2 = this.n;
            this.eigenDecomposition = new EigenDecompositionImpl(new Array2DRowRealMatrix(matATA), 1.0);
            this.singularValues = this.eigenDecomposition.getRealEigenvalues();
            this.cachedV = this.eigenDecomposition.getV();
            this.eigenDecomposition = new EigenDecompositionImpl(new Array2DRowRealMatrix(matAAT), 1.0);
            this.cachedU = this.eigenDecomposition.getV().getSubMatrix(0, this.m - 1, 0, p2 - 1);
        } else {
            p2 = this.m;
            this.eigenDecomposition = new EigenDecompositionImpl(new Array2DRowRealMatrix(matAAT), 1.0);
            this.singularValues = this.eigenDecomposition.getRealEigenvalues();
            this.cachedU = this.eigenDecomposition.getV();
            this.eigenDecomposition = new EigenDecompositionImpl(new Array2DRowRealMatrix(matATA), 1.0);
            this.cachedV = this.eigenDecomposition.getV().getSubMatrix(0, this.n - 1, 0, p2 - 1);
        }
        for (i2 = 0; i2 < p2; ++i2) {
            this.singularValues[i2] = FastMath.sqrt(FastMath.abs(this.singularValues[i2]));
        }
        for (i2 = 0; i2 < p2; ++i2) {
            RealVector tmp = this.cachedU.getColumnVector(i2);
            double product = matrix.operate(this.cachedV.getColumnVector(i2)).dotProduct(tmp);
            if (!(product < 0.0)) continue;
            this.cachedU.setColumnVector(i2, tmp.mapMultiply(-1.0));
        }
    }

    public RealMatrix getU() throws InvalidMatrixException {
        return this.cachedU;
    }

    public RealMatrix getUT() throws InvalidMatrixException {
        if (this.cachedUt == null) {
            this.cachedUt = this.getU().transpose();
        }
        return this.cachedUt;
    }

    public RealMatrix getS() throws InvalidMatrixException {
        if (this.cachedS == null) {
            this.cachedS = MatrixUtils.createRealDiagonalMatrix(this.singularValues);
        }
        return this.cachedS;
    }

    public double[] getSingularValues() throws InvalidMatrixException {
        return (double[])this.singularValues.clone();
    }

    public RealMatrix getV() throws InvalidMatrixException {
        return this.cachedV;
    }

    public RealMatrix getVT() throws InvalidMatrixException {
        if (this.cachedVt == null) {
            this.cachedVt = this.getV().transpose();
        }
        return this.cachedVt;
    }

    public RealMatrix getCovariance(double minSingularValue) {
        int dimension;
        int p2 = this.singularValues.length;
        for (dimension = 0; dimension < p2 && this.singularValues[dimension] >= minSingularValue; ++dimension) {
        }
        if (dimension == 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.TOO_LARGE_CUTOFF_SINGULAR_VALUE, minSingularValue, this.singularValues[0]);
        }
        final double[][] data = new double[dimension][p2];
        this.getVT().walkInOptimizedOrder(new DefaultRealMatrixPreservingVisitor(){

            public void visit(int row, int column, double value) {
                data[row][column] = value / SingularValueDecompositionImpl.this.singularValues[row];
            }
        }, 0, dimension - 1, 0, p2 - 1);
        Array2DRowRealMatrix jv = new Array2DRowRealMatrix(data, false);
        return jv.transpose().multiply(jv);
    }

    public double getNorm() throws InvalidMatrixException {
        return this.singularValues[0];
    }

    public double getConditionNumber() throws InvalidMatrixException {
        return this.singularValues[0] / this.singularValues[this.singularValues.length - 1];
    }

    public int getRank() throws IllegalStateException {
        double threshold = (double)FastMath.max(this.m, this.n) * FastMath.ulp(this.singularValues[0]);
        for (int i2 = this.singularValues.length - 1; i2 >= 0; --i2) {
            if (!(this.singularValues[i2] > threshold)) continue;
            return i2 + 1;
        }
        return 0;
    }

    public DecompositionSolver getSolver() {
        return new Solver(this.singularValues, this.getUT(), this.getV(), this.getRank() == Math.max(this.m, this.n));
    }

    private static class Solver
    implements DecompositionSolver {
        private final RealMatrix pseudoInverse;
        private boolean nonSingular;

        private Solver(double[] singularValues, RealMatrix uT, RealMatrix v2, boolean nonSingular) {
            double[][] suT = uT.getData();
            for (int i2 = 0; i2 < singularValues.length; ++i2) {
                double a2 = singularValues[i2] > 0.0 ? 1.0 / singularValues[i2] : 0.0;
                double[] suTi = suT[i2];
                int j2 = 0;
                while (j2 < suTi.length) {
                    int n2 = j2++;
                    suTi[n2] = suTi[n2] * a2;
                }
            }
            this.pseudoInverse = v2.multiply(new Array2DRowRealMatrix(suT, false));
            this.nonSingular = nonSingular;
        }

        public double[] solve(double[] b2) throws IllegalArgumentException {
            return this.pseudoInverse.operate(b2);
        }

        public RealVector solve(RealVector b2) throws IllegalArgumentException {
            return this.pseudoInverse.operate(b2);
        }

        public RealMatrix solve(RealMatrix b2) throws IllegalArgumentException {
            return this.pseudoInverse.multiply(b2);
        }

        public boolean isNonSingular() {
            return this.nonSingular;
        }

        public RealMatrix getInverse() {
            return this.pseudoInverse;
        }
    }
}

