/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.solvers;

import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.solvers.UnivariateRealSolver;
import org.apache.commons.math.analysis.solvers.UnivariateRealSolverFactory;
import org.apache.commons.math.exception.NullArgumentException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.util.FastMath;

public class UnivariateRealSolverUtils {
    private UnivariateRealSolverUtils() {
    }

    public static double solve(UnivariateRealFunction f2, double x0, double x1) throws ConvergenceException, FunctionEvaluationException {
        UnivariateRealSolverUtils.setup(f2);
        return LazyHolder.FACTORY.newDefaultSolver().solve(f2, x0, x1);
    }

    public static double solve(UnivariateRealFunction f2, double x0, double x1, double absoluteAccuracy) throws ConvergenceException, FunctionEvaluationException {
        UnivariateRealSolverUtils.setup(f2);
        UnivariateRealSolver solver = LazyHolder.FACTORY.newDefaultSolver();
        solver.setAbsoluteAccuracy(absoluteAccuracy);
        return solver.solve(f2, x0, x1);
    }

    public static double[] bracket(UnivariateRealFunction function, double initial, double lowerBound, double upperBound) throws ConvergenceException, FunctionEvaluationException {
        return UnivariateRealSolverUtils.bracket(function, initial, lowerBound, upperBound, Integer.MAX_VALUE);
    }

    public static double[] bracket(UnivariateRealFunction function, double initial, double lowerBound, double upperBound, int maximumIterations) throws ConvergenceException, FunctionEvaluationException {
        double fb;
        double fa;
        if (function == null) {
            throw new NullArgumentException(LocalizedFormats.FUNCTION);
        }
        if (maximumIterations <= 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INVALID_MAX_ITERATIONS, maximumIterations);
        }
        if (initial < lowerBound || initial > upperBound || lowerBound >= upperBound) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INVALID_BRACKETING_PARAMETERS, lowerBound, initial, upperBound);
        }
        double a2 = initial;
        double b2 = initial;
        int numIterations = 0;
        do {
            a2 = FastMath.max(a2 - 1.0, lowerBound);
            b2 = FastMath.min(b2 + 1.0, upperBound);
        } while ((fa = function.value(a2)) * (fb = function.value(b2)) > 0.0 && ++numIterations < maximumIterations && (a2 > lowerBound || b2 < upperBound));
        if (fa * fb > 0.0) {
            throw new ConvergenceException(LocalizedFormats.FAILED_BRACKETING, numIterations, maximumIterations, initial, lowerBound, upperBound, a2, b2, fa, fb);
        }
        return new double[]{a2, b2};
    }

    public static double midpoint(double a2, double b2) {
        return (a2 + b2) * 0.5;
    }

    private static void setup(UnivariateRealFunction f2) {
        if (f2 == null) {
            throw new NullArgumentException(LocalizedFormats.FUNCTION);
        }
    }

    private static class LazyHolder {
        private static final UnivariateRealSolverFactory FACTORY = UnivariateRealSolverFactory.newInstance();

        private LazyHolder() {
        }
    }
}

