/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.jexl2.internal.AbstractExecutor;
import org.apache.commons.jexl2.internal.Introspector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertySetExecutor
extends AbstractExecutor.Set {
    private static final int SET_START_INDEX = 3;
    private final String property;

    public PropertySetExecutor(Introspector is, Class<?> clazz, String identifier, Object arg) {
        super(clazz, PropertySetExecutor.discover(is, clazz, identifier, arg));
        this.property = identifier;
    }

    @Override
    public Object getTargetProperty() {
        return this.property;
    }

    @Override
    public Object execute(Object o2, Object arg) throws IllegalAccessException, InvocationTargetException {
        Object[] pargs = new Object[]{arg};
        if (this.method != null) {
            this.method.invoke(o2, pargs);
        }
        return arg;
    }

    @Override
    public Object tryExecute(Object o2, Object identifier, Object arg) {
        if (o2 != null && this.method != null && this.property.equals(identifier) && this.objectClass.equals(o2.getClass()) && (arg == null || this.method.getParameterTypes()[0].equals(arg.getClass()))) {
            try {
                return this.execute(o2, arg);
            }
            catch (InvocationTargetException xinvoke) {
                return TRY_FAILED;
            }
            catch (IllegalAccessException xill) {
                return TRY_FAILED;
            }
        }
        return TRY_FAILED;
    }

    private static Method discover(Introspector is, Class<?> clazz, String property, Object arg) {
        Object[] params = new Object[]{arg};
        StringBuilder sb = new StringBuilder("set");
        sb.append(property);
        char c2 = sb.charAt(3);
        sb.setCharAt(3, Character.toUpperCase(c2));
        Method method = is.getMethod(clazz, sb.toString(), params);
        if (method == null) {
            sb.setCharAt(3, Character.toLowerCase(c2));
            method = is.getMethod(clazz, sb.toString(), params);
        }
        return method;
    }
}

