/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.image;

import java.awt.image.BufferedImage;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.OutputStream;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.resources.Messages;
import org.apache.batik.transcoder.keys.FloatKey;
import org.apache.batik.transcoder.keys.IntegerKey;

public class PNGTranscoder
extends ImageTranscoder {
    public static final TranscodingHints.Key KEY_GAMMA = new FloatKey();
    public static final float[] DEFAULT_CHROMA = new float[]{0.3127f, 0.329f, 0.64f, 0.33f, 0.3f, 0.6f, 0.15f, 0.06f};
    public static final TranscodingHints.Key KEY_INDEXED = new IntegerKey();

    public PNGTranscoder() {
        this.hints.put(ImageTranscoder.KEY_FORCE_TRANSPARENT_WHITE, Boolean.FALSE);
    }

    public UserAgent getUserAgent() {
        return this.userAgent;
    }

    public BufferedImage createImage(int width, int height) {
        return new BufferedImage(width, height, 2);
    }

    private WriteAdapter getWriteAdapter(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            WriteAdapter adapter = (WriteAdapter)clazz.newInstance();
            return adapter;
        }
        catch (ClassNotFoundException e2) {
            return null;
        }
        catch (InstantiationException e3) {
            return null;
        }
        catch (IllegalAccessException e4) {
            return null;
        }
    }

    public void writeImage(BufferedImage img, TranscoderOutput output) throws TranscoderException {
        WriteAdapter adapter;
        OutputStream ostream = output.getOutputStream();
        if (ostream == null) {
            throw new TranscoderException(Messages.formatMessage("png.badoutput", null));
        }
        boolean forceTransparentWhite = false;
        if (this.hints.containsKey(ImageTranscoder.KEY_FORCE_TRANSPARENT_WHITE)) {
            forceTransparentWhite = (Boolean)this.hints.get(ImageTranscoder.KEY_FORCE_TRANSPARENT_WHITE);
        }
        if (forceTransparentWhite) {
            SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)img.getSampleModel();
            this.forceTransparentWhite(img, sppsm);
        }
        if ((adapter = this.getWriteAdapter("org.apache.batik.ext.awt.image.codec.png.PNGTranscoderInternalCodecWriteAdapter")) == null) {
            adapter = this.getWriteAdapter("org.apache.batik.transcoder.image.PNGTranscoderImageIOWriteAdapter");
        }
        if (adapter == null) {
            throw new TranscoderException("Could not write PNG file because no WriteAdapter is availble");
        }
        adapter.writeImage(this, img, output);
    }

    public static interface WriteAdapter {
        public void writeImage(PNGTranscoder var1, BufferedImage var2, TranscoderOutput var3) throws TranscoderException;
    }
}

