/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.batik.gvt.font.AWTFontFamily;
import org.apache.batik.gvt.font.AWTGVTFont;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.gvt.font.UnresolvedFontFamily;

public class FontFamilyResolver {
    public static final AWTFontFamily defaultFont = new AWTFontFamily("SansSerif");
    protected static final Map fonts = new HashMap();
    protected static final List awtFontFamilies = new ArrayList();
    protected static final List awtFonts = new ArrayList();
    protected static final Map resolvedFontFamilies;

    public static String lookup(String familyName) {
        return (String)fonts.get(familyName.toLowerCase());
    }

    public static GVTFontFamily resolve(String familyName) {
        GVTFontFamily resolvedFF = (GVTFontFamily)resolvedFontFamilies.get(familyName = familyName.toLowerCase());
        if (resolvedFF == null) {
            String awtFamilyName = (String)fonts.get(familyName);
            if (awtFamilyName != null) {
                resolvedFF = new AWTFontFamily(awtFamilyName);
            }
            resolvedFontFamilies.put(familyName, resolvedFF);
        }
        return resolvedFF;
    }

    public static GVTFontFamily resolve(UnresolvedFontFamily fontFamily) {
        return FontFamilyResolver.resolve(fontFamily.getFamilyName());
    }

    public static GVTFontFamily getFamilyThatCanDisplay(char c2) {
        int i2 = 0;
        while (i2 < awtFontFamilies.size()) {
            AWTFontFamily fontFamily = (AWTFontFamily)awtFontFamilies.get(i2);
            AWTGVTFont font = (AWTGVTFont)awtFonts.get(i2);
            if (font.canDisplay(c2) && fontFamily.getFamilyName().indexOf("Song") == -1) {
                return fontFamily;
            }
            ++i2;
        }
        return null;
    }

    static {
        fonts.put("sans-serif", "SansSerif");
        fonts.put("serif", "Serif");
        fonts.put("times", "Serif");
        fonts.put("times new roman", "Serif");
        fonts.put("cursive", "Dialog");
        fonts.put("fantasy", "Symbol");
        fonts.put("monospace", "Monospaced");
        fonts.put("monospaced", "Monospaced");
        fonts.put("courier", "Monospaced");
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = env.getAvailableFontFamilyNames();
        int nFonts = fontNames != null ? fontNames.length : 0;
        int i2 = 0;
        while (i2 < nFonts) {
            fonts.put(fontNames[i2].toLowerCase(), fontNames[i2]);
            StringTokenizer st = new StringTokenizer(fontNames[i2]);
            String fontNameWithoutSpaces = "";
            while (st.hasMoreTokens()) {
                fontNameWithoutSpaces = fontNameWithoutSpaces + st.nextToken();
            }
            fonts.put(fontNameWithoutSpaces.toLowerCase(), fontNames[i2]);
            String fontNameWithDashes = fontNames[i2].replace(' ', '-');
            if (!fontNameWithDashes.equals(fontNames[i2])) {
                fonts.put(fontNameWithDashes.toLowerCase(), fontNames[i2]);
            }
            ++i2;
        }
        awtFontFamilies.add(defaultFont);
        awtFonts.add(new AWTGVTFont(defaultFont.getFamilyName(), 0, 12));
        Collection fontValues = fonts.values();
        Iterator iter = fontValues.iterator();
        while (iter.hasNext()) {
            String fontFamily = (String)iter.next();
            AWTFontFamily awtFontFamily = new AWTFontFamily(fontFamily);
            awtFontFamilies.add(awtFontFamily);
            AWTGVTFont font = new AWTGVTFont(fontFamily, 0, 12);
            awtFonts.add(font);
        }
        resolvedFontFamilies = new HashMap();
    }
}

