/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.svg;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.ListValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;
import org.apache.batik.css.engine.value.svg.ColorManager;
import org.apache.batik.css.engine.value.svg.ICCColor;
import org.apache.batik.css.engine.value.svg.SVGValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class SVGColorManager
extends ColorManager {
    protected String property;
    protected Value defaultValue;

    public SVGColorManager(String prop) {
        this(prop, ValueConstants.BLACK_RGB_VALUE);
    }

    public SVGColorManager(String prop, Value v2) {
        this.property = prop;
        this.defaultValue = v2;
    }

    public boolean isInheritedProperty() {
        return false;
    }

    public boolean isAnimatableProperty() {
        return true;
    }

    public boolean isAdditiveProperty() {
        return true;
    }

    public int getPropertyType() {
        return 6;
    }

    public String getPropertyName() {
        return this.property;
    }

    public Value getDefaultValue() {
        return this.defaultValue;
    }

    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        if (lu.getLexicalUnitType() == 35 && lu.getStringValue().equalsIgnoreCase("currentcolor")) {
            return SVGValueConstants.CURRENTCOLOR_VALUE;
        }
        Value v2 = super.createValue(lu, engine);
        if ((lu = lu.getNextLexicalUnit()) == null) {
            return v2;
        }
        if (lu.getLexicalUnitType() != 41 || !lu.getFunctionName().equalsIgnoreCase("icc-color")) {
            throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
        }
        if ((lu = lu.getParameters()).getLexicalUnitType() != 35) {
            throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
        }
        ListValue result = new ListValue(' ');
        result.append(v2);
        ICCColor icc = new ICCColor(lu.getStringValue());
        result.append(icc);
        lu = lu.getNextLexicalUnit();
        while (lu != null) {
            if (lu.getLexicalUnitType() != 0) {
                throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
            }
            if ((lu = lu.getNextLexicalUnit()) == null) {
                throw this.createInvalidLexicalUnitDOMException((short)-1);
            }
            icc.append(this.getColorValue(lu));
            lu = lu.getNextLexicalUnit();
        }
        return result;
    }

    public Value computeValue(CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm, Value value) {
        if (value == SVGValueConstants.CURRENTCOLOR_VALUE) {
            sm.putColorRelative(idx, true);
            int ci = engine.getColorIndex();
            return engine.getComputedStyle(elt, pseudo, ci);
        }
        if (value.getCssValueType() == 2) {
            ListValue lv = (ListValue)value;
            Value v2 = lv.item(0);
            Value t2 = super.computeValue(elt, pseudo, engine, idx, sm, v2);
            if (t2 != v2) {
                ListValue result = new ListValue(' ');
                result.append(t2);
                result.append(lv.item(1));
                return result;
            }
            return value;
        }
        return super.computeValue(elt, pseudo, engine, idx, sm, value);
    }

    protected float getColorValue(LexicalUnit lu) {
        switch (lu.getLexicalUnitType()) {
            case 13: {
                return lu.getIntegerValue();
            }
            case 14: {
                return lu.getFloatValue();
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
    }
}

