/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util.zip;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.util.zip.IntelDeflater;
import java.lang.reflect.Constructor;
import java.util.zip.Deflater;

public class DeflaterFactory {
    private static Constructor<IntelDeflater> intelDeflaterConstructor;

    public static Deflater makeDeflater(int compressionLevel, boolean nowrap) {
        if (intelDeflaterConstructor != null) {
            try {
                return intelDeflaterConstructor.newInstance(compressionLevel, nowrap);
            }
            catch (Exception e2) {
                throw new SAMException("Exception constructing IntelDeflater", e2);
            }
        }
        return new Deflater(compressionLevel, nowrap);
    }

    public static boolean usingIntelDeflater() {
        return intelDeflaterConstructor != null;
    }

    static {
        try {
            if (Defaults.TRY_USE_INTEL_DEFLATER) {
                Class<?> clazz = Class.forName("htsjdk.samtools.util.zip.IntelDeflater");
                intelDeflaterConstructor = clazz.getConstructor(Integer.TYPE, Boolean.TYPE);
            }
        }
        catch (ClassNotFoundException e2) {
            intelDeflaterConstructor = null;
        }
        catch (NoSuchMethodException e3) {
            intelDeflaterConstructor = null;
        }
        catch (UnsatisfiedLinkError e4) {
            intelDeflaterConstructor = null;
        }
    }
}

