/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.rans.RANS;
import htsjdk.samtools.cram.io.ExternalCompression;
import htsjdk.samtools.cram.structure.BlockCompressionMethod;
import java.io.IOException;

public abstract class ExternalCompressor {
    private final BlockCompressionMethod method;

    private ExternalCompressor(BlockCompressionMethod method) {
        this.method = method;
    }

    public BlockCompressionMethod getMethod() {
        return this.method;
    }

    public abstract byte[] compress(byte[] var1);

    public static ExternalCompressor createRAW() {
        return new ExternalCompressor(BlockCompressionMethod.RAW){

            @Override
            public byte[] compress(byte[] data) {
                return data;
            }
        };
    }

    public static ExternalCompressor createGZIP() {
        return new ExternalCompressor(BlockCompressionMethod.GZIP){

            @Override
            public byte[] compress(byte[] data) {
                try {
                    return ExternalCompression.gzip(data);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
    }

    public static ExternalCompressor createLZMA() {
        return new ExternalCompressor(BlockCompressionMethod.LZMA){

            @Override
            public byte[] compress(byte[] data) {
                try {
                    return ExternalCompression.xz(data);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
    }

    public static ExternalCompressor createBZIP2() {
        return new ExternalCompressor(BlockCompressionMethod.BZIP2){

            @Override
            public byte[] compress(byte[] data) {
                try {
                    return ExternalCompression.bzip2(data);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
    }

    public static ExternalCompressor createRANS(final RANS.ORDER order) {
        return new ExternalCompressor(BlockCompressionMethod.RANS){

            @Override
            public byte[] compress(byte[] data) {
                return ExternalCompression.rans(data, order);
            }
        };
    }
}

