/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Bytes;
import com.mongodb.DBPort;
import com.mongodb.InUseConnectionBean;
import com.mongodb.Java5MongoConnectionPool;
import com.mongodb.MongoConnectionPool;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoInterruptedException;
import com.mongodb.MongoOptions;
import com.mongodb.ServerAddress;
import com.mongodb.util.ConnectionPoolStatisticsBean;
import com.mongodb.util.SimplePool;
import com.mongodb.util.management.JMException;
import com.mongodb.util.management.MBeanServerFactory;
import java.io.InterruptedIOException;
import java.nio.channels.ClosedByInterruptException;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBPortPool
extends SimplePool<DBPort> {
    final MongoOptions _options;
    private final Semaphore _waitingSem;
    final ServerAddress _addr;
    boolean _everWorked = false;

    public String getHost() {
        return this._addr.getHost();
    }

    public int getPort() {
        return this._addr.getPort();
    }

    public synchronized ConnectionPoolStatisticsBean getStatistics() {
        return new ConnectionPoolStatisticsBean(this.getTotal(), this.getInUse(), this.getInUseConnections());
    }

    private InUseConnectionBean[] getInUseConnections() {
        ArrayList<InUseConnectionBean> inUseConnectionInfoList = new ArrayList<InUseConnectionBean>();
        long currentNanoTime = System.nanoTime();
        for (DBPort port : this._out) {
            inUseConnectionInfoList.add(new InUseConnectionBean(port, currentNanoTime));
        }
        return inUseConnectionInfoList.toArray(new InUseConnectionBean[inUseConnectionInfoList.size()]);
    }

    DBPortPool(ServerAddress addr, MongoOptions options) {
        super("DBPortPool-" + addr.toString() + ", options = " + options.toString(), options.connectionsPerHost);
        this._options = options;
        this._addr = addr;
        this._waitingSem = new Semaphore(this._options.connectionsPerHost * this._options.threadsAllowedToBlockForConnectionMultiplier);
    }

    protected long memSize(DBPort p2) {
        return 0L;
    }

    @Override
    protected int pick(int recommended, boolean couldCreate) {
        int id = System.identityHashCode(Thread.currentThread());
        for (int i2 = this._avail.size() - 1; i2 >= 0; --i2) {
            if (((DBPort)this._avail.get((int)i2))._lastThread != id) continue;
            return i2;
        }
        return couldCreate ? -1 : recommended;
    }

    @Override
    public DBPort get() {
        DBPort port = null;
        if (!this._waitingSem.tryAcquire()) {
            throw new SemaphoresOut(this._options.connectionsPerHost * this._options.threadsAllowedToBlockForConnectionMultiplier);
        }
        try {
            port = (DBPort)this.get(this._options.maxWaitTime);
        }
        catch (InterruptedException e2) {
            throw new MongoInterruptedException(e2);
        }
        finally {
            this._waitingSem.release();
        }
        if (port == null) {
            throw new ConnectionWaitTimeOut(this._options.maxWaitTime);
        }
        port._lastThread = System.identityHashCode(Thread.currentThread());
        return port;
    }

    boolean gotError(Exception e2) {
        if (e2 instanceof ClosedByInterruptException) {
            return true;
        }
        if (e2 instanceof InterruptedIOException) {
            return true;
        }
        Bytes.LOGGER.log(Level.WARNING, "emptying DBPortPool to " + this.getServerAddress() + " b/c of error", e2);
        ArrayList<DBPort> all = new ArrayList<DBPort>();
        try {
            DBPort temp;
            while ((temp = (DBPort)this.get(0L)) != null) {
                all.add(temp);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new MongoInterruptedException(interruptedException);
        }
        for (DBPort p2 : all) {
            p2.close();
            this.done(p2);
        }
        return false;
    }

    @Override
    public void cleanup(DBPort p2) {
        p2.close();
    }

    @Override
    protected DBPort createNew() {
        return new DBPort(this._addr, this, this._options);
    }

    public ServerAddress getServerAddress() {
        return this._addr;
    }

    public static class ConnectionWaitTimeOut
    extends NoMoreConnection {
        private static final long serialVersionUID = -4415279469780082174L;

        ConnectionWaitTimeOut(int timeout) {
            super("Connection wait timeout after " + timeout + " ms");
        }
    }

    public static class SemaphoresOut
    extends NoMoreConnection {
        private static final long serialVersionUID = -4415279469780082174L;
        private static final String message = "Concurrent requests for database connection have exceeded limit";

        SemaphoresOut() {
            super(message);
        }

        SemaphoresOut(int numPermits) {
            super("Concurrent requests for database connection have exceeded limit of " + numPermits);
        }
    }

    public static class NoMoreConnection
    extends MongoInternalException {
        private static final long serialVersionUID = -4415279469780082174L;

        NoMoreConnection(String msg) {
            super(msg);
        }
    }

    static class Holder {
        final MongoOptions _options;
        final Map<ServerAddress, DBPortPool> _pools = Collections.synchronizedMap(new HashMap());
        final int _serial = nextSerial.incrementAndGet();
        static AtomicInteger nextSerial;
        static final boolean isJava5;

        Holder(MongoOptions options) {
            this._options = options;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        DBPortPool get(ServerAddress addr) {
            DBPortPool p2 = this._pools.get(addr);
            if (p2 != null) {
                return p2;
            }
            Map<ServerAddress, DBPortPool> map = this._pools;
            synchronized (map) {
                p2 = this._pools.get(addr);
                if (p2 != null) {
                    return p2;
                }
                p2 = this.createPool(addr);
                this._pools.put(addr, p2);
                try {
                    String on = this.createObjectName(addr);
                    if (MBeanServerFactory.getMBeanServer().isRegistered(on)) {
                        MBeanServerFactory.getMBeanServer().unregisterMBean(on);
                        Bytes.LOGGER.log(Level.INFO, "multiple Mongo instances for same host, jmx numbers might be off");
                    }
                    MBeanServerFactory.getMBeanServer().registerMBean(p2, on);
                }
                catch (JMException e2) {
                    Bytes.LOGGER.log(Level.WARNING, "JMX registration error: " + e2 + "\nConsider setting com.mongodb.MongoOptions.alwaysUseMBeans property to true." + "\nContinuing...");
                }
                catch (AccessControlException e3) {
                    Bytes.LOGGER.log(Level.WARNING, "JMX registration error: " + e3 + "\nContinuing...");
                }
            }
            return p2;
        }

        private DBPortPool createPool(ServerAddress addr) {
            if (isJava5 || this._options.isAlwaysUseMBeans()) {
                return new Java5MongoConnectionPool(addr, this._options);
            }
            return new MongoConnectionPool(addr, this._options);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            Map<ServerAddress, DBPortPool> map = this._pools;
            synchronized (map) {
                for (DBPortPool p2 : this._pools.values()) {
                    p2.close();
                    try {
                        String on = this.createObjectName(p2._addr);
                        if (!MBeanServerFactory.getMBeanServer().isRegistered(on)) continue;
                        MBeanServerFactory.getMBeanServer().unregisterMBean(on);
                    }
                    catch (JMException e2) {
                        Bytes.LOGGER.log(Level.WARNING, "jmx de-registration error, continuing", e2);
                    }
                }
            }
        }

        private String createObjectName(ServerAddress addr) {
            String name = "com.mongodb:type=ConnectionPool,host=" + addr.toString().replace(":", ",port=") + ",instance=" + this._serial;
            if (this._options.description != null) {
                name = name + ",description=" + this._options.description;
            }
            return name;
        }

        static {
            isJava5 = System.getProperty("java.version").startsWith("1.5");
            nextSerial = new AtomicInteger(0);
        }
    }
}

