/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental.isomorphism;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.UndirectedGraph;

public class GraphOrdering<V, E> {
    private Map<V, Integer> mapVertexToOrder;
    private Set<LabelsEdge> labelsEdgesSet;

    public GraphOrdering(Graph<V, E> graph) {
        this(graph, graph.vertexSet(), graph.edgeSet());
    }

    public GraphOrdering(Graph<V, E> graph, Set<V> set, Set<E> set2) {
        this.init(graph, set, set2);
    }

    private void init(Graph<V, E> graph, Set<V> set, Set<E> set2) {
        this.mapVertexToOrder = new HashMap<V, Integer>(set.size());
        int n2 = 0;
        for (Object object : set) {
            this.mapVertexToOrder.put((Integer)object, new Integer(n2));
            ++n2;
        }
        this.labelsEdgesSet = new HashSet<LabelsEdge>(set2.size());
        for (Object object : set2) {
            V v2 = graph.getEdgeSource(object);
            Integer n3 = this.mapVertexToOrder.get(v2);
            int n4 = n3;
            int n5 = this.mapVertexToOrder.get(graph.getEdgeTarget(object));
            LabelsEdge labelsEdge = new LabelsEdge(n4, n5);
            this.labelsEdgesSet.add(labelsEdge);
            if (!(graph instanceof UndirectedGraph)) continue;
            LabelsEdge labelsEdge2 = new LabelsEdge(n5, n4);
            this.labelsEdgesSet.add(labelsEdge2);
        }
    }

    public boolean equalsByEdgeOrder(GraphOrdering graphOrdering) {
        boolean bl = ((Object)this.getLabelsEdgesSet()).equals(graphOrdering.getLabelsEdgesSet());
        return bl;
    }

    public Set<LabelsEdge> getLabelsEdgesSet() {
        return this.labelsEdgesSet;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("mapVertexToOrder=");
        Object[] objectArray = new Object[this.mapVertexToOrder.size()];
        Set<V> set = this.mapVertexToOrder.keySet();
        for (V v2 : set) {
            Integer n2 = this.mapVertexToOrder.get(v2);
            objectArray[n2.intValue()] = v2;
        }
        stringBuffer.append(Arrays.toString(objectArray));
        stringBuffer.append("labelsOrder=").append(this.labelsEdgesSet.toString());
        return stringBuffer.toString();
    }

    private class LabelsEdge {
        private int source;
        private int target;
        private int hashCode;

        public LabelsEdge(int n2, int n3) {
            this.source = n2;
            this.target = n3;
            this.hashCode = new String(this.source + "" + this.target).hashCode();
        }

        public boolean equals(Object object) {
            LabelsEdge labelsEdge = (LabelsEdge)object;
            return this.source == labelsEdge.source && this.target == labelsEdge.target;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return this.source + "->" + this.target;
        }
    }
}

