/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.LinkedList;
import java.util.List;
import org.jgrapht.graph.SimpleWeightedGraph;

public class HamiltonianCycle {
    public static <V, E> List<V> getApproximateOptimalForCompleteGraph(SimpleWeightedGraph<V, E> simpleWeightedGraph) {
        LinkedList linkedList = new LinkedList(simpleWeightedGraph.vertexSet());
        if (linkedList.size() * (linkedList.size() - 1) / 2 != simpleWeightedGraph.edgeSet().size()) {
            return null;
        }
        LinkedList linkedList2 = new LinkedList();
        while (linkedList2.size() != simpleWeightedGraph.vertexSet().size()) {
            boolean bl = true;
            double d2 = 0.0;
            int n2 = 0;
            int n3 = 0;
            for (int i2 = 0; i2 < linkedList2.size(); ++i2) {
                Object e2 = linkedList2.get(i2);
                for (int i3 = 0; i3 < linkedList.size(); ++i3) {
                    double d3 = simpleWeightedGraph.getEdgeWeight(simpleWeightedGraph.getEdge(e2, linkedList.get(i3)));
                    if (!bl && !(d3 < d2)) continue;
                    bl = false;
                    d2 = d3;
                    n2 = i3;
                    n3 = i2;
                }
            }
            linkedList2.add(n3, linkedList.get(n2));
            linkedList.remove(n2);
        }
        return linkedList2;
    }
}

