/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import org.jgrapht.Graph;
import org.jgrapht.alg.AbstractPathElement;

final class BellmanFordPathElement<V, E>
extends AbstractPathElement<V, E> {
    private double cost = 0.0;
    private double epsilon;

    protected BellmanFordPathElement(Graph<V, E> graph, BellmanFordPathElement<V, E> bellmanFordPathElement, E e2, double d2, double d3) {
        super(graph, bellmanFordPathElement, e2);
        this.cost = d2;
        this.epsilon = d3;
    }

    BellmanFordPathElement(BellmanFordPathElement<V, E> bellmanFordPathElement) {
        super(bellmanFordPathElement);
        this.cost = bellmanFordPathElement.cost;
        this.epsilon = bellmanFordPathElement.epsilon;
    }

    protected BellmanFordPathElement(V v2, double d2) {
        super(v2);
        this.cost = 0.0;
        this.epsilon = d2;
    }

    public double getCost() {
        return this.cost;
    }

    protected boolean improve(BellmanFordPathElement<V, E> bellmanFordPathElement, E e2, double d2) {
        if (d2 < this.getCost() - this.epsilon) {
            this.prevPathElement = bellmanFordPathElement;
            this.prevEdge = e2;
            this.cost = d2;
            this.nHops = bellmanFordPathElement.getHopCount() + 1;
            return true;
        }
        return false;
    }
}

