/*
 * Decompiled with CFR 0.152.
 */
package org.bson.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class Bits {
    public static void readFully(InputStream in, byte[] b2) throws IOException {
        Bits.readFully(in, b2, b2.length);
    }

    public static void readFully(InputStream in, byte[] b2, int length) throws IOException {
        Bits.readFully(in, b2, 0, length);
    }

    public static void readFully(InputStream in, byte[] b2, int startOffset, int length) throws IOException {
        if (b2.length - startOffset > length) {
            throw new IllegalArgumentException("Buffer is too small");
        }
        int offset = startOffset;
        int toRead = length;
        while (toRead > 0) {
            int bytesRead = in.read(b2, offset, toRead);
            if (bytesRead < 0) {
                throw new EOFException();
            }
            toRead -= bytesRead;
            offset += bytesRead;
        }
    }

    public static int readInt(InputStream in) throws IOException {
        return Bits.readInt(in, new byte[4]);
    }

    public static int readInt(InputStream in, byte[] data) throws IOException {
        Bits.readFully(in, data, 4);
        return Bits.readInt(data);
    }

    public static int readInt(byte[] data) {
        return Bits.readInt(data, 0);
    }

    public static int readInt(byte[] data, int offset) {
        int x2 = 0;
        x2 |= (0xFF & data[offset + 0]) << 0;
        x2 |= (0xFF & data[offset + 1]) << 8;
        x2 |= (0xFF & data[offset + 2]) << 16;
        return x2 |= (0xFF & data[offset + 3]) << 24;
    }

    public static int readIntBE(byte[] data, int offset) {
        int x2 = 0;
        x2 |= (0xFF & data[offset + 0]) << 24;
        x2 |= (0xFF & data[offset + 1]) << 16;
        x2 |= (0xFF & data[offset + 2]) << 8;
        return x2 |= (0xFF & data[offset + 3]) << 0;
    }

    public static long readLong(InputStream in) throws IOException {
        return Bits.readLong(in, new byte[8]);
    }

    public static long readLong(InputStream in, byte[] data) throws IOException {
        Bits.readFully(in, data, 8);
        return Bits.readLong(data);
    }

    public static long readLong(byte[] data) {
        return Bits.readLong(data, 0);
    }

    public static long readLong(byte[] data, int offset) {
        long x2 = 0L;
        x2 |= (0xFFL & (long)data[offset + 0]) << 0;
        x2 |= (0xFFL & (long)data[offset + 1]) << 8;
        x2 |= (0xFFL & (long)data[offset + 2]) << 16;
        x2 |= (0xFFL & (long)data[offset + 3]) << 24;
        x2 |= (0xFFL & (long)data[offset + 4]) << 32;
        x2 |= (0xFFL & (long)data[offset + 5]) << 40;
        x2 |= (0xFFL & (long)data[offset + 6]) << 48;
        return x2 |= (0xFFL & (long)data[offset + 7]) << 56;
    }
}

