/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.locusiterator;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import org.broadinstitute.gatk.utils.GenomeLoc;
import org.broadinstitute.gatk.utils.GenomeLocParser;
import org.broadinstitute.gatk.utils.exceptions.UserException;
import org.broadinstitute.gatk.utils.pileup.PileupElement;
import org.broadinstitute.gatk.utils.sam.GATKSAMRecord;

@Invariant(value={"nCigarElements >= 0", "cigar != null", "read != null", "currentCigarElementOffset >= -1", "currentCigarElementOffset <= nCigarElements"})
public class AlignmentStateMachine {
    private final GATKSAMRecord read;
    private final Cigar cigar;
    private final int nCigarElements;
    private int currentCigarElementOffset = -1;
    private int readOffset;
    private int genomeOffset;
    private CigarElement currentElement;
    private int offsetIntoCurrentCigarElement;

    @Requires(value={"read != null", "read.getAlignmentStart() != -1", "read.getCigar() != null"})
    public AlignmentStateMachine(GATKSAMRecord read) {
        this.read = read;
        this.cigar = read.getCigar();
        this.nCigarElements = this.cigar.numCigarElements();
        this.initializeAsLeftEdge();
    }

    @Ensures(value={"isLeftEdge()"})
    private void initializeAsLeftEdge() {
        this.genomeOffset = -1;
        this.offsetIntoCurrentCigarElement = -1;
        this.readOffset = -1;
        this.currentElement = null;
    }

    @Ensures(value={"result != null"})
    public GATKSAMRecord getRead() {
        return this.read;
    }

    @Ensures(value={"result == getRead().getReferenceIndex()"})
    public int getReferenceIndex() {
        return this.getRead().getReferenceIndex();
    }

    public boolean isLeftEdge() {
        return this.readOffset == -1;
    }

    public boolean isRightEdge() {
        return this.readOffset == this.read.getReadLength();
    }

    @Ensures(value={"result >= -1"})
    public int getReadOffset() {
        return this.readOffset;
    }

    @Ensures(value={"result >= -1"})
    public int getGenomeOffset() {
        return this.genomeOffset;
    }

    @Ensures(value={"result > 0"})
    public int getGenomePosition() {
        return this.read.getAlignmentStart() + this.getGenomeOffset();
    }

    @Requires(value={"genomeLocParser != null"})
    @Ensures(value={"result != null"})
    public GenomeLoc getLocation(GenomeLocParser genomeLocParser) {
        return genomeLocParser.createGenomeLoc(this.read.getReferenceName(), this.getGenomePosition());
    }

    @Ensures(value={"result != null || isLeftEdge() || isRightEdge()"})
    public CigarElement getCurrentCigarElement() {
        return this.currentElement;
    }

    @Ensures(value={"result >= -1", "result <= nCigarElements"})
    public int getCurrentCigarElementOffset() {
        return this.currentCigarElementOffset;
    }

    @Ensures(value={"result >= 0 || (result == -1 && isLeftEdge())", "!isRightEdge() || result == 0"})
    public int getOffsetIntoCurrentCigarElement() {
        return this.offsetIntoCurrentCigarElement;
    }

    @Ensures(value={"result != null || isLeftEdge() || isRightEdge()"})
    public CigarOperator getCigarOperator() {
        return this.currentElement == null ? null : this.currentElement.getOperator();
    }

    public String toString() {
        return String.format("%s ro=%d go=%d cec=%d %s", this.read.getReadName(), this.readOffset, this.genomeOffset, this.offsetIntoCurrentCigarElement, this.currentElement);
    }

    @Ensures(value={"result != null || isRightEdge()"})
    public CigarOperator stepForwardOnGenome() {
        while (true) {
            if (this.currentElement == null || this.offsetIntoCurrentCigarElement + 1 >= this.currentElement.getLength()) {
                ++this.currentCigarElementOffset;
                if (this.currentCigarElementOffset < this.nCigarElements) {
                    this.currentElement = this.cigar.getCigarElement(this.currentCigarElementOffset);
                    this.offsetIntoCurrentCigarElement = -1;
                    continue;
                }
                if (this.currentElement != null && this.currentElement.getOperator() == CigarOperator.D) {
                    throw new UserException.MalformedBAM(this.read, "read ends with deletion. Cigar: " + this.read.getCigarString() + ". Although the SAM spec technically permits such reads, this is often indicative of malformed files. If you are sure you want to use this file, re-run your analysis with the extra option: -rf BadCigar");
                }
                this.offsetIntoCurrentCigarElement = 0;
                this.readOffset = this.read.getReadLength();
                this.currentElement = null;
                ++this.genomeOffset;
                return null;
            }
            ++this.offsetIntoCurrentCigarElement;
            boolean done = false;
            switch (this.currentElement.getOperator()) {
                case H: 
                case P: {
                    this.offsetIntoCurrentCigarElement = this.currentElement.getLength();
                    break;
                }
                case I: 
                case S: {
                    this.offsetIntoCurrentCigarElement = this.currentElement.getLength();
                    this.readOffset += this.currentElement.getLength();
                    break;
                }
                case D: {
                    if (this.readOffset < 0) {
                        throw new UserException.MalformedBAM(this.read, "read starts with deletion. Cigar: " + this.read.getCigarString() + ". Although the SAM spec technically permits such reads, this is often indicative of malformed files. If you are sure you want to use this file, re-run your analysis with the extra option: -rf BadCigar");
                    }
                    ++this.genomeOffset;
                    done = true;
                    break;
                }
                case N: {
                    ++this.genomeOffset;
                    done = true;
                    break;
                }
                case M: 
                case EQ: 
                case X: {
                    ++this.readOffset;
                    ++this.genomeOffset;
                    done = true;
                    break;
                }
                default: {
                    throw new IllegalStateException("Case statement didn't deal with cigar op: " + (Object)((Object)this.currentElement.getOperator()));
                }
            }
            if (done) break;
        }
        return this.currentElement.getOperator();
    }

    @Ensures(value={"result != null"})
    public final PileupElement makePileupElement() {
        if (this.isLeftEdge() || this.isRightEdge()) {
            throw new IllegalStateException("Cannot make a pileup element from an edge alignment state");
        }
        return new PileupElement(this.read, this.getReadOffset(), this.getCurrentCigarElement(), this.getCurrentCigarElementOffset(), this.getOffsetIntoCurrentCigarElement());
    }
}

