/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools.sort;

import htsjdk.samtools.util.SortingCollection;
import htsjdk.tribble.readers.AsciiLineReader;
import jargs.gnu.CmdLineParser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.broad.igv.feature.genome.ChromosomeNameComparator;
import org.broad.igv.feature.tribble.MUTCodec;
import org.broad.igv.gwas.GWASParser;
import org.broad.igv.tools.sort.BedSorter;
import org.broad.igv.tools.sort.CNSorter;
import org.broad.igv.tools.sort.EQTLSorter;
import org.broad.igv.tools.sort.GFFSorter;
import org.broad.igv.tools.sort.GWASSorter;
import org.broad.igv.tools.sort.GenericSorter;
import org.broad.igv.tools.sort.InteractionSorter;
import org.broad.igv.tools.sort.MUTSorter;
import org.broad.igv.tools.sort.Parser;
import org.broad.igv.tools.sort.SAMSorter;
import org.broad.igv.tools.sort.SortableRecord;
import org.broad.igv.tools.sort.SortableRecordCodec;
import org.broad.igv.tools.sort.VCFSorter;
import org.broad.igv.track.GFFFeatureSource;
import org.broad.igv.util.ResourceLocator;

public abstract class Sorter {
    private static Logger log = Logger.getLogger(Sorter.class);
    static int MAX_RECORDS_IN_RAM = 500000;
    protected File inputFile;
    private File outputFile;
    private boolean writeStdOut = false;
    private int maxRecords = MAX_RECORDS_IN_RAM;
    private File tmpDir;
    static final String usageString = "igvtools sort <inputFile> [outputFile]";
    protected Comparator<SortableRecord> comparator = Sorter.getDefaultComparator();

    public static Sorter getSorter(String[] argv) {
        if (argv.length < 2) {
            System.out.println(usageString);
            System.exit(-1);
        }
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option tmpDirOption = parser.addStringOption('t', "tmpDir");
        CmdLineParser.Option maxRecordsOption = parser.addStringOption('m', "maxRecords");
        try {
            parser.parse(argv);
        }
        catch (CmdLineParser.OptionException e2) {
            String msg = "Error parsing command line " + e2.getMessage();
            log.error(msg, e2);
        }
        String[] nonOptionArgs = parser.getRemainingArgs();
        File inputFile = new File(nonOptionArgs[0]);
        if (!inputFile.exists()) {
            String msg = "Error: " + inputFile.getAbsolutePath() + " does not exist.";
            log.error(msg);
            throw new RuntimeException(msg);
        }
        File outputFile = new File(nonOptionArgs[1]);
        Sorter sorter = Sorter.getSorter(inputFile, outputFile);
        String tmpDirName = (String)parser.getOptionValue(tmpDirOption);
        if (tmpDirName != null) {
            File tmpDir = new File(tmpDirName);
            if (!tmpDir.exists()) {
                String msg = "Error: tmp directory: " + tmpDir.getAbsolutePath() + " does not exist.";
                log.error(msg);
                throw new RuntimeException(msg);
            }
            sorter.setTmpDir(tmpDir);
        }
        int mr = MAX_RECORDS_IN_RAM;
        String maxRecordsString = (String)parser.getOptionValue(maxRecordsOption);
        if (maxRecordsOption != null) {
            try {
                mr = Integer.parseInt(maxRecordsString);
            }
            catch (NumberFormatException e3) {
                log.warn("Warning: max records is not an integer: (" + maxRecordsString + ").  Setting" + "max records to " + MAX_RECORDS_IN_RAM);
                mr = MAX_RECORDS_IN_RAM;
            }
        }
        sorter.setMaxRecords(mr);
        return sorter;
    }

    public static Sorter getSorter(File inputFile, File outputFile) {
        String shortFN = inputFile.getName().toLowerCase();
        if (shortFN.endsWith(".txt")) {
            shortFN = shortFN.substring(0, shortFN.length() - 4);
        }
        if (shortFN.endsWith(".cn") || shortFN.endsWith(".xcn") || shortFN.endsWith(".snp") || shortFN.endsWith(".igv")) {
            return new CNSorter(inputFile, outputFile);
        }
        if (shortFN.endsWith(".sam")) {
            return new SAMSorter(inputFile, outputFile);
        }
        if (shortFN.endsWith(".aligned") || shortFN.endsWith(".bed") || shortFN.endsWith(".bedgraph") || shortFN.endsWith(".bdg")) {
            return new BedSorter(inputFile, outputFile);
        }
        if (GFFFeatureSource.isGFF(shortFN)) {
            return new GFFSorter(inputFile, outputFile);
        }
        if (shortFN.endsWith(".vcf")) {
            return new VCFSorter(inputFile, outputFile);
        }
        if (shortFN.endsWith(".psl") || shortFN.endsWith(".pslx")) {
            return new BedSorter(inputFile, outputFile);
        }
        if (shortFN.endsWith(".eqtl")) {
            return new EQTLSorter(inputFile, outputFile);
        }
        if (shortFN.endsWith(".snp")) {
            return new GenericSorter(inputFile, outputFile, 1, 2);
        }
        if (GWASParser.isGWASFile(shortFN)) {
            return new GWASSorter(inputFile, outputFile);
        }
        if (MUTCodec.isMutationAnnotationFile(new ResourceLocator(inputFile.getAbsolutePath()))) {
            return new MUTSorter(inputFile, outputFile);
        }
        if (shortFN.endsWith(".interaction")) {
            return new InteractionSorter(inputFile, outputFile);
        }
        log.error("Unknown file type or sorting not supported for: " + inputFile.getName());
        return null;
    }

    public Sorter(File inputFile, File outputFile) {
        this.inputFile = inputFile;
        this.outputFile = outputFile;
        this.writeStdOut = outputFile == null;
        this.tmpDir = new File(System.getProperty("java.io.tmpdir"), System.getProperty("user.name"));
        System.setProperty("snappy.disable", "true");
        if (!this.tmpDir.exists()) {
            this.tmpDir.mkdir();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        FileInputStream fis = null;
        PrintWriter writer = null;
        try {
            fis = new FileInputStream(this.inputFile);
            OutputStreamWriter rawWriter = this.writeStdOut ? new OutputStreamWriter(System.out) : new FileWriter(this.outputFile);
            writer = new PrintWriter(new BufferedWriter(rawWriter));
            SortableRecordCodec codec = new SortableRecordCodec();
            SortingCollection<SortableRecord> cltn = SortingCollection.newInstance(SortableRecord.class, codec, this.comparator, this.maxRecords, this.tmpDir);
            Parser parser = this.getParser();
            AsciiLineReader reader = new AsciiLineReader(fis);
            String firstDataRow = this.writeHeader(reader, writer);
            if (firstDataRow != null) {
                cltn.add(parser.createRecord(firstDataRow));
            }
            SortableRecord next = null;
            while ((next = parser.readNextRecord(reader)) != null) {
                cltn.add(next);
            }
            Iterator iter = cltn.iterator();
            while (iter.hasNext()) {
                SortableRecord al = (SortableRecord)iter.next();
                writer.println(al.getText());
            }
            iter.close();
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    void setComparator(Comparator<SortableRecord> comparator) {
        this.comparator = comparator;
    }

    public static Comparator<SortableRecord> getDefaultComparator() {
        Comparator<SortableRecord> comp = new Comparator<SortableRecord>(){
            private Comparator<String> nameComparator = ChromosomeNameComparator.get();

            @Override
            public int compare(SortableRecord o1, SortableRecord o2) {
                int nameComp = this.nameComparator.compare(o1.getChromosome(), o2.getChromosome());
                if (nameComp == 0) {
                    return o1.getStart() - o2.getStart();
                }
                return nameComp;
            }
        };
        return comp;
    }

    abstract Parser getParser() throws IOException;

    abstract String writeHeader(AsciiLineReader var1, PrintWriter var2) throws IOException;

    public void setTmpDir(File tmpDir) {
        this.tmpDir = tmpDir;
    }

    public void setMaxRecords(int maxRecords) {
        this.maxRecords = maxRecords;
    }

    public void setWriteStdOut(boolean writeStdOut) {
        this.writeStdOut = writeStdOut;
    }
}

