/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools.sort;

import htsjdk.tribble.readers.AsciiLineReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.broad.igv.tools.sort.Parser;
import org.broad.igv.tools.sort.Sorter;

public class BedSorter
extends Sorter {
    private int chrCol;
    private int startCol;

    public BedSorter(File inputFile, File outputFile) {
        super(inputFile, outputFile);
        if (inputFile.getName().endsWith(".psl") || inputFile.getName().endsWith(".pslx")) {
            this.chrCol = 13;
            this.startCol = 15;
        } else {
            this.chrCol = 0;
            this.startCol = 1;
        }
    }

    @Override
    Parser getParser() {
        return new Parser(this.chrCol, this.startCol);
    }

    @Override
    String writeHeader(AsciiLineReader reader, PrintWriter writer) throws IOException {
        String nextLine = reader.readLine();
        if (nextLine.startsWith("psLayout")) {
            do {
                writer.println(nextLine);
            } while (!(nextLine = reader.readLine()).startsWith("-"));
            nextLine = reader.readLine();
        }
        while (nextLine.startsWith("#") || nextLine.startsWith("browser") || nextLine.startsWith("track") || nextLine.trim().length() == 0) {
            writer.println(nextLine);
            nextLine = reader.readLine();
        }
        return nextLine;
    }
}

