/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ga4gh;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.util.CloseableIterator;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.ga4gh.Ga4ghAPIHelper;
import org.broad.igv.ga4gh.Ga4ghProvider;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.reader.AlignmentReader;
import org.broad.igv.util.HttpUtils;

public class Ga4ghAlignmentReader
implements AlignmentReader<Alignment> {
    private static Logger log = Logger.getLogger(Ga4ghAlignmentReader.class);
    String readsetId;
    List<String> sequenceNames;
    Ga4ghProvider provider;
    Map<String, String> chromosomeMappings;
    static Map<String, String> COMMON_ALIASES = new HashMap<String, String>();

    public Ga4ghAlignmentReader(Ga4ghProvider provider, String readsetId) {
        this.provider = provider;
        this.readsetId = readsetId;
        this.chromosomeMappings = new HashMap<String, String>();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public List<String> getSequenceNames() {
        if (this.sequenceNames == null) {
            try {
                this.loadMetadata();
            }
            catch (Exception e2) {
                log.error("Error fetching metadata", e2);
            }
        }
        return this.sequenceNames;
    }

    @Override
    public SAMFileHeader getFileHeader() {
        return null;
    }

    @Override
    public Set<String> getPlatforms() {
        return null;
    }

    @Override
    public CloseableIterator<Alignment> iterator() {
        throw new RuntimeException("Iterating over ga4gh datasets is not supported");
    }

    @Override
    public CloseableIterator<Alignment> query(String sequence, int start, int end, boolean contained) throws IOException {
        boolean handleError;
        List<Alignment> alignmentList;
        boolean sequenceNameConfirmed = false;
        if (this.chromosomeMappings.containsKey(sequence)) {
            sequence = this.chromosomeMappings.get(sequence);
            sequenceNameConfirmed = true;
        }
        if ((alignmentList = Ga4ghAPIHelper.searchReads(this.provider, this.readsetId, sequence, start, end, handleError = sequenceNameConfirmed)) != null) {
            this.chromosomeMappings.put(sequence, sequence);
            return new MIterator(alignmentList);
        }
        if (!sequenceNameConfirmed && COMMON_ALIASES.containsKey(sequence)) {
            String altSequence = COMMON_ALIASES.get(sequence);
            log.info("Sequence \"" + sequence + "\" failed.  Trying \"" + altSequence + "\"");
            alignmentList = Ga4ghAPIHelper.searchReads(this.provider, this.readsetId, altSequence, start, end, true);
            if (alignmentList != null) {
                this.chromosomeMappings.put(sequence, altSequence);
            }
            return alignmentList == null ? null : new MIterator(alignmentList);
        }
        return null;
    }

    @Override
    public boolean hasIndex() {
        return true;
    }

    private void loadMetadata() throws IOException {
        String authKey = this.provider.apiKey;
        String baseURL = this.provider.baseURL;
        URL url = new URL(baseURL + "/readgroupsets/" + this.readsetId + (authKey == null ? "" : "?key=" + authKey));
        String result = HttpUtils.getInstance().getContentsAsString(url);
        JsonParser parser = new JsonParser();
        JsonObject root = parser.parse(result).getAsJsonObject();
    }

    public static boolean supportsFileType(String type) {
        return type.equals("ga4gh");
    }

    static {
        for (int i2 = 1; i2 <= 23; ++i2) {
            COMMON_ALIASES.put("" + i2, "chr" + i2);
            COMMON_ALIASES.put("chr" + i2, "" + i2);
        }
        COMMON_ALIASES.put("chrX", "X");
        COMMON_ALIASES.put("X", "chrX");
        COMMON_ALIASES.put("chrY", "Y");
        COMMON_ALIASES.put("Y", "chrY");
        COMMON_ALIASES.put("chrM", "MT");
        COMMON_ALIASES.put("MT", "chrM");
    }

    class MIterator
    implements CloseableIterator<Alignment> {
        Iterator<Alignment> iter;

        MIterator(List<Alignment> alignmentList) {
            this.iter = alignmentList.iterator();
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Alignment next() {
            return this.iter.next();
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }
}

