/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cbio;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.broad.igv.DirectoryManager;
import org.broad.igv.PreferenceManager;
import org.broad.igv.cbio.AttributeFilter;
import org.broad.igv.cbio.GeneNetwork;
import org.broad.igv.lists.GeneList;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.ui.util.FileDialogUtils;
import org.broad.igv.ui.util.IndefiniteProgressMonitor;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.ProgressBar;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.BrowserLauncher;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.StringUtils;
import org.w3c.dom.Node;

public class FilterGeneNetworkUI
extends JDialog {
    private Logger log = Logger.getLogger(FilterGeneNetworkUI.class);
    private GeneList seedGeneList;
    private List<AttributeFilter> filterRows = new ArrayList<AttributeFilter>(1);
    GeneNetwork network = null;
    private GraphListModel listModel;
    private Map<String, JTextField> thresholdsMap = new HashMap<String, JTextField>(5);
    private static List<String> columnNames;
    private static Map<Integer, String> columnNumToKeyMap;
    private Component lastSelectedTab;
    private JTabbedPane tabbedPane;
    private JPanel seedGenesPane;
    private JPanel vSpacer1;
    private JLabel label5;
    private JScrollPane scrollPane2;
    private JTextArea seedGenesText;
    private JTextPane textPane1;
    private JPanel seedButtonBar;
    private JButton retrieveNetworkButton;
    private JButton resetSeedGeneTextAreaButton;
    private JButton cancel2;
    private JPanel filterPane;
    private JPanel panel1;
    private JButton addRow;
    private JPanel contentPane;
    private JScrollPane scrollPane1;
    private JTable geneTable;
    private JPanel buttonBar;
    private JLabel totNumGenes;
    private JCheckBox showSeedOnly;
    private JButton refFilter;
    private JCheckBox keepIsolated;
    private JButton okButton;
    private JButton cancelButton;
    private JButton saveButton;
    private JButton helpButton;
    private JPanel thresholdsPane;
    private JPanel contentPanel;
    private JLabel label2;
    private JLabel label3;
    private JTextField delInput;
    private JLabel label4;
    private JTextField expUpInput;
    private JLabel label7;
    private JTextField expDownInput;
    private JTextField ampInput;
    private JLabel label1;
    private JTextField mutInput;
    private JLabel label6;
    private JLabel label8;
    private JSeparator separator1;
    private JSeparator separator3;
    private JSeparator separator2;
    private JPanel panel2;
    private JTextArea textArea1;
    private JButton resetToDefaultsButton;

    public FilterGeneNetworkUI(Frame owner, GeneList seedGeneList) {
        super(owner);
        this.seedGeneList = seedGeneList;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && this.network == null) {
            this.loadcBioData();
        } else {
            super.setVisible(visible);
        }
    }

    private void loadcBioData() {
        this.network = null;
        final List<String> geneLoci = this.seedGeneList.getLoci();
        final IndefiniteProgressMonitor indefMonitor = new IndefiniteProgressMonitor();
        final ProgressBar.ProgressDialog progressDialog = ProgressBar.showProgressDialog((Frame)this.getOwner(), "Loading cBio data...", indefMonitor, true);
        progressDialog.getProgressBar().setIndeterminate(true);
        indefMonitor.start();
        final Runnable updateUI = new Runnable(){

            @Override
            public void run() {
                boolean needSetup;
                boolean bl = needSetup = !FilterGeneNetworkUI.this.isVisible();
                if (needSetup) {
                    FilterGeneNetworkUI.this.initComponents();
                }
                FilterGeneNetworkUI.this.setGeneNetworkNeedsUpdate(false);
                FilterGeneNetworkUI.this.tabbedPane.setSelectedComponent(FilterGeneNetworkUI.this.filterPane);
                FilterGeneNetworkUI.this.initComponentData();
                if (needSetup) {
                    FilterGeneNetworkUI.super.setVisible(true);
                }
            }
        };
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                WaitCursorManager.CursorToken token = null;
                try {
                    token = WaitCursorManager.showWaitCursor();
                    FilterGeneNetworkUI.this.network = GeneNetwork.getFromCBIO(geneLoci);
                    if (FilterGeneNetworkUI.this.network.vertexSet().size() == 0) {
                        MessageUtils.showMessage("No results found for " + StringUtils.join(geneLoci, ", "));
                    } else {
                        FilterGeneNetworkUI.this.network.annotateAll(IGV.getInstance().getAllTracks());
                        UIUtilities.invokeOnEventThread(updateUI);
                    }
                }
                catch (Throwable e2) {
                    e2.printStackTrace();
                    FilterGeneNetworkUI.this.log.error(e2.getMessage());
                    MessageUtils.showMessage("Error loading data: " + e2.getMessage());
                }
                finally {
                    WaitCursorManager.removeWaitCursor(token);
                    if (progressDialog != null) {
                        progressDialog.setVisible(false);
                        indefMonitor.stop();
                    }
                }
            }
        };
        LongRunningTask.submit(runnable);
    }

    private void initThresholdsMap() {
        this.thresholdsMap.put("CBIO_MUTATION_THRESHOLD", this.mutInput);
        this.thresholdsMap.put("CBIO_AMPLIFICATION_THRESHOLD", this.ampInput);
        this.thresholdsMap.put("CBIO_DELETION_THRESHOLD", this.delInput);
        this.thresholdsMap.put("CBIO_EXPRESSION_UP_THRESHOLD", this.expUpInput);
        this.thresholdsMap.put("CBIO_EXPRESSION_DOWN_THRESHOLD", this.expDownInput);
    }

    private void initComponentData() {
        this.refreshSeedGenesTextArea();
        if (this.filterRows.size() == 0) {
            this.add();
        }
        this.initThresholdsMap();
        this.loadThresholds();
        this.listModel = new GraphListModel();
        this.geneTable.setModel(this.listModel);
        this.initRenderers();
        this.applySoftFilters();
    }

    private void modifyForSelection(JComponent component, boolean isSelected) {
        if (isSelected) {
            component.setForeground(this.geneTable.getSelectionForeground());
            component.setBackground(this.geneTable.getSelectionBackground());
            component.setOpaque(isSelected);
        }
    }

    private void initRenderers() {
        TableCellRenderer stringRenderer = new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel comp = new JLabel();
                if (value != null) {
                    boolean isSeedGene = FilterGeneNetworkUI.this.seedGeneList.getLoci().contains(value);
                    comp.setText(String.valueOf(value));
                    if (isSeedGene) {
                        comp.setFont(comp.getFont().deriveFont(comp.getFont().getStyle() | 1));
                    }
                }
                FilterGeneNetworkUI.this.modifyForSelection(comp, isSelected);
                return comp;
            }
        };
        TableCellRenderer intRenderer = new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel comp = new JLabel("" + value);
                FilterGeneNetworkUI.this.modifyForSelection(comp, isSelected);
                return comp;
            }
        };
        TableCellRenderer doubleRenderer = new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel comp = new JLabel();
                if (value != null) {
                    String sVal;
                    Double dPerc = (Double)value;
                    if (dPerc == 0.0) {
                        sVal = "0.0";
                    } else {
                        String fmt = "%2.1f";
                        if (dPerc < 0.1) {
                            fmt = "%2.1e";
                        }
                        sVal = String.format(fmt, dPerc);
                    }
                    comp.setText(sVal);
                }
                FilterGeneNetworkUI.this.modifyForSelection(comp, isSelected);
                return comp;
            }
        };
        this.geneTable.setDefaultRenderer(String.class, stringRenderer);
        this.geneTable.setDefaultRenderer(Integer.class, intRenderer);
        this.geneTable.setDefaultRenderer(Double.class, doubleRenderer);
    }

    private void refreshSeedGenesTextArea() {
        String seedGenesString = StringUtils.join(this.seedGeneList.getLoci(), "\n");
        this.seedGenesText.setText(seedGenesString);
    }

    private GeneList getNewSeedGeneList() {
        boolean updated;
        Object[] genes = this.seedGenesText.getText().toUpperCase().split("[\\r\\n]{1,2}");
        boolean bl = updated = !Arrays.equals(this.seedGeneList.getLoci().toArray(), genes);
        if (updated) {
            return new GeneList(null, Arrays.asList(genes));
        }
        return this.seedGeneList;
    }

    private boolean checkNewSeedGeneList() {
        return this.getNewSeedGeneList() != this.seedGeneList;
    }

    private void remove(AttributeFilter row) {
        this.contentPane.remove(row.getPanel());
        this.filterRows.remove(row);
        int numRows = this.filterRows.size();
        this.filterRows.get(numRows - 1).setIsLast(true);
        this.filterRows.get(0).setShowDel(numRows >= 2);
        this.validate();
        this.adjustWindowHeight(-row.getPanel().getHeight());
        this.applySoftFilters();
    }

    private void add() {
        final AttributeFilter row = new AttributeFilter();
        row.getDelRow().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FilterGeneNetworkUI.this.remove(row);
            }
        });
        row.getAddRow().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FilterGeneNetworkUI.this.add();
            }
        });
        this.contentPane.add(row.getPanel());
        RefreshListener listener = new RefreshListener();
        row.getAttrName().addActionListener(listener);
        for (JTextField text : new JTextField[]{row.minVal, row.maxVal}) {
            text.addActionListener(listener);
            text.addFocusListener(listener);
        }
        if (this.filterRows.size() >= 1) {
            this.filterRows.get(this.filterRows.size() - 1).setIsLast(false);
        }
        this.filterRows.add(row);
        int numRows = this.filterRows.size();
        this.filterRows.get(numRows - 1).setIsLast(true);
        this.filterRows.get(0).setShowDel(numRows >= 2);
        this.validate();
        this.adjustWindowHeight(row.getPanel().getHeight());
    }

    private void adjustWindowHeight(int heightDelta) {
        int newWinHeight = this.getHeight() + heightDelta;
        if (this.filterRows.size() >= 4 && (double)newWinHeight < Toolkit.getDefaultToolkit().getScreenSize().getHeight() - 100.0) {
            Dimension newSize = this.tabbedPane.getPreferredSize();
            newSize.setSize(newSize.getWidth(), newSize.getHeight() + (double)heightDelta);
            this.tabbedPane.setPreferredSize(newSize);
            newSize = this.getSize();
            newSize.setSize(newSize.getWidth(), (double)newWinHeight);
            this.setSize(newSize);
            this.validate();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent e2) {
        this.setVisible(false);
    }

    private void applySoftFilters() {
        this.network.reset();
        if (this.showSeedOnly.isSelected()) {
            this.network.filterGenes(GeneNetwork.inQuery);
        } else {
            for (AttributeFilter filter : this.filterRows) {
                String filt_el = (String)filter.getAttrName().getSelectedItem();
                if (!GeneNetwork.attributeMap.containsKey(filt_el) && !"PERCENT_ALTERED".equals(filt_el)) continue;
                float min = Float.parseFloat(filter.minVal.getText());
                float max = Float.parseFloat(filter.maxVal.getText());
                this.network.filterGenesRange(filt_el, min / 100.0f, max / 100.0f);
            }
            if (!this.keepIsolated.isSelected()) {
                this.network.pruneGraph();
            }
        }
        this.totNumGenes.setText("Total Genes: " + this.network.geneVertexes().size());
        this.listModel.markDirty();
    }

    private void showNetwork() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    String url = FilterGeneNetworkUI.this.network.outputForcBioView();
                    url = "file://" + url;
                    BrowserLauncher.openURL(url);
                }
                catch (IOException err) {
                    FilterGeneNetworkUI.this.log.error(err);
                    MessageUtils.showMessage("Error opening network for viewing. " + err.getMessage());
                }
            }
        };
        LongRunningTask.submit(runnable);
    }

    private int[] getModelIndices() {
        int[] selection = this.geneTable.getSelectedRows();
        for (int i2 = 0; i2 < selection.length; ++i2) {
            selection[i2] = this.geneTable.convertRowIndexToModel(selection[i2]);
        }
        return selection;
    }

    private void okButtonActionPerformed(ActionEvent e2) {
        this.showNetwork();
    }

    private void addRowActionPerformed(ActionEvent e2) {
        this.add();
    }

    private void refreshFilters() {
        this.applySoftFilters();
        this.listModel.markDirty();
        this.validate();
    }

    private void refFilterActionPerformed(ActionEvent e2) {
        this.refreshFilters();
    }

    private boolean saveThresholds() {
        try {
            for (Map.Entry<String, JTextField> entry : this.thresholdsMap.entrySet()) {
                float fval = Float.parseFloat(entry.getValue().getText());
                String sval = "" + fval;
                if (entry.getKey() == "CBIO_MUTATION_THRESHOLD") {
                    int ival = Integer.parseInt(entry.getValue().getText());
                    sval = "" + ival;
                }
                PreferenceManager.getInstance().put(entry.getKey(), sval);
            }
        }
        catch (NumberFormatException e2) {
            MessageUtils.showMessage("Invalid input. Mutation count must be integers, others must be numeric. " + e2.getMessage());
            return false;
        }
        return true;
    }

    private void loadThresholds() {
        for (Map.Entry<String, JTextField> entry : this.thresholdsMap.entrySet()) {
            String value = PreferenceManager.getInstance().get(entry.getKey());
            entry.getValue().setText(value);
        }
    }

    private void tabbedPaneStateChanged(ChangeEvent e2) {
        if (this.tabbedPane == null || this.thresholdsPane == null) {
            return;
        }
        if (this.lastSelectedTab != null && this.lastSelectedTab == this.seedGenesPane && !this.saveThresholds()) {
            this.tabbedPane.setSelectedComponent(this.thresholdsPane);
        }
        this.lastSelectedTab = this.tabbedPane.getSelectedComponent();
    }

    private void saveButtonActionPerformed(ActionEvent e2) {
        File outPath = FileDialogUtils.chooseFile("Save table to...", DirectoryManager.getUserDirectory(), FileDialogUtils.SAVE);
        if (outPath != null) {
            try {
                this.saveTable(outPath);
            }
            catch (FileNotFoundException exc) {
                MessageUtils.showMessage(exc.getMessage());
            }
        }
    }

    private void resetToDefaultsButtonActionPerformed(ActionEvent e2) {
        for (Map.Entry<String, JTextField> entry : this.thresholdsMap.entrySet()) {
            String value = PreferenceManager.getInstance().getDefaultValue(entry.getKey());
            entry.getValue().setText(value);
        }
        this.saveThresholds();
    }

    private void cancel2ActionPerformed(ActionEvent e2) {
        this.cancelButton.doClick();
    }

    private void retrieveNetworkButtonActionPerformed(ActionEvent e2) {
        this.updateNetwork();
    }

    private void updateNetwork() {
        boolean updated;
        GeneList newSeedGeneList = this.getNewSeedGeneList();
        boolean bl = updated = newSeedGeneList != this.seedGeneList;
        if (updated) {
            this.seedGeneList = newSeedGeneList;
            this.loadcBioData();
        }
    }

    private void resetSeedGeneTextAreaButtonActionPerformed(ActionEvent e2) {
        this.refreshSeedGenesTextArea();
        this.setGeneNetworkNeedsUpdate(false);
    }

    private void seedGenesTextKeyReleased(KeyEvent e2) {
        boolean updated = this.checkNewSeedGeneList();
        this.setGeneNetworkNeedsUpdate(updated);
    }

    private void setGeneNetworkNeedsUpdate(boolean updated) {
        boolean tabsEnabled = !updated;
        int filterIndex = this.tabbedPane.indexOfComponent(this.filterPane);
        int thresholdsIndex = this.tabbedPane.indexOfComponent(this.thresholdsPane);
        int[] indexes = new int[]{filterIndex, thresholdsIndex};
        Color color = tabsEnabled ? Color.black : Color.gray;
        for (int index : indexes) {
            this.tabbedPane.setEnabledAt(index, tabsEnabled);
            this.tabbedPane.setForegroundAt(index, color);
        }
        this.retrieveNetworkButton.setEnabled(updated);
    }

    private void showSeedOnlyActionPerformed(ActionEvent e2) {
        this.refreshFilters();
    }

    private void initComponents() {
        Rectangle bounds;
        this.tabbedPane = new JTabbedPane();
        this.seedGenesPane = new JPanel();
        this.vSpacer1 = new JPanel(null);
        this.label5 = new JLabel();
        this.scrollPane2 = new JScrollPane();
        this.seedGenesText = new JTextArea();
        this.textPane1 = new JTextPane();
        this.seedButtonBar = new JPanel();
        this.retrieveNetworkButton = new JButton();
        this.resetSeedGeneTextAreaButton = new JButton();
        this.cancel2 = new JButton();
        this.filterPane = new JPanel();
        this.panel1 = new JPanel();
        this.addRow = new JButton();
        this.contentPane = new JPanel();
        this.scrollPane1 = new JScrollPane();
        this.geneTable = new JTable();
        this.buttonBar = new JPanel();
        this.totNumGenes = new JLabel();
        this.showSeedOnly = new JCheckBox();
        this.refFilter = new JButton();
        this.keepIsolated = new JCheckBox();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.saveButton = new JButton();
        this.helpButton = new JButton();
        this.thresholdsPane = new JPanel();
        this.contentPanel = new JPanel();
        this.label2 = new JLabel();
        this.label3 = new JLabel();
        this.delInput = new JTextField();
        this.label4 = new JLabel();
        this.expUpInput = new JTextField();
        this.label7 = new JLabel();
        this.expDownInput = new JTextField();
        this.ampInput = new JTextField();
        this.label1 = new JLabel();
        this.mutInput = new JTextField();
        this.label6 = new JLabel();
        this.label8 = new JLabel();
        this.separator1 = new JSeparator();
        this.separator3 = new JSeparator();
        this.separator2 = new JSeparator();
        this.panel2 = new JPanel();
        this.textArea1 = new JTextArea();
        this.resetToDefaultsButton = new JButton();
        this.setMinimumSize(new Dimension(600, 22));
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        Container contentPane2 = this.getContentPane();
        contentPane2.setLayout(new BorderLayout());
        this.tabbedPane.setPreferredSize(new Dimension(571, 400));
        this.tabbedPane.setMinimumSize(new Dimension(571, 346));
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e2) {
                FilterGeneNetworkUI.this.tabbedPaneStateChanged(e2);
            }
        });
        this.seedGenesPane.setLayout(new GridBagLayout());
        ((GridBagLayout)this.seedGenesPane.getLayout()).rowHeights = new int[]{0, 0, 0, 0, 0, 0};
        ((GridBagLayout)this.seedGenesPane.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        this.seedGenesPane.add((Component)this.vSpacer1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.label5.setText("Seed Genes (one per line):");
        this.label5.setLabelFor(this.seedGenesText);
        this.seedGenesPane.add((Component)this.label5, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.scrollPane2.setHorizontalScrollBarPolicy(31);
        this.seedGenesText.setRows(12);
        this.seedGenesText.setToolTipText("cBio will be queried to find what genes interact with these genes");
        this.seedGenesText.setDragEnabled(false);
        this.seedGenesText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e2) {
                FilterGeneNetworkUI.this.seedGenesTextKeyReleased(e2);
            }
        });
        this.scrollPane2.setViewportView(this.seedGenesText);
        this.seedGenesPane.add((Component)this.scrollPane2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.textPane1.setBorder(null);
        this.textPane1.setEditable(false);
        this.textPane1.setText("IGV will query cBio to find genes which interact with the seed genes entered here.");
        this.textPane1.setBackground(UIManager.getColor("Button.background"));
        this.seedGenesPane.add((Component)this.textPane1, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.seedButtonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.seedButtonBar.getLayout()).columnWidths = new int[]{0, 0, 0, 0};
        ((GridBagLayout)this.seedButtonBar.getLayout()).rowHeights = new int[]{0, 0};
        ((GridBagLayout)this.seedButtonBar.getLayout()).columnWeights = new double[]{0.0, 0.0, 0.0, 1.0E-4};
        ((GridBagLayout)this.seedButtonBar.getLayout()).rowWeights = new double[]{0.0, 1.0E-4};
        this.retrieveNetworkButton.setText("Retrieve Network");
        this.retrieveNetworkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FilterGeneNetworkUI.this.retrieveNetworkButtonActionPerformed(e2);
            }
        });
        this.seedButtonBar.add((Component)this.retrieveNetworkButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.resetSeedGeneTextAreaButton.setText("Reset to Original");
        this.resetSeedGeneTextAreaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FilterGeneNetworkUI.this.resetSeedGeneTextAreaButtonActionPerformed(e2);
            }
        });
        this.seedButtonBar.add((Component)this.resetSeedGeneTextAreaButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancel2.setText("Cancel");
        this.cancel2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FilterGeneNetworkUI.this.cancel2ActionPerformed(e2);
            }
        });
        this.seedButtonBar.add((Component)this.cancel2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.seedGenesPane.add((Component)this.seedButtonBar, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.tabbedPane.addTab("Seed Genes", this.seedGenesPane);
        this.filterPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.filterPane.setMinimumSize(new Dimension(443, 300));
        this.filterPane.setLayout(new GridBagLayout());
        ((GridBagLayout)this.filterPane.getLayout()).columnWidths = new int[]{0, 0};
        ((GridBagLayout)this.filterPane.getLayout()).rowHeights = new int[]{0, 0, 0, 0, 0, 0};
        ((GridBagLayout)this.filterPane.getLayout()).columnWeights = new double[]{1.0, 1.0E-4};
        ((GridBagLayout)this.filterPane.getLayout()).rowWeights = new double[]{0.0, 0.0, 1.0, 0.0, 0.0, 1.0E-4};
        this.panel1.setLayout(new GridBagLayout());
        ((GridBagLayout)this.panel1.getLayout()).columnWidths = new int[]{0, 0, 0};
        ((GridBagLayout)this.panel1.getLayout()).rowHeights = new int[]{0, 0};
        ((GridBagLayout)this.panel1.getLayout()).columnWeights = new double[]{0.0, 0.0, 1.0E-4};
        ((GridBagLayout)this.panel1.getLayout()).rowWeights = new double[]{0.0, 1.0E-4};
        this.addRow.setText("Add Filter");
        this.addRow.setMaximumSize(new Dimension(200, 28));
        this.addRow.setMinimumSize(new Dimension(100, 28));
        this.addRow.setPreferredSize(new Dimension(150, 28));
        this.addRow.setVisible(false);
        this.addRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FilterGeneNetworkUI.this.addRowActionPerformed(e2);
            }
        });
        this.panel1.add((Component)this.addRow, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.filterPane.add((Component)this.panel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
        this.filterPane.add((Component)this.contentPane, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.geneTable.setAutoCreateRowSorter(true);
        this.scrollPane1.setViewportView(this.geneTable);
        this.filterPane.add((Component)this.scrollPane1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setMaximumSize(new Dimension(Integer.MAX_VALUE, 137));
        this.buttonBar.setPreferredSize(new Dimension(421, 100));
        this.buttonBar.setMinimumSize(new Dimension(421, 80));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0, 0.0};
        this.totNumGenes.setText("Total Genes: #");
        this.buttonBar.add((Component)this.totNumGenes, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.showSeedOnly.setText("Seed Genes Only");
        this.showSeedOnly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FilterGeneNetworkUI.this.showSeedOnlyActionPerformed(e2);
            }
        });
        this.buttonBar.add((Component)this.showSeedOnly, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.refFilter.setText("Refresh Filter");
        this.refFilter.setVisible(false);
        this.refFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FilterGeneNetworkUI.this.refFilterActionPerformed(e2);
            }
        });
        this.buttonBar.add((Component)this.refFilter, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.keepIsolated.setText("Keep Isolated Genes");
        this.keepIsolated.setVisible(false);
        this.buttonBar.add((Component)this.keepIsolated, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.okButton.setText("View Network");
        this.okButton.setToolTipText("Display the network in a web browser");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FilterGeneNetworkUI.this.okButtonActionPerformed(e2);
            }
        });
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FilterGeneNetworkUI.this.cancelButtonActionPerformed(e2);
            }
        });
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.saveButton.setText("Save Table");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FilterGeneNetworkUI.this.saveButtonActionPerformed(e2);
            }
        });
        this.buttonBar.add((Component)this.saveButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.helpButton.setText("Help");
        this.helpButton.setVisible(false);
        this.buttonBar.add((Component)this.helpButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.filterPane.add((Component)this.buttonBar, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.tabbedPane.addTab("Filter", this.filterPane);
        this.thresholdsPane.setPreferredSize(new Dimension(550, 196));
        this.thresholdsPane.setMinimumSize(new Dimension(550, 196));
        this.thresholdsPane.setLayout(null);
        this.contentPanel.setBorder(new EtchedBorder());
        this.contentPanel.setLayout(null);
        this.label2.setText("Amplification:");
        this.label2.setHorizontalAlignment(4);
        this.label2.setLabelFor(this.ampInput);
        this.label2.setToolTipText("Amplification score, on a log-normalized scale");
        this.label2.setPreferredSize(new Dimension(90, 18));
        this.contentPanel.add(this.label2);
        this.label2.setBounds(140, 96, this.label2.getPreferredSize().width, 18);
        this.label3.setText("Deletion:");
        this.label3.setHorizontalAlignment(4);
        this.label3.setLabelFor(this.delInput);
        this.label3.setToolTipText("Deletion score, on a log-normalized scale");
        this.label3.setPreferredSize(new Dimension(60, 16));
        this.contentPanel.add(this.label3);
        this.label3.setBounds(360, 96, this.label3.getPreferredSize().width, 18);
        this.delInput.setText("0.9");
        this.delInput.setMinimumSize(new Dimension(34, 28));
        this.delInput.setPreferredSize(new Dimension(45, 28));
        this.delInput.setMaximumSize(new Dimension(50, Integer.MAX_VALUE));
        this.contentPanel.add(this.delInput);
        this.delInput.setBounds(new Rectangle(new Point(430, 91), this.delInput.getPreferredSize()));
        this.label4.setText("Up:");
        this.label4.setHorizontalAlignment(4);
        this.label4.setLabelFor(this.expUpInput);
        this.label4.setToolTipText("Expression score, log-normalized scale");
        this.label4.setPreferredSize(new Dimension(100, 18));
        this.contentPanel.add(this.label4);
        this.label4.setBounds(130, 168, this.label4.getPreferredSize().width, 18);
        this.expUpInput.setText("1.0");
        this.expUpInput.setMinimumSize(new Dimension(34, 28));
        this.expUpInput.setPreferredSize(new Dimension(45, 28));
        this.contentPanel.add(this.expUpInput);
        this.expUpInput.setBounds(new Rectangle(new Point(240, 162), this.expUpInput.getPreferredSize()));
        this.label7.setText("Down:");
        this.label7.setHorizontalAlignment(4);
        this.label7.setLabelFor(this.expDownInput);
        this.label7.setToolTipText("Expression score, log-normalized scale");
        this.label7.setPreferredSize(new Dimension(120, 16));
        this.contentPanel.add(this.label7);
        this.label7.setBounds(300, 168, this.label7.getPreferredSize().width, 18);
        this.expDownInput.setText("1.0");
        this.expDownInput.setPreferredSize(new Dimension(45, 28));
        this.expDownInput.setMinimumSize(new Dimension(34, 28));
        this.expDownInput.setMaximumSize(new Dimension(50, Integer.MAX_VALUE));
        this.contentPanel.add(this.expDownInput);
        this.expDownInput.setBounds(new Rectangle(new Point(430, 162), this.expDownInput.getPreferredSize()));
        this.ampInput.setText("0.9");
        this.ampInput.setMinimumSize(new Dimension(34, 28));
        this.ampInput.setPreferredSize(new Dimension(45, 28));
        this.contentPanel.add(this.ampInput);
        this.ampInput.setBounds(new Rectangle(new Point(240, 91), this.ampInput.getPreferredSize()));
        this.label1.setText("Mutation:");
        this.label1.setHorizontalAlignment(4);
        this.label1.setLabelFor(this.mutInput);
        this.label1.setToolTipText("Minimum number of mutations found");
        this.label1.setPreferredSize(new Dimension(66, 18));
        this.contentPanel.add(this.label1);
        this.label1.setBounds(50, 26, this.label1.getPreferredSize().width, 18);
        this.mutInput.setText("1");
        this.mutInput.setAutoscrolls(false);
        this.mutInput.setMinimumSize(new Dimension(34, 28));
        this.mutInput.setPreferredSize(new Dimension(45, 28));
        this.contentPanel.add(this.mutInput);
        this.mutInput.setBounds(new Rectangle(new Point(240, 21), this.mutInput.getPreferredSize()));
        this.label6.setText("Copy Number:");
        this.contentPanel.add(this.label6);
        this.label6.setBounds(30, 96, this.label6.getPreferredSize().width, 18);
        this.label8.setText("Expression:");
        this.label8.setHorizontalAlignment(4);
        this.contentPanel.add(this.label8);
        this.label8.setBounds(30, 168, 86, 18);
        this.contentPanel.add(this.separator1);
        this.separator1.setBounds(0, 135, 500, 10);
        this.contentPanel.add(this.separator3);
        this.separator3.setBounds(0, 65, 500, 10);
        this.separator2.setPreferredSize(new Dimension(10, 210));
        this.separator2.setOrientation(1);
        this.contentPanel.add(this.separator2);
        this.separator2.setBounds(new Rectangle(new Point(120, 0), this.separator2.getPreferredSize()));
        Dimension preferredSize = new Dimension();
        for (int i2 = 0; i2 < this.contentPanel.getComponentCount(); ++i2) {
            bounds = this.contentPanel.getComponent(i2).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        Insets insets = this.contentPanel.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.contentPanel.setMinimumSize(preferredSize);
        this.contentPanel.setPreferredSize(preferredSize);
        this.thresholdsPane.add(this.contentPanel);
        this.contentPanel.setBounds(12, 80, 500, 210);
        this.panel2.setLayout(null);
        preferredSize = new Dimension();
        for (int i3 = 0; i3 < this.panel2.getComponentCount(); ++i3) {
            bounds = this.panel2.getComponent(i3).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.panel2.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.panel2.setMinimumSize(preferredSize);
        this.panel2.setPreferredSize(preferredSize);
        this.thresholdsPane.add(this.panel2);
        this.panel2.setBounds(new Rectangle(new Point(55, 25), this.panel2.getPreferredSize()));
        this.textArea1.setText("Samples are considered to have a given \"event\" if the value is above the thresholds below.");
        this.textArea1.setEditable(false);
        this.textArea1.setLineWrap(true);
        this.textArea1.setBackground(UIManager.getColor("Button.background"));
        this.thresholdsPane.add(this.textArea1);
        this.textArea1.setBounds(15, 10, 430, 40);
        this.resetToDefaultsButton.setText("Reset to Defaults");
        this.resetToDefaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FilterGeneNetworkUI.this.resetToDefaultsButtonActionPerformed(e2);
            }
        });
        this.thresholdsPane.add(this.resetToDefaultsButton);
        this.resetToDefaultsButton.setBounds(new Rectangle(new Point(10, 50), this.resetToDefaultsButton.getPreferredSize()));
        preferredSize = new Dimension();
        for (int i4 = 0; i4 < this.thresholdsPane.getComponentCount(); ++i4) {
            bounds = this.thresholdsPane.getComponent(i4).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.thresholdsPane.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.thresholdsPane.setMinimumSize(preferredSize);
        this.thresholdsPane.setPreferredSize(preferredSize);
        this.tabbedPane.addTab("Thresholds", this.thresholdsPane);
        contentPane2.add((Component)this.tabbedPane, "North");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private void saveTable(File outFile) throws FileNotFoundException {
        PrintWriter writer = new PrintWriter(outFile);
        TableModel model = this.geneTable.getModel();
        String delimiter = "\t";
        String header = model.getColumnName(0);
        for (int col = 1; col < model.getColumnCount(); ++col) {
            header = header + delimiter + model.getColumnName(col);
        }
        writer.println(header);
        for (int row = 0; row < model.getRowCount(); ++row) {
            String rowStr = "" + model.getValueAt(row, 0);
            for (int col = 1; col < model.getColumnCount(); ++col) {
                rowStr = rowStr + delimiter + model.getValueAt(row, col);
            }
            writer.println(rowStr);
        }
        writer.flush();
        writer.close();
    }

    static {
        String[] firstLabels = new String[]{"Gene label", "Interactions"};
        columnNumToKeyMap = new HashMap<Integer, String>(GeneNetwork.attributeMap.size());
        columnNames = new ArrayList<String>(firstLabels.length + GeneNetwork.attributeMap.size());
        for (String label : firstLabels) {
            columnNames.add(label);
        }
        int ind = columnNames.size();
        for (String key : GeneNetwork.attributeMap.keySet()) {
            columnNumToKeyMap.put(ind, key);
            ++ind;
            columnNames.add(AttributeFilter.keyToLabel(key));
        }
    }

    private class RefreshListener
    implements FocusListener,
    ActionListener {
        private RefreshListener() {
        }

        @Override
        public void focusGained(FocusEvent e2) {
        }

        @Override
        public void focusLost(FocusEvent e2) {
            FilterGeneNetworkUI.this.refreshFilters();
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            FilterGeneNetworkUI.this.refreshFilters();
        }
    }

    private class GraphListModel
    extends AbstractTableModel {
        private List<Node> geneVertices = null;

        private GraphListModel() {
        }

        private List<Node> getGeneVertices() {
            if (this.geneVertices == null) {
                Collection<Node> nodes = FilterGeneNetworkUI.this.network.geneVertexes();
                this.geneVertices = Arrays.asList(nodes.toArray(new Node[0]));
            }
            return this.geneVertices;
        }

        public void markDirty() {
            this.geneVertices = null;
            this.fireTableStructureChanged();
        }

        @Override
        public int getRowCount() {
            return this.getGeneVertices().size();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Integer.class;
                }
            }
            return Double.class;
        }

        @Override
        public int getColumnCount() {
            return columnNames.size();
        }

        @Override
        public String getColumnName(int col) {
            return (String)columnNames.get(col);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Node n2 = this.getGeneVertices().get(rowIndex);
            String nm = GeneNetwork.getNodeKeyData(n2, "label");
            switch (columnIndex) {
                case 0: {
                    return nm;
                }
                case 1: {
                    return FilterGeneNetworkUI.this.network.edgesOf(n2).size();
                }
            }
            String key = (String)columnNumToKeyMap.get(columnIndex);
            if (key == null) {
                return null;
            }
            String val = GeneNetwork.getNodeKeyData(n2, key);
            if ("nan".equalsIgnoreCase(val) || val == null) {
                return null;
            }
            double dPerc = Double.parseDouble(val) * 100.0;
            return dPerc;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

