/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.commons.math.distribution.ExponentialDistribution;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.util.FastMath;

public class ExponentialDistributionImpl
extends AbstractContinuousDistribution
implements ExponentialDistribution,
Serializable {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = 2401296428283614780L;
    private double mean;
    private final double solverAbsoluteAccuracy;

    public ExponentialDistributionImpl(double mean) {
        this(mean, 1.0E-9);
    }

    public ExponentialDistributionImpl(double mean, double inverseCumAccuracy) {
        this.setMeanInternal(mean);
        this.solverAbsoluteAccuracy = inverseCumAccuracy;
    }

    @Deprecated
    public void setMean(double mean) {
        this.setMeanInternal(mean);
    }

    private void setMeanInternal(double newMean) {
        if (newMean <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NOT_POSITIVE_MEAN, newMean);
        }
        this.mean = newMean;
    }

    public double getMean() {
        return this.mean;
    }

    @Deprecated
    public double density(Double x2) {
        return this.density((double)x2);
    }

    public double density(double x2) {
        if (x2 < 0.0) {
            return 0.0;
        }
        return FastMath.exp(-x2 / this.mean) / this.mean;
    }

    public double cumulativeProbability(double x2) throws MathException {
        double ret = x2 <= 0.0 ? 0.0 : 1.0 - FastMath.exp(-x2 / this.mean);
        return ret;
    }

    public double inverseCumulativeProbability(double p2) throws MathException {
        if (p2 < 0.0 || p2 > 1.0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.OUT_OF_RANGE_SIMPLE, p2, 0.0, 1.0);
        }
        double ret = p2 == 1.0 ? Double.POSITIVE_INFINITY : -this.mean * FastMath.log(1.0 - p2);
        return ret;
    }

    public double sample() throws MathException {
        return this.randomData.nextExponential(this.mean);
    }

    protected double getDomainLowerBound(double p2) {
        return 0.0;
    }

    protected double getDomainUpperBound(double p2) {
        if (p2 < 0.5) {
            return this.mean;
        }
        return Double.MAX_VALUE;
    }

    protected double getInitialDomain(double p2) {
        if (p2 < 0.5) {
            return this.mean * 0.5;
        }
        return this.mean;
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    public double getSupportLowerBound() {
        return 0.0;
    }

    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public double getNumericalMean() {
        return this.getMean();
    }

    public double getNumericalVariance() {
        double m2 = this.getMean();
        return m2 * m2;
    }
}

