/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util;

import com.mongodb.Bytes;
import com.mongodb.util.AbstractObjectSerializer;
import com.mongodb.util.ObjectSerializer;
import java.util.Iterator;
import java.util.List;
import org.bson.util.ClassMap;

class ClassMapBasedObjectSerializer
extends AbstractObjectSerializer {
    private ClassMap<ObjectSerializer> _serializers = new ClassMap();

    ClassMapBasedObjectSerializer() {
    }

    void addObjectSerializer(Class c2, ObjectSerializer serializer) {
        this._serializers.put(c2, serializer);
    }

    public void serialize(Object obj, StringBuilder buf) {
        Class<?> ancestor;
        if ((obj = Bytes.applyEncodingHooks(obj)) == null) {
            buf.append(" null ");
            return;
        }
        ObjectSerializer serializer = null;
        List<Class<?>> ancestors = ClassMap.getAncestry(obj.getClass());
        Iterator<Class<?>> i$ = ancestors.iterator();
        while (i$.hasNext() && (serializer = this._serializers.get(ancestor = i$.next())) == null) {
        }
        if (serializer == null && obj.getClass().isArray()) {
            serializer = this._serializers.get(Object[].class);
        }
        if (serializer == null) {
            throw new RuntimeException("json can't serialize type : " + obj.getClass());
        }
        serializer.serialize(obj, buf);
    }
}

