/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.popup.JidePopupFactory;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.Resource;
import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.SearchableBarIconsFactory;
import com.jidesoft.swing.SearchableProvider;
import com.jidesoft.swing.WholeWordsSupport;
import com.jidesoft.swing.event.SearchableEvent;
import com.jidesoft.swing.event.SearchableListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class SearchableBar
extends JToolBar
implements SearchableProvider {
    private Searchable _searchable;
    protected JLabel _statusLabel;
    protected JLabel _leadingLabel;
    protected JTextField _textField;
    protected JComboBox _comboBox;
    protected AbstractButton _closeButton;
    protected AbstractButton _findPrevButton;
    protected AbstractButton _findNextButton;
    protected AbstractButton _highlightsButton;
    protected AbstractButton _matchCaseCheckBox;
    protected AbstractButton _wholeWordsCheckBox;
    protected AbstractButton _repeatCheckBox;
    public static final int SHOW_CLOSE = 1;
    public static final int SHOW_NAVIGATION = 2;
    public static final int SHOW_HIGHLIGHTS = 4;
    public static final int SHOW_MATCHCASE = 8;
    public static final int SHOW_REPEATS = 16;
    public static final int SHOW_STATUS = 32;
    public static final int SHOW_WHOLE_WORDS = 64;
    public static final int SHOW_ALL = -1;
    public static final String PROPERTY_MAX_HISTORY_LENGTH = "maxHistoryLength";
    private int _visibleButtons = -17;
    private boolean _compact;
    private boolean _showMatchCount = false;
    private JidePopup _messagePopup;
    private MouseMotionListener _mouseMotionListener;
    private KeyListener _keyListener;
    private List<String> _searchHistory;
    private int _maxHistoryLength = 0;
    private int _previousCursor = -1;
    private static final Color DEFAULT_MISMATCH_BACKGROUND = new Color(255, 85, 85);
    private Color _mismatchBackground;
    private Installer _installer;

    public SearchableBar(Searchable searchable) {
        this(searchable, "", false);
    }

    public SearchableBar(Searchable searchable, boolean compact) {
        this(searchable, "", compact);
    }

    public SearchableBar(Searchable searchable, String initialText, boolean compact) {
        this.setFloatable(false);
        this.setRollover(true);
        this._searchable = searchable;
        this._searchable.addSearchableListener(new SearchableListener(){

            public void searchableEventFired(SearchableEvent e2) {
                if (e2.getID() == 3005 && SearchableBar.this._searchable.getSearchingText() != null && SearchableBar.this._searchable.getSearchingText().length() != 0) {
                    SearchableBar.this.highlightAllOrNext();
                }
            }
        });
        this._searchable.setSearchableProvider(this);
        this._compact = compact;
        this.initComponents(initialText);
    }

    private void initComponents(String initialText) {
        final AbstractAction closeAction = new AbstractAction(){
            private static final long serialVersionUID = -2245391247321137224L;

            public void actionPerformed(ActionEvent e2) {
                if (SearchableBar.this.getInstaller() != null) {
                    SearchableBar.this.getInstaller().closeSearchBar(SearchableBar.this);
                }
            }
        };
        final AbstractAction findNextAction = new AbstractAction(){
            private static final long serialVersionUID = -5263488798121831276L;

            public void actionPerformed(ActionEvent e2) {
                SearchableBar.this._highlightsButton.setSelected(false);
                String text = SearchableBar.this.getSearchingText();
                SearchableBar.this.addSearchingTextToHistory(text);
                int cursor = SearchableBar.this._searchable.getSelectedIndex();
                SearchableBar.this._searchable.setCursor(cursor);
                int found = SearchableBar.this._searchable.findNext(text);
                if (found == cursor) {
                    SearchableBar.this.select(found, text, false);
                    SearchableBar.this.clearStatus();
                } else if (found != -1 && SearchableBar.this._searchable.isRepeats() && found <= cursor) {
                    SearchableBar.this.select(found, text, false);
                    SearchableBar.this.setStatus(SearchableBar.this.getResourceString("SearchableBar.reachedBottomRepeat"), SearchableBar.this.getImageIcon("icons/repeat.png"));
                } else if (!SearchableBar.this._searchable.isRepeats() && found == -1) {
                    SearchableBar.this.setStatus(SearchableBar.this.getResourceString("SearchableBar.reachedBottom"), SearchableBar.this.getImageIcon("icons/error.png"));
                } else if (found != -1) {
                    SearchableBar.this.select(found, text, false);
                    SearchableBar.this.clearStatus();
                }
            }
        };
        final AbstractAction findPrevAction = new AbstractAction(){
            private static final long serialVersionUID = -2534332227053620232L;

            public void actionPerformed(ActionEvent e2) {
                SearchableBar.this._highlightsButton.setSelected(false);
                String text = SearchableBar.this.getSearchingText();
                SearchableBar.this.addSearchingTextToHistory(text);
                int cursor = SearchableBar.this._searchable.getSelectedIndex();
                SearchableBar.this._searchable.setCursor(cursor);
                int found = SearchableBar.this._searchable.findPrevious(text);
                if (found == cursor) {
                    SearchableBar.this.select(found, text, false);
                    SearchableBar.this.clearStatus();
                } else if (found != -1 && SearchableBar.this._searchable.isRepeats() && found >= cursor) {
                    SearchableBar.this.select(found, text, false);
                    SearchableBar.this.setStatus(SearchableBar.this.getResourceString("SearchableBar.reachedTopRepeat"), SearchableBar.this.getImageIcon("icons/repeat.png"));
                } else if (!SearchableBar.this._searchable.isRepeats() && found == -1) {
                    SearchableBar.this.setStatus(SearchableBar.this.getResourceString("SearchableBar.reachedTop"), SearchableBar.this.getImageIcon("icons/error.png"));
                } else if (found != -1) {
                    SearchableBar.this.select(found, text, false);
                    SearchableBar.this.clearStatus();
                }
            }
        };
        this._mouseMotionListener = new MouseMotionListener(){

            public void mouseMoved(MouseEvent e2) {
                SearchableBar.this.hideMessage();
            }

            public void mouseDragged(MouseEvent e2) {
            }
        };
        this._keyListener = new KeyListener(){

            public void keyTyped(KeyEvent e2) {
                SearchableBar.this.hideMessage();
            }

            public void keyPressed(KeyEvent e2) {
            }

            public void keyReleased(KeyEvent e2) {
            }
        };
        this._closeButton = this.createCloseButton(closeAction);
        this._findNextButton = this.createFindNextButton(findNextAction);
        this._findPrevButton = this.createFindPrevButton(findPrevAction);
        this._highlightsButton = this.createHighlightButton();
        this._matchCaseCheckBox = this.createMatchCaseButton();
        this._wholeWordsCheckBox = this.createWholeWordsButton();
        this._repeatCheckBox = this.createRepeatsButton();
        this._statusLabel = new JLabel();
        this._textField = this.createTextField();
        this._textField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e2) {
                SearchableBar.this._textField.selectAll();
            }
        });
        this._textField.setColumns(13);
        DocumentListener listener = new DocumentListener(){
            private Timer timer;
            {
                this.timer = new Timer(SearchableBar.this._searchable.getSearchingDelay(), new ActionListener(){

                    public void actionPerformed(ActionEvent e2) {
                        SearchableBar.this.highlightAllOrNext();
                    }
                });
            }

            public void insertUpdate(DocumentEvent e2) {
                this.startTimer();
            }

            public void removeUpdate(DocumentEvent e2) {
                this.startTimer();
            }

            public void changedUpdate(DocumentEvent e2) {
                this.startTimer();
            }

            void startTimer() {
                if (SearchableBar.this._searchable.getSearchingDelay() > 0) {
                    if (this.timer.isRunning()) {
                        this.timer.restart();
                    } else {
                        this.timer.setRepeats(false);
                        this.timer.start();
                    }
                } else if (SearchableBar.this._searchable.getSearchingDelay() == 0) {
                    SearchableBar.this.highlightAllOrNext();
                }
            }
        };
        this._textField.getDocument().addDocumentListener(listener);
        this._textField.setText(initialText);
        this._textField.registerKeyboardAction(findNextAction, KeyStroke.getKeyStroke(40, 0), 0);
        this._textField.registerKeyboardAction(findNextAction, KeyStroke.getKeyStroke(10, 0), 0);
        this._textField.registerKeyboardAction(findPrevAction, KeyStroke.getKeyStroke(38, 0), 0);
        this._textField.registerKeyboardAction(closeAction, KeyStroke.getKeyStroke(27, 0), 0);
        this._comboBox = this.createComboBox();
        if (this._comboBox.getEditor().getEditorComponent() instanceof JTextField) {
            ((JTextField)this._comboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(listener);
            this.registerKeyboardActions(closeAction, findNextAction, findPrevAction);
            this._comboBox.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent e2) {
                    SearchableBar.this.unregisterKeyboardActions();
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e2) {
                    SearchableBar.this.registerKeyboardActions(closeAction, findNextAction, findPrevAction);
                }

                public void popupMenuCanceled(PopupMenuEvent e2) {
                    SearchableBar.this.registerKeyboardActions(closeAction, findNextAction, findPrevAction);
                }
            });
        }
        this._comboBox.setSelectedItem(initialText);
        this._comboBox.setPreferredSize(this._textField.getPreferredSize());
        this.installComponents();
        int found = this._searchable.findFromCursor(this.getSearchingText());
        if (initialText.length() != 0 && found == -1) {
            this.select(found, initialText, false);
        }
    }

    private void registerKeyboardActions(AbstractAction closeAction, AbstractAction findNextAction, AbstractAction findPrevAction) {
        ((JTextField)this._comboBox.getEditor().getEditorComponent()).registerKeyboardAction(findNextAction, KeyStroke.getKeyStroke(40, 0), 0);
        ((JTextField)this._comboBox.getEditor().getEditorComponent()).registerKeyboardAction(findNextAction, KeyStroke.getKeyStroke(10, 0), 0);
        ((JTextField)this._comboBox.getEditor().getEditorComponent()).registerKeyboardAction(findPrevAction, KeyStroke.getKeyStroke(38, 0), 0);
        ((JTextField)this._comboBox.getEditor().getEditorComponent()).registerKeyboardAction(closeAction, KeyStroke.getKeyStroke(27, 0), 0);
    }

    private void unregisterKeyboardActions() {
        ((JTextField)this._comboBox.getEditor().getEditorComponent()).unregisterKeyboardAction(KeyStroke.getKeyStroke(40, 0));
        ((JTextField)this._comboBox.getEditor().getEditorComponent()).unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        ((JTextField)this._comboBox.getEditor().getEditorComponent()).unregisterKeyboardAction(KeyStroke.getKeyStroke(38, 0));
        ((JTextField)this._comboBox.getEditor().getEditorComponent()).unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
    }

    protected JTextField createTextField() {
        return new JTextField();
    }

    protected JComboBox createComboBox() {
        JComboBox comboBox = new JComboBox();
        comboBox.setEditable(true);
        return comboBox;
    }

    public Searchable getSearchable() {
        return this._searchable;
    }

    protected AbstractButton createCloseButton(AbstractAction closeAction) {
        JButton button = new JButton(this.getImageIcon("icons/close.png"));
        button.addActionListener(closeAction);
        button.setRolloverEnabled(true);
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setOpaque(false);
        button.setRequestFocusEnabled(false);
        button.setFocusable(false);
        button.setRolloverIcon(this.getImageIcon("icons/closeR.png"));
        return button;
    }

    protected AbstractButton createFindNextButton(AbstractAction findNextAction) {
        JButton button = new JButton(this._compact ? "" : this.getResourceString("SearchableBar.findNext"), this.getImageIcon("icons/next.png"));
        button.setToolTipText(this.getResourceString("SearchableBar.findNext.tooltip"));
        button.setMnemonic(this.getResourceString("SearchableBar.findNext.mnemonic").charAt(0));
        button.setRolloverIcon(this.getImageIcon("icons/nextR.png"));
        button.setDisabledIcon(this.getImageIcon("icons/nextD.png"));
        button.setRequestFocusEnabled(false);
        button.setFocusable(false);
        button.addActionListener(findNextAction);
        button.setEnabled(false);
        return button;
    }

    protected AbstractButton createFindPrevButton(AbstractAction findPrevAction) {
        JButton button = new JButton(this._compact ? "" : this.getResourceString("SearchableBar.findPrevious"), this.getImageIcon("icons/previous.png"));
        button.setToolTipText(this.getResourceString("SearchableBar.findPrevious.tooltip"));
        button.setMnemonic(this.getResourceString("SearchableBar.findPrevious.mnemonic").charAt(0));
        button.setRolloverIcon(this.getImageIcon("icons/previousR.png"));
        button.setDisabledIcon(this.getImageIcon("icons/previousD.png"));
        button.setRequestFocusEnabled(false);
        button.setFocusable(false);
        button.addActionListener(findPrevAction);
        button.setEnabled(false);
        return button;
    }

    protected AbstractButton createHighlightButton() {
        JToggleButton button = new JToggleButton(this._compact ? "" : this.getResourceString("SearchableBar.highlights"), this.getImageIcon("icons/highlights.png"));
        button.setToolTipText(this.getResourceString("SearchableBar.highlights.tooltip"));
        button.setMnemonic(this.getResourceString("SearchableBar.highlights.mnemonic").charAt(0));
        button.setSelectedIcon(this.getImageIcon("icons/highlightsS.png"));
        button.setDisabledIcon(this.getImageIcon("icons/highlightsD.png"));
        button.setRolloverIcon(this.getImageIcon("icons/highlightsR.png"));
        button.setRolloverSelectedIcon(this.getImageIcon("icons/highlightsRS.png"));
        button.setRequestFocusEnabled(false);
        button.setFocusable(false);
        AbstractAction highlightAllAction = new AbstractAction(){
            private static final long serialVersionUID = 5170786863522331175L;

            public void actionPerformed(ActionEvent e2) {
                SearchableBar.this.addSearchingTextToHistory(SearchableBar.this.getSearchingText());
                SearchableBar.this.highlightAllOrNext();
            }
        };
        button.addActionListener(highlightAllAction);
        button.setEnabled(false);
        return button;
    }

    protected AbstractButton createRepeatsButton() {
        JCheckBox button = new JCheckBox(this.getResourceString("SearchableBar.repeats"));
        button.setMnemonic(this.getResourceString("SearchableBar.repeats.mnemonic").charAt(0));
        button.setRequestFocusEnabled(false);
        button.setFocusable(false);
        button.setSelected(this.getSearchable().isRepeats());
        button.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e2) {
                if (e2.getSource() instanceof AbstractButton) {
                    SearchableBar.this.getSearchable().setRepeats(((AbstractButton)e2.getSource()).isSelected());
                }
            }
        });
        button.setOpaque(false);
        return button;
    }

    protected AbstractButton createMatchCaseButton() {
        JCheckBox checkBox = new JCheckBox(this.getResourceString("SearchableBar.matchCase"));
        checkBox.setMnemonic(this.getResourceString("SearchableBar.matchCase.mnemonic").charAt(0));
        checkBox.setRequestFocusEnabled(false);
        checkBox.setFocusable(false);
        checkBox.setSelected(this.getSearchable().isCaseSensitive());
        checkBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e2) {
                if (e2.getSource() instanceof AbstractButton) {
                    SearchableBar.this.getSearchable().setCaseSensitive(((AbstractButton)e2.getSource()).isSelected());
                    SearchableBar.this.addSearchingTextToHistory(SearchableBar.this.getSearchingText());
                    SearchableBar.this.highlightAllOrNext();
                }
            }
        });
        checkBox.setOpaque(false);
        return checkBox;
    }

    protected AbstractButton createWholeWordsButton() {
        JCheckBox checkBox = new JCheckBox(this.getResourceString("SearchableBar.wholeWords"));
        checkBox.setMnemonic(this.getResourceString("SearchableBar.wholeWords.mnemonic").charAt(0));
        checkBox.setRequestFocusEnabled(false);
        checkBox.setFocusable(false);
        if (this.getSearchable() instanceof WholeWordsSupport) {
            checkBox.setSelected(((WholeWordsSupport)((Object)this.getSearchable())).isWholeWords());
        } else {
            checkBox.setSelected(false);
            checkBox.setEnabled(false);
        }
        checkBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e2) {
                if (e2.getSource() instanceof AbstractButton && SearchableBar.this.getSearchable() instanceof WholeWordsSupport) {
                    ((WholeWordsSupport)((Object)SearchableBar.this.getSearchable())).setWholeWords(((AbstractButton)e2.getSource()).isSelected());
                    SearchableBar.this.addSearchingTextToHistory(SearchableBar.this.getSearchingText());
                    SearchableBar.this.highlightAllOrNext();
                }
            }
        });
        checkBox.setOpaque(false);
        return checkBox;
    }

    protected void installComponents() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new JideBoxLayout(this, 0));
        this.add(Box.createHorizontalStrut(4), "fix");
        if ((this._visibleButtons & 1) != 0) {
            this.add(this._closeButton);
            this.add(Box.createHorizontalStrut(10));
        }
        this._leadingLabel = new JLabel(this.getResourceString("SearchableBar.find"));
        this._leadingLabel.setDisplayedMnemonic(this.getResourceString("SearchableBar.find.mnemonic").charAt(0));
        this.add(this._leadingLabel);
        this.add(Box.createHorizontalStrut(2), "fix");
        this.add((Component)JideSwingUtilities.createCenterPanel(this._textField), "fix");
        this.add((Component)JideSwingUtilities.createCenterPanel(this._comboBox), "fix");
        if (this.getMaxHistoryLength() == 0) {
            this._leadingLabel.setLabelFor(this._textField);
            this._textField.setVisible(true);
            this._comboBox.setVisible(false);
        } else {
            this._leadingLabel.setLabelFor(this._comboBox);
            this._comboBox.setVisible(true);
            this._textField.setVisible(false);
        }
        this.add(Box.createHorizontalStrut(2), "fix");
        if ((this._visibleButtons & 2) != 0) {
            this.add(this._findNextButton);
            this.add(this._findPrevButton);
        }
        if ((this._visibleButtons & 4) != 0) {
            this.add(this._highlightsButton);
        }
        if ((this._visibleButtons & 8) != 0) {
            this.add(this._matchCaseCheckBox);
            this.add(Box.createHorizontalStrut(2));
        }
        if ((this._visibleButtons & 0x40) != 0 && this.getSearchable() instanceof WholeWordsSupport) {
            this.add(this._wholeWordsCheckBox);
            this.add(Box.createHorizontalStrut(2));
        }
        if ((this._visibleButtons & 0x10) != 0) {
            this.add(this._repeatCheckBox);
            this.add(Box.createHorizontalStrut(2));
        }
        if ((this._visibleButtons & 0x20) != 0) {
            this.add(Box.createHorizontalStrut(24));
            this.add((Component)this._statusLabel, "vary");
        }
        this.add(Box.createHorizontalStrut(6), "fix");
    }

    public boolean isHighlightAll() {
        return this._highlightsButton.isSelected();
    }

    public void setHighlightAll(boolean highlightAll) {
        this._highlightsButton.setSelected(highlightAll);
    }

    private void highlightAllOrNext() {
        if (this._highlightsButton.isSelected()) {
            this._previousCursor = this._searchable.getCurrentIndex();
            this.highlightAll();
        } else {
            if (this._previousCursor >= 0) {
                this._searchable.setCursor(this._previousCursor);
                this._searchable.setSelectedIndex(this._previousCursor, false);
            }
            this.highlightNext();
        }
    }

    private void highlightAll() {
        String text = this.getSearchingText();
        if (text == null || text.length() == 0) {
            this._findNextButton.setEnabled(false);
            this._findPrevButton.setEnabled(false);
            this._highlightsButton.setEnabled(false);
            this.select(-1, "", false);
            this.clearStatus();
            return;
        }
        boolean old = this._searchable.isRepeats();
        this._searchable.setRepeats(false);
        int index = this._searchable.findFirst(text);
        if (index != -1) {
            this._searchable.setSelectedIndex(index, false);
            this._searchable.setCursor(index);
            this._findNextButton.setEnabled(true);
            this._findPrevButton.setEnabled(true);
            this._highlightsButton.setEnabled(true);
            this.clearStatus();
        } else {
            this.select(-1, text, false);
            this._findNextButton.setEnabled(false);
            this._findPrevButton.setEnabled(false);
            this._highlightsButton.setEnabled(false);
            this.setStatus(this.getResourceString("SearchableBar.notFound"), this.getImageIcon("icons/error.png"));
        }
        this._searchable.highlightAll();
        this._searchable.setRepeats(old);
        this._searchable.setCursor(0);
    }

    private void highlightNext() {
        this._searchable.cancelHighlightAll();
        String text = this.getSearchingText();
        if (text == null || text.length() == 0) {
            this._findNextButton.setEnabled(false);
            this._findPrevButton.setEnabled(false);
            this._highlightsButton.setEnabled(false);
            this.select(-1, "", false);
            this.clearStatus();
            return;
        }
        int found = this._searchable.findFromCursor(text);
        if (found == -1) {
            this.select(-1, "", false);
            this._findNextButton.setEnabled(false);
            this._findPrevButton.setEnabled(false);
            this._highlightsButton.setEnabled(false);
            this.setStatus(this.getResourceString("SearchableBar.notFound"), this.getImageIcon("icons/error.png"));
        } else {
            this.select(found, text, false);
            this._findNextButton.setEnabled(true);
            this._findPrevButton.setEnabled(true);
            this._highlightsButton.setEnabled(true);
            this.clearStatus();
        }
    }

    private void clearStatus() {
        this._statusLabel.setIcon(null);
        this._textField.setBackground(UIDefaultsLookup.getColor("TextField.background"));
        this._comboBox.getEditor().getEditorComponent().setBackground(UIDefaultsLookup.getColor("TextField.background"));
        if (this.isShowMatchCount() && (this._textField.getText().length() > 0 || this._comboBox.getEditor().getEditorComponent() instanceof JTextField && ((JTextField)this._comboBox.getEditor().getEditorComponent()).getText().length() > 0)) {
            this._statusLabel.setText(this.getSearchable().getMatchCount() + " " + this.getResourceString("SearchableBar.matches"));
        } else {
            this._statusLabel.setText("");
        }
        this.hideMessage();
    }

    private void setStatus(String message, Icon icon) {
        this._statusLabel.setIcon(icon);
        this._statusLabel.setText(message);
        this._statusLabel.setToolTipText(message);
        if (!this._statusLabel.isShowing() || this._statusLabel.getWidth() < 25) {
            this.showMessage(message);
        }
    }

    public void focusSearchField() {
        if (this._textField != null && this._textField.isVisible()) {
            this._textField.requestFocus();
        }
        if (this._comboBox != null && this._comboBox.isVisible()) {
            this._comboBox.requestFocus();
        }
    }

    protected void select(int index, String searchingText, boolean incremental) {
        if (index != -1) {
            this._searchable.setSelectedIndex(index, incremental);
            this._searchable.setCursor(index, incremental);
            this._textField.setBackground(UIDefaultsLookup.getColor("TextField.background"));
            this._comboBox.getEditor().getEditorComponent().setBackground(UIDefaultsLookup.getColor("TextField.background"));
        } else {
            this._searchable.setSelectedIndex(-1, false);
            this._textField.setBackground(this.getMismatchBackground());
            this._comboBox.getEditor().getEditorComponent().setBackground(UIDefaultsLookup.getColor("TextField.background"));
        }
        this._searchable.firePropertyChangeEvent(searchingText);
        if (index != -1) {
            Object element = this._searchable.getElementAt(index);
            this._searchable.fireSearchableEvent(new SearchableEvent(this._searchable, 3002, searchingText, element, this._searchable.convertElementToString(element)));
        } else {
            this._searchable.fireSearchableEvent(new SearchableEvent(this._searchable, 3003, searchingText));
        }
    }

    public String getSearchingText() {
        if (this._textField != null && this._textField.isVisible()) {
            return this._textField.getText();
        }
        if (this._comboBox != null && this._comboBox.isVisible()) {
            Object item = this._comboBox.getEditor().getItem();
            return item == null ? "" : item.toString();
        }
        return "";
    }

    public void setSearchingText(String searchingText) {
        if (this._textField != null && this._textField.isVisible()) {
            this._textField.setText(searchingText);
        }
        if (this._comboBox != null && this._comboBox.isVisible()) {
            this._comboBox.setSelectedItem(searchingText);
        }
    }

    public boolean isPassive() {
        return false;
    }

    public void setMismatchForeground(Color mismatchBackground) {
        this._mismatchBackground = mismatchBackground;
    }

    public Color getMismatchBackground() {
        if (this._mismatchBackground == null) {
            return DEFAULT_MISMATCH_BACKGROUND;
        }
        return this._mismatchBackground;
    }

    public String[] getSearchHistory() {
        return this._searchHistory == null ? new String[]{} : this._searchHistory.toArray(new String[this._searchHistory.size()]);
    }

    public void setSearchHistory(String[] searchHistory) {
        if (searchHistory == null || searchHistory.length == 0) {
            this._searchHistory = null;
        } else {
            this._searchHistory = new ArrayList<String>();
            this._searchHistory.addAll(Arrays.asList(searchHistory));
        }
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        if (this._searchHistory != null) {
            for (int i2 = this._searchHistory.size() - 1; i2 >= 0; --i2) {
                model.addElement(this._searchHistory.get(i2));
            }
        }
        model.insertElementAt("", 0);
        this._comboBox.setModel(model);
        this._comboBox.setSelectedIndex(0);
    }

    public int getMaxHistoryLength() {
        return this._maxHistoryLength;
    }

    public void setMaxHistoryLength(int maxHistoryLength) {
        if (this._maxHistoryLength != maxHistoryLength) {
            int old = this._maxHistoryLength;
            this._maxHistoryLength = maxHistoryLength;
            if (this.getMaxHistoryLength() == 0) {
                this._leadingLabel.setLabelFor(this._textField);
                this._textField.setVisible(true);
                Object item = this._comboBox.getEditor().getItem();
                this._textField.setText(item == null ? "" : item.toString());
                this._comboBox.setVisible(false);
            } else if (!this._comboBox.isVisible()) {
                this._leadingLabel.setLabelFor(this._comboBox);
                this._comboBox.setVisible(true);
                this._comboBox.getEditor().setItem(this._textField.getText());
                this._textField.setVisible(false);
            }
            this.firePropertyChange(PROPERTY_MAX_HISTORY_LENGTH, old, this._maxHistoryLength);
        }
    }

    public boolean isShowMatchCount() {
        return this._showMatchCount;
    }

    public void setShowMatchCount(boolean showMatchCount) {
        this._showMatchCount = showMatchCount;
        if (this.getSearchable() != null) {
            this.getSearchable().setCountMatch(this.isShowMatchCount());
        }
    }

    public Installer getInstaller() {
        return this._installer;
    }

    public void setInstaller(Installer installer) {
        this._installer = installer;
    }

    public static SearchableBar install(Searchable searchable, KeyStroke keyStroke, Installer installer) {
        final SearchableBar searchableBar = new SearchableBar(searchable);
        searchableBar.setInstaller(installer);
        ((JComponent)searchable.getComponent()).registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = 8328919754409621715L;

            public void actionPerformed(ActionEvent e2) {
                searchableBar.getInstaller().openSearchBar(searchableBar);
                searchableBar.focusSearchField();
            }
        }, keyStroke, 1);
        return searchableBar;
    }

    public void processKeyEvent(KeyEvent e2) {
    }

    public int getVisibleButtons() {
        return this._visibleButtons;
    }

    public void setVisibleButtons(int visibleButtons) {
        this._visibleButtons = visibleButtons;
        this.removeAll();
        this.installComponents();
        this.revalidate();
        this.repaint();
    }

    public boolean isCompact() {
        return this._compact;
    }

    public void setCompact(boolean compact) {
        this._compact = compact;
        this._findNextButton.setText(this._compact ? "" : this.getResourceString("SearchableBar.findNext"));
        this._highlightsButton.setText(this._compact ? "" : this.getResourceString("SearchableBar.highlights"));
        this._findPrevButton.setText(this._compact ? "" : this.getResourceString("SearchableBar.findPrevious"));
    }

    protected ImageIcon getImageIcon(String name) {
        return SearchableBarIconsFactory.getImageIcon(name);
    }

    protected String getResourceString(String key) {
        return Resource.getResourceBundle(Locale.getDefault()).getString(key);
    }

    private void showMessage(String message) {
        this.hideMessage();
        this._messagePopup = JidePopupFactory.getSharedInstance().createPopup();
        JLabel label = new JLabel(message);
        label.setOpaque(true);
        label.setFont(UIDefaultsLookup.getFont("Label.font").deriveFont(1, 11.0f));
        label.setBackground(new Color(253, 254, 226));
        label.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 6));
        label.setForeground(UIDefaultsLookup.getColor("ToolTip.foreground"));
        this._messagePopup.getContentPane().setLayout(new BorderLayout());
        this._messagePopup.getContentPane().add(label);
        if (this._textField != null && this._textField.isVisible()) {
            this._messagePopup.setOwner(this._textField);
        }
        if (this._comboBox != null && this._comboBox.isVisible()) {
            this._messagePopup.setOwner(this._comboBox);
        }
        this._messagePopup.setDefaultMoveOperation(0);
        this._messagePopup.setTransient(true);
        this._messagePopup.showPopup();
        this.addMouseMotionListener(this._mouseMotionListener);
        if (this._textField != null && this._textField.isVisible()) {
            this._textField.addKeyListener(this._keyListener);
        }
        if (this._comboBox != null && this._comboBox.isVisible()) {
            this._comboBox.addKeyListener(this._keyListener);
        }
    }

    private void hideMessage() {
        if (this._messagePopup != null) {
            this._messagePopup.hidePopupImmediately();
            this._messagePopup = null;
        }
        if (this._mouseMotionListener != null) {
            this.removeMouseMotionListener(this._mouseMotionListener);
        }
        if (this._keyListener != null) {
            this._textField.removeKeyListener(this._keyListener);
            this._comboBox.removeKeyListener(this._keyListener);
        }
    }

    private void addSearchingTextToHistory(String searchingText) {
        if (searchingText == null || searchingText.length() == 0) {
            return;
        }
        if (this._searchHistory == null) {
            this._searchHistory = new ArrayList<String>();
        }
        if (this._searchHistory.size() <= 0) {
            this._searchHistory.add(searchingText);
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
            model.addElement(searchingText);
            this._comboBox.setModel(model);
            return;
        }
        if (JideSwingUtilities.equals(this._searchHistory.get(this._searchHistory.size() - 1), searchingText)) {
            return;
        }
        this._searchHistory.remove(searchingText);
        this._searchHistory.add(searchingText);
        if (this.getMaxHistoryLength() > 0 && this._searchHistory.size() > this.getMaxHistoryLength()) {
            this._searchHistory.remove(0);
        }
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (int i2 = this._searchHistory.size() - 1; i2 >= 0; --i2) {
            model.addElement(this._searchHistory.get(i2));
        }
        this._comboBox.setModel(model);
    }

    public static interface Installer {
        public void openSearchBar(SearchableBar var1);

        public void closeSearchBar(SearchableBar var1);
    }
}

