/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental.equivalence;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.jgrapht.experimental.equivalence.EquivalenceComparator;
import org.jgrapht.experimental.equivalence.EquivalenceComparatorChain;

public class EquivalenceComparatorChainBase<E, C>
implements EquivalenceComparatorChain<E, C> {
    private List<EquivalenceComparator<? super E, ? super C>> chain = new LinkedList<EquivalenceComparator<? super E, ? super C>>();

    public EquivalenceComparatorChainBase(EquivalenceComparator<E, C> equivalenceComparator) {
        this.chain.add(equivalenceComparator);
    }

    @Override
    public void appendComparator(EquivalenceComparator equivalenceComparator) {
        if (equivalenceComparator != null) {
            this.chain.add(equivalenceComparator);
        }
    }

    @Override
    public boolean equivalenceCompare(E e2, E e3, C c2, C c3) {
        for (EquivalenceComparator<E, C> equivalenceComparator : this.chain) {
            if (equivalenceComparator.equivalenceCompare(e2, e3, c2, c3)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int equivalenceHashcode(E e2, C c2) {
        StringBuffer stringBuffer = new StringBuffer();
        ListIterator<EquivalenceComparator<E, C>> listIterator = this.chain.listIterator();
        while (listIterator.hasNext()) {
            EquivalenceComparator<E, C> equivalenceComparator = listIterator.next();
            int n2 = equivalenceComparator.equivalenceHashcode(e2, c2);
            stringBuffer.append(n2);
            if (!listIterator.hasNext()) continue;
            stringBuffer.append('+');
        }
        return stringBuffer.toString().hashCode();
    }
}

