/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.DataRenderer;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.renderer.XYPlotRenderer;
import org.broad.igv.session.IGVSessionReader;
import org.broad.igv.session.SessionXmlAdapters;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.LoadedDataInterval;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.util.ResourceLocator;

@XmlType(factoryMethod="getNextTrack")
public abstract class DataTrack
extends AbstractTrack {
    private static Logger log = Logger.getLogger(DataTrack.class);
    private DataRenderer renderer;
    private HashMap<String, LoadedDataInterval> loadedIntervalCache = new HashMap(200);
    private boolean featuresLoading = false;

    public DataTrack(ResourceLocator locator, String id, String name) {
        super(locator, id, name);
        this.autoScale = PreferenceManager.getInstance().getAsBoolean("CHART.AUTOSCALE");
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        if (this.featuresLoading) {
            return;
        }
        List<LocusScore> inViewScores = this.getInViewScores(context, rect);
        if ((inViewScores == null || inViewScores.size() == 0) && "All".equals(context.getChr())) {
            Graphics2D g2 = context.getGraphic2DForColor(Color.gray);
            GraphicUtils.drawCenteredText("Data not available for whole genome view; zoom in to see data", rect, g2);
        } else {
            this.getRenderer().render(inViewScores, context, rect, (Track)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overlay(RenderContext context, Rectangle rect) {
        List<LocusScore> inViewScores = this.getInViewScores(context, rect);
        if (inViewScores != null) {
            List<LocusScore> list = inViewScores;
            synchronized (list) {
                this.getRenderer().renderScores(this, inViewScores, context, rect);
            }
        }
        this.getRenderer().renderBorder(this, context, rect);
    }

    public List<LocusScore> getInViewScores(RenderContext context, Rectangle rect) {
        String chr = context.getChr();
        int start = (int)context.getOrigin();
        int end = (int)context.getEndLocation() + 1;
        int zoom = context.getZoom();
        List<LocusScore> inViewScores = null;
        LoadedDataInterval interval = this.loadedIntervalCache.get(context.getReferenceFrame().getName());
        inViewScores = interval != null && interval.contains(chr, start, end, zoom) ? interval.getScores() : this.loadScores(context);
        if ((inViewScores == null || inViewScores.size() == 0) && "All".equals(chr)) {
            Graphics2D g2 = context.getGraphic2DForColor(Color.gray);
            GraphicUtils.drawCenteredText("Data not available for whole genome view; select chromosome to see data", rect, g2);
        } else if (this.autoScale && !FrameManager.isGeneListMode()) {
            InViewInterval inter = DataTrack.computeScale(start, end, inViewScores);
            if (inter.endIdx > inter.startIdx) {
                inViewScores = inViewScores.subList(inter.startIdx, inter.endIdx);
                DataRange dr = this.getDataRange();
                float min = Math.min(0.0f, inter.dataMin);
                float base = Math.max(min, dr.getBaseline());
                float max = inter.dataMax;
                if (max - min <= 2.8E-45f) {
                    max = min + 1.0f;
                }
                DataRange newDR = new DataRange(min, base, max, dr.isDrawBaseline());
                newDR.setType(dr.getType());
                this.setDataRange(newDR);
            }
        }
        return inViewScores;
    }

    @Override
    public synchronized void load(RenderContext context) {
        String chr = context.getChr();
        int start = (int)context.getOrigin();
        int end = (int)context.getEndLocation() + 1;
        int zoom = context.getZoom();
        LoadedDataInterval interval = this.loadedIntervalCache.get(context.getReferenceFrame().getName());
        if (interval == null || !interval.contains(chr, start, end, zoom)) {
            this.loadScores(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LocusScore> loadScores(RenderContext context) {
        String chr = context.getChr();
        int start = (int)context.getOrigin();
        int end = (int)context.getEndLocation() + 1;
        int zoom = context.getZoom();
        try {
            this.featuresLoading = true;
            int maxEnd = end;
            Genome genome = GenomeManager.getInstance().getCurrentGenome();
            String queryChr = chr;
            if (genome != null) {
                queryChr = genome.getCanonicalChrName(chr);
                Chromosome c2 = genome.getChromosome(chr);
                if (c2 != null) {
                    maxEnd = Math.max(c2.getLength(), end);
                }
            }
            boolean multiLocus = FrameManager.getFrames().size() > 4;
            int delta = multiLocus ? 1 : (end - start) / 2;
            int expandedStart = Math.max(0, start - delta);
            int expandedEnd = Math.min(maxEnd, end + delta);
            List<LocusScore> inViewScores = this.getSummaryScores(queryChr, expandedStart, expandedEnd, zoom);
            LoadedDataInterval interval = new LoadedDataInterval(chr, start, end, zoom, inViewScores);
            this.loadedIntervalCache.put(context.getReferenceFrame().getName(), interval);
            List<LocusScore> list = inViewScores;
            return list;
        }
        finally {
            this.featuresLoading = false;
        }
    }

    public void clearCaches() {
        this.loadedIntervalCache.clear();
    }

    @Override
    public void setRendererClass(Class rc) {
        try {
            this.renderer = (DataRenderer)rc.newInstance();
        }
        catch (Exception ex) {
            log.error("Error instantiating renderer ", ex);
        }
    }

    @Override
    protected void setRenderer(Renderer renderer) {
        this.renderer = (DataRenderer)renderer;
    }

    @Override
    @XmlJavaTypeAdapter(value=SessionXmlAdapters.Renderer.class)
    @XmlAttribute(name="renderer")
    public DataRenderer getRenderer() {
        if (this.renderer == null) {
            this.setRendererClass(this.getDefaultRendererClass());
        }
        return this.renderer;
    }

    @Override
    public String getValueStringAt(String chr, double position, int y, ReferenceFrame frame) {
        StringBuffer buf = new StringBuffer();
        LocusScore score = this.getLocusScoreAt(chr, position, frame);
        if (score == null) {
            return null;
        }
        buf.append(this.getName() + "<br>");
        if (this.getDataRange() != null && this.getRenderer() instanceof XYPlotRenderer) {
            buf.append("Data scale: " + this.getDataRange().getMinimum() + " - " + this.getDataRange().getMaximum() + "<br>");
        }
        buf.append(score.getValueString(position, this.getWindowFunction()));
        return buf.toString();
    }

    private LocusScore getLocusScoreAt(String chr, double position, ReferenceFrame frame) {
        int zoom = Math.max(0, frame.getZoom());
        List<LocusScore> scores = this.getSummaryScores(chr, (int)position - 10, (int)position + 10, zoom);
        if (scores == null) {
            return null;
        }
        double bpPerPixel = frame.getScale();
        int buffer = (int)(2.0 * bpPerPixel);
        return FeatureUtils.getFeatureAt(position, buffer, scores);
    }

    public abstract List<LocusScore> getSummaryScores(String var1, int var2, int var3, int var4);

    public static InViewInterval computeScale(double origin, double end, List<LocusScore> scores) {
        InViewInterval interval = new InViewInterval();
        if (scores.size() == 1) {
            interval.dataMax = Math.max(0.0f, scores.get(0).getScore());
            interval.dataMin = Math.min(0.0f, scores.get(0).getScore());
        } else {
            int i2;
            interval.startIdx = 0;
            interval.endIdx = scores.size();
            for (i2 = 1; i2 < scores.size(); ++i2) {
                if (!((double)scores.get(i2).getEnd() >= origin)) continue;
                interval.startIdx = i2 - 1;
                break;
            }
            for (i2 = interval.startIdx + 1; i2 < scores.size(); ++i2) {
                LocusScore locusScore = scores.get(i2);
                float value = locusScore.getScore();
                if (Float.isNaN(value)) {
                    value = 0.0f;
                }
                interval.dataMax = Math.max(interval.dataMax, value);
                interval.dataMin = Math.min(interval.dataMin, value);
                if (!((double)locusScore.getStart() > end)) continue;
                interval.endIdx = i2;
                break;
            }
        }
        return interval;
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type, String frameName, List<Track> tracks) {
        if (end <= start) {
            return 0.0f;
        }
        if (this.isRegionScoreType(type)) {
            LoadedDataInterval loadedInterval;
            List<LocusScore> scores = null;
            if (frameName == null) {
                frameName = chr + start + end;
                frameName = frameName + zoom;
                frameName = frameName + (Object)((Object)type);
            }
            if ((loadedInterval = this.loadedIntervalCache.get(frameName)) != null && loadedInterval.contains(chr, start, end, zoom)) {
                scores = loadedInterval.getScores();
            } else {
                scores = this.getSummaryScores(chr, start, end, zoom);
                this.loadedIntervalCache.put(frameName, new LoadedDataInterval(chr, start, end, zoom, scores));
            }
            if (type == RegionScoreType.FLUX) {
                float sumDiffs = 0.0f;
                float lastScore = Float.NaN;
                for (LocusScore score : scores) {
                    if (score.getEnd() < start || score.getStart() > end) continue;
                    if (Float.isNaN(lastScore)) {
                        lastScore = Math.min(2.0f, Math.max(-2.0f, this.logScaleData(score.getScore())));
                        continue;
                    }
                    float s2 = Math.min(2.0f, Math.max(-2.0f, this.logScaleData(score.getScore())));
                    sumDiffs += Math.abs(s2 - lastScore);
                    lastScore = s2;
                }
                return sumDiffs;
            }
            if (type == RegionScoreType.MUTATION_COUNT) {
                if (!Globals.isHeadless() && tracks == null) {
                    tracks = IGV.getInstance().getOverlayTracks(this);
                }
                float count = 0.0f;
                String tSamp = this.getSample();
                if (tracks != null && tSamp != null) {
                    for (Track t2 : tracks) {
                        if (t2.getTrackType() != TrackType.MUTATION || !tSamp.equals(t2.getSample())) continue;
                        count += t2.getRegionScore(chr, start, end, zoom, type, frameName);
                    }
                }
                return count;
            }
            float regionScore = 0.0f;
            int intervalSum = 0;
            boolean hasNan = false;
            for (LocusScore score : scores) {
                if (score.getEnd() < start || score.getStart() > end) continue;
                int interval = Math.min(end, score.getEnd()) - Math.max(start, score.getStart());
                float value = score.getScore();
                if (Float.isNaN(value)) {
                    hasNan = true;
                    continue;
                }
                regionScore += value * (float)interval;
                intervalSum += interval;
            }
            if (intervalSum <= 0) {
                if (hasNan) {
                    return Float.NaN;
                }
                return -3.4028235E38f;
            }
            return type == RegionScoreType.DELETION ? -regionScore : (regionScore /= (float)intervalSum);
        }
        return -3.4028235E38f;
    }

    public double getAverageScore(String chr, int start, int end, int zoom) {
        double regionScore = 0.0;
        int intervalSum = 0;
        List<LocusScore> scores = this.getSummaryScores(chr, start, end, zoom);
        for (LocusScore score : scores) {
            if (score.getEnd() < start || score.getStart() > end) continue;
            int interval = 1;
            float value = score.getScore();
            regionScore += (double)(value * (float)interval);
            intervalSum += interval;
        }
        if (intervalSum > 0) {
            regionScore /= (double)intervalSum;
        }
        return regionScore;
    }

    private static DataTrack getNextTrack() {
        return (DataTrack)IGVSessionReader.getNextTrack();
    }

    public static class InViewInterval {
        public int startIdx;
        public int endIdx;
        public float dataMax = 0.0f;
        public float dataMin = 0.0f;
    }
}

