/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.Feature;
import htsjdk.tribble.exception.CodecLineParsingException;
import htsjdk.tribble.readers.LineIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.exceptions.ParserException;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.SequenceOntology;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.FeatureFileHeader;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.StringUtils;
import org.broad.igv.util.collections.CI;
import org.broad.igv.util.collections.MultiMap;

public class GFFCodec
extends AsciiFeatureCodec<Feature> {
    private static Logger log = Logger.getLogger(GFFCodec.class);
    static HashSet<String> ignoredTypes = new HashSet();
    private TrackProperties trackProperties = null;
    private CI.CIHashSet featuresToHide = new CI.CIHashSet();
    private FeatureFileHeader header;
    private Helper helper;
    private Genome genome;
    private boolean fastaSection = false;
    static String[] nameFields;
    static StringBuffer buf;

    public GFFCodec(Genome genome) {
        super(Feature.class);
        this.helper = new GFF2Helper();
        this.genome = genome;
    }

    public GFFCodec(Version version, Genome genome) {
        super(Feature.class);
        this.genome = genome;
        this.helper = version == Version.GFF2 ? new GFF2Helper() : new GFF3Helper();
    }

    public void readHeaderLine(String line) {
        if (this.header == null) {
            this.header = new FeatureFileHeader();
        }
        if (line.startsWith("#track") || line.startsWith("##track")) {
            this.trackProperties = new TrackProperties();
            ParsingUtils.parseTrackLine(line, this.trackProperties);
            this.header.setTrackProperties(this.trackProperties);
        } else if (line.startsWith("##gff-version") && line.contains("3")) {
            String[] tokens = Globals.whitespacePattern.split(line);
            if (tokens.length > 1 && tokens[1].startsWith("3")) {
                this.helper = new GFF3Helper();
            }
        } else if (line.startsWith("#nodecode") || line.startsWith("##nodecode")) {
            this.helper.setUrlDecoding(false);
        } else if (line.startsWith("#hide") || line.startsWith("##hide")) {
            String[] kv = line.split("=");
            if (kv.length > 1) {
                this.featuresToHide.addAll(Arrays.asList(kv[1].split(",")));
            }
        } else if (line.startsWith("#displayName") || line.startsWith("##displayName")) {
            String[] nameTokens = line.split("=");
            if (nameTokens.length < 2) {
                this.helper.setNameFields(null);
            } else {
                String[] fields = nameTokens[1].split(",");
                this.helper.setNameFields(fields);
            }
        }
    }

    @Override
    public Object readActualHeader(LineIterator reader) {
        if (this.header == null) {
            this.header = new FeatureFileHeader();
        }
        int nLines = 0;
        try {
            String line;
            while (reader.hasNext() && (line = reader.peek()).startsWith("#")) {
                ++nLines;
                this.readHeaderLine(line);
                reader.next();
            }
            this.header.setTrackProperties(this.trackProperties);
            return this.header;
        }
        catch (Exception e2) {
            throw new CodecLineParsingException("Error parsing header: " + e2.getMessage(), e2);
        }
    }

    @Override
    public boolean canDecode(String path) {
        String pathLowerCase = path.toLowerCase();
        if (pathLowerCase.endsWith(".gz")) {
            pathLowerCase = pathLowerCase.substring(0, pathLowerCase.length() - 3);
        }
        return pathLowerCase.endsWith(".gff") || pathLowerCase.endsWith(".gff3") || pathLowerCase.endsWith(".gvf") || pathLowerCase.endsWith(".gtf");
    }

    public BasicFeature decodeLoc(String line) {
        return this.decode(line);
    }

    @Override
    public BasicFeature decode(String line) {
        String[] colorNames;
        String phaseString;
        int end;
        int start;
        if (this.fastaSection) {
            return null;
        }
        if (line.startsWith("#")) {
            if (line.toUpperCase().startsWith("##FASTA")) {
                this.fastaSection = true;
            }
            return null;
        }
        String[] tokens = Globals.tabPattern.split(line, -1);
        int nTokens = tokens.length;
        if (nTokens < 9) {
            return null;
        }
        String chrToken = tokens[0].trim();
        String featureType = StringUtils.intern(tokens[2].trim());
        if (ignoredTypes.contains(featureType)) {
            return null;
        }
        String chromosome = this.genome == null ? StringUtils.intern(chrToken) : this.genome.getCanonicalChrName(chrToken);
        int col = 3;
        try {
            start = Integer.parseInt(tokens[col]) - 1;
            if (start < 0) {
                throw new ParserException("Start index must be 1 or larger; GFF is 1-based", -1L, line);
            }
            end = Integer.parseInt(tokens[++col]);
        }
        catch (NumberFormatException ne) {
            String msg = String.format("Column %d must contain a numeric value. %s", col + 1, ne.getMessage());
            throw new ParserException(msg, -1L, line);
        }
        Strand strand = this.convertStrand(tokens[6]);
        String attributeString = tokens[8];
        MultiMap<String, String> attributes = new MultiMap<String, String>();
        this.helper.parseAttributes(attributeString, attributes);
        String id = this.helper.getID(attributes, featureType);
        String[] parentIds = this.helper.getParentIds(attributes, attributeString);
        BasicFeature f2 = new BasicFeature(chromosome, start, end, strand);
        if (SequenceOntology.utrTypes.contains(featureType)) {
            boolean plus;
            boolean bl = plus = SequenceOntology.fivePrimeUTRTypes.contains(featureType) && strand == Strand.POSITIVE || SequenceOntology.threePrimeUTRTypes.contains(featureType) && strand == Strand.NEGATIVE;
            if (plus) {
                f2.setThickStart(end);
            } else {
                f2.setThickEnd(end);
            }
        }
        if (!(phaseString = tokens[7].trim()).equals(".")) {
            int phaseNum = Integer.parseInt(phaseString);
            f2.setReadingFrame(phaseNum);
        }
        f2.setName(this.helper.getName(attributes));
        f2.setType(featureType);
        id = id != null ? id : "igv_" + UUID.randomUUID().toString();
        f2.setIdentifier(id);
        f2.setParentIds(parentIds);
        f2.setAttributes(attributes);
        for (String colorName : colorNames = new String[]{"color", "Color", "colour", "Colour"}) {
            if (!attributes.containsKey(colorName)) continue;
            f2.setColor(ColorUtilities.stringToColor(attributes.get(colorName)));
            break;
        }
        if (this.featuresToHide.contains(featureType)) {
            if (IGV.hasInstance()) {
                FeatureDB.addFeature(f2, this.genome);
            }
            return null;
        }
        return f2;
    }

    public Object getHeader() {
        return this.header;
    }

    private Strand convertStrand(String strandString) {
        Strand strand = Strand.NONE;
        if (strandString.equals("-")) {
            strand = Strand.NEGATIVE;
        } else if (strandString.equals("+")) {
            strand = Strand.POSITIVE;
        }
        return strand;
    }

    static String getDescription(MultiMap<String, String> attributes, String type) {
        buf.setLength(0);
        buf.append(type);
        buf.append("<br>");
        attributes.printHtml(buf, 100);
        return buf.toString();
    }

    static {
        ignoredTypes.add("start_codon");
        ignoredTypes.add("stop_codon");
        ignoredTypes.add("Contig");
        ignoredTypes.add("RealContig");
        ignoredTypes.add("CDS_parts");
        nameFields = new String[]{"Name", "name", "Alias", "gene", "primary_name", "locus", "alias", "systematic_id", "ID", "transcript_id"};
        buf = new StringBuffer();
    }

    public static class GFF3Helper
    implements Helper {
        static String[] DEFAULT_NAME_FIELDS = new String[]{"Name", "Alias", "ID", "gene", "locus", "gene_name"};
        private boolean useUrlDecoding = true;
        private String[] nameFields;

        public GFF3Helper() {
            this(DEFAULT_NAME_FIELDS);
        }

        GFF3Helper(String[] nameFields) {
            if (nameFields != null) {
                this.nameFields = nameFields;
            }
        }

        @Override
        public String[] getParentIds(MultiMap<String, String> attributes, String ignored) {
            String parentIdString = attributes.get("Parent");
            if (parentIdString != null) {
                return parentIdString.split(",");
            }
            return null;
        }

        @Override
        public void parseAttributes(String description, MultiMap<String, String> kvalues) {
            List<String> kvPairs = StringUtils.breakQuotedString(description.trim(), ';');
            for (String kv : kvPairs) {
                List<String> tmp = StringUtils.breakQuotedString(kv, '=');
                int nValues = tmp.size();
                if (nValues > 0) {
                    String value;
                    String key = tmp.get(0).trim();
                    String string = value = nValues == 1 ? "" : tmp.get(1).trim();
                    if (this.useUrlDecoding) {
                        key = StringUtils.decodeURL(key);
                        value = StringUtils.decodeURL(value);
                    }
                    kvalues.put(StringUtils.intern(key), value);
                    continue;
                }
                log.info("No attributes: " + description);
            }
        }

        @Override
        public void setUrlDecoding(boolean useUrlDecoding) {
            this.useUrlDecoding = useUrlDecoding;
        }

        @Override
        public String getName(MultiMap<String, String> attributes) {
            if (attributes.size() > 0 && this.nameFields != null) {
                for (String nf : this.nameFields) {
                    if (!attributes.containsKey(nf)) continue;
                    return attributes.get(nf);
                }
            }
            return null;
        }

        @Override
        public String getID(MultiMap<String, String> attributes, String ignore) {
            return attributes.get("ID");
        }

        @Override
        public void setNameFields(String[] nameFields) {
            this.nameFields = nameFields;
        }
    }

    public static class GFF2Helper
    implements Helper {
        static String[] DEFAULT_NAME_FIELDS = new String[]{"alias", "gene", "ID", "Locus", "locus", "Name", "name", "gene_name", "primary_name", "systematic_id", "transcript_id"};
        static List<String> idFields = new ArrayList<String>(Arrays.asList(DEFAULT_NAME_FIELDS));
        static String[] possParentNames;
        private String[] nameFields;

        GFF2Helper() {
            this(DEFAULT_NAME_FIELDS);
        }

        GFF2Helper(String[] nameFields) {
            if (nameFields != null) {
                this.nameFields = nameFields;
            }
        }

        @Override
        public void setUrlDecoding(boolean b2) {
        }

        @Override
        public void parseAttributes(String description, MultiMap<String, String> kvalues) {
            List<String> kvPairs = StringUtils.breakQuotedString(description.trim(), ';');
            for (String kv : kvPairs) {
                String[] tokens = kv.split(" ");
                if (tokens.length == 1) {
                    tokens = kv.split("=");
                }
                if (tokens.length < 2) continue;
                String key = tokens[0].trim().replaceAll("\"", "");
                String value = tokens[1].trim().replaceAll("\"", "");
                kvalues.put(StringUtils.intern(key), value);
            }
        }

        @Override
        public String[] getParentIds(MultiMap<String, String> attributes, String attributeString) {
            if (attributes.size() > 0) {
                for (String possName : possParentNames) {
                    String parent;
                    if (!attributes.containsKey(possName) || (parent = attributes.get(possName).trim()).length() <= 0) continue;
                    return new String[]{parent};
                }
            }
            return null;
        }

        @Override
        public String getID(MultiMap<String, String> attributes, String type) {
            String id = attributes.get(type);
            if (id != null && id.length() > 0) {
                return id;
            }
            for (String nf : idFields) {
                String tmp;
                if (!attributes.containsKey(nf) || (tmp = attributes.get(nf).trim()).length() <= 0) continue;
                return tmp;
            }
            String tmp = this.getName(attributes);
            if (tmp != null && tmp.trim().length() > 0) {
                return tmp.trim();
            }
            return null;
        }

        @Override
        public String getName(MultiMap<String, String> attributes) {
            if (attributes.size() > 0 && this.nameFields != null) {
                for (String nf : this.nameFields) {
                    if (!attributes.containsKey(nf)) continue;
                    return attributes.get(nf);
                }
            }
            return null;
        }

        @Override
        public void setNameFields(String[] nameFields) {
            this.nameFields = nameFields;
        }

        static {
            idFields.add("transcript_id");
            possParentNames = new String[]{"transcript_id", "id", "mRNA", "systematic_id", "gene", "transcriptId", "Parent", "proteinId"};
        }
    }

    protected static interface Helper {
        public String[] getParentIds(MultiMap<String, String> var1, String var2);

        public void parseAttributes(String var1, MultiMap<String, String> var2);

        public String getID(MultiMap<String, String> var1, String var2);

        public void setUrlDecoding(boolean var1);

        public String getName(MultiMap<String, String> var1);

        public void setNameFields(String[] var1);
    }

    public static enum Version {
        GFF2,
        GFF3;

    }
}

