/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.batch;

import biz.source_code.base64Coder.Base64Coder;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URLDecoder;
import java.nio.channels.ClosedByInterruptException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.batch.CommandExecutor;
import org.broad.igv.ga4gh.OAuthUtils;
import org.broad.igv.ui.IGV;
import org.broad.igv.util.StringUtils;

public class CommandListener
implements Runnable {
    public static final String OK = "OK";
    public static int currentListenerPort = -1;
    private static Logger log = Logger.getLogger(CommandListener.class);
    private static CommandListener listener;
    private static final String CRLF = "\r\n";
    private int port = -1;
    private ServerSocket serverSocket = null;
    private Socket clientSocket = null;
    private Thread listenerThread;
    boolean halt = false;
    public static Set<String> fileParams;
    public static Set<String> indexParams;
    private static final String HTTP_RESPONSE = "HTTP/1.1 200 OK";
    private static final String HTTP_NO_RESPONSE = "HTTP/1.1 204 No Response";
    private static final String CONNECTION_CLOSE = "Connection: close";
    private static final String NO_CACHE = "Cache-Control: no-cache, no-store";
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin: *";

    public static synchronized void start(int port) {
        listener = new CommandListener(port);
        CommandListener.listener.listenerThread.start();
    }

    public static synchronized void halt() {
        if (listener != null) {
            CommandListener.listener.halt = true;
            CommandListener.listener.listenerThread.interrupt();
            listener.closeSockets();
            listener = null;
        }
    }

    private CommandListener(int port) {
        this.port = port;
        this.listenerThread = new Thread(this);
    }

    @Override
    public void run() {
        block7: {
            CommandExecutor cmdExe = new CommandExecutor();
            try {
                this.serverSocket = new ServerSocket(this.port);
                log.info("Listening on port " + this.port);
                currentListenerPort = this.port;
                while (!this.halt) {
                    this.clientSocket = this.serverSocket.accept();
                    this.processClientSession(cmdExe);
                    if (this.clientSocket == null) continue;
                    try {
                        this.clientSocket.close();
                        this.clientSocket = null;
                    }
                    catch (IOException e2) {
                        log.error("Error in client socket loop", e2);
                    }
                }
            }
            catch (BindException e3) {
                log.error(e3);
                currentListenerPort = -1;
            }
            catch (ClosedByInterruptException e4) {
                log.error(e4);
            }
            catch (IOException e5) {
                if (this.halt) break block7;
                log.error("IO Error on port socket ", e5);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processClientSession(CommandExecutor cmdExe) throws IOException {
        PrintWriter out = null;
        BufferedReader in = null;
        try {
            String inputLine;
            out = new PrintWriter(this.clientSocket.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
            while (!this.halt && (inputLine = in.readLine()) != null) {
                String cmd = inputLine;
                if (cmd.startsWith("GET")) {
                    HashMap<String, String> headers = new HashMap<String, String>();
                    String nextLine = in.readLine();
                    while (nextLine != null && nextLine.length() > 0) {
                        nextLine = in.readLine();
                        String[] tokens = Globals.colonPattern.split(nextLine, 2);
                        if (tokens.length != 2) continue;
                        headers.put(tokens[0].trim(), tokens[1].trim());
                    }
                    log.info(cmd);
                    String command = null;
                    HashMap<String, String> params = null;
                    String[] tokens = inputLine.split(" ");
                    if (tokens.length < 2) {
                        this.sendTextResponse(out, "ERROR unexpected command line: " + inputLine);
                        return;
                    }
                    String[] parts = tokens[1].split("\\?");
                    command = parts[0];
                    Map<String, String> map = params = parts.length < 2 ? new HashMap<String, String>() : this.parseParameters(parts[1]);
                    if (command.equals("/oauthCallback")) {
                        if (params.containsKey("code")) {
                            OAuthUtils.getInstance().setAuthorizationCode((String)params.get("code"));
                        } else if (params.containsKey("token")) {
                            OAuthUtils.getInstance().setAccessToken((String)params.get("token"));
                        }
                        this.sendTextResponse(out, OK);
                    } else {
                        String callback = (String)params.get("callback");
                        if (callback != null) {
                            this.sendJavascriptResponse(out, callback);
                        }
                        String result = this.processGet(command, params, cmdExe);
                        if (callback == null) {
                            if (result.equals(OK)) {
                                result = null;
                            }
                            this.sendTextResponse(out, result);
                        }
                    }
                    return;
                }
                Globals.setBatch(true);
                Globals.setSuppressMessages(true);
                String response = cmdExe.execute(inputLine);
                out.println(response);
                out.flush();
            }
        }
        catch (IOException e2) {
            log.error("Error processing client session", e2);
        }
        finally {
            Globals.setSuppressMessages(false);
            Globals.setBatch(false);
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    private void closeSockets() {
        if (this.clientSocket != null) {
            try {
                this.clientSocket.close();
                this.clientSocket = null;
            }
            catch (IOException e2) {
                log.error("Error closing clientSocket", e2);
            }
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
                this.serverSocket = null;
            }
            catch (IOException e3) {
                log.error("Error closing server socket", e3);
            }
        }
    }

    private void sendJavascriptResponse(PrintWriter out, String result) {
        this.sendHTTPResponse(out, result, "application/javascript");
    }

    private void sendTextResponse(PrintWriter out, String result) {
        this.sendHTTPResponse(out, result, "text/html");
    }

    private void sendHTTPResponse(PrintWriter out, String result, String contentType) {
        out.print(result == null ? HTTP_NO_RESPONSE : HTTP_RESPONSE);
        out.print(CRLF);
        out.print(ACCESS_CONTROL_ALLOW_ORIGIN);
        out.print(CRLF);
        if (result != null) {
            out.print("Content-Type: " + contentType);
            out.print(CRLF);
            out.print("Content-Length: " + result.length());
            out.print(CRLF);
            out.print(NO_CACHE);
            out.print(CRLF);
            out.print(CONNECTION_CLOSE);
            out.print(CRLF);
            out.print(CRLF);
            out.print(result);
            out.print(CRLF);
        }
        out.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String processGet(String command, Map<String, String> params, CommandExecutor cmdExe) throws IOException {
        String result = OK;
        Frame mainFrame = IGV.getMainFrame();
        mainFrame.toFront();
        mainFrame.setAlwaysOnTop(true);
        mainFrame.setAlwaysOnTop(false);
        String server = params.get("server");
        if (server == null || server.trim().length() < 1) {
            server = PreferenceManager.getInstance().get("IONTORRENT.SERVER");
        } else {
            PreferenceManager.getInstance().put("IONTORRENT.SERVER", server);
        }
        if (command.equals("/load")) {
            String fp;
            String file = null;
            Iterator<String> i$ = fileParams.iterator();
            while (i$.hasNext() && (file = params.get(fp = i$.next())) == null) {
            }
            String genome = params.get("genome");
            if (genome == null) {
                genome = params.get("db");
            }
            if (genome != null) {
                IGV.getInstance().loadGenomeById(genome);
            }
            if (file == null) return "ERROR Parameter \"file\" is required";
            PreferenceManager.getInstance().put("IONTORRENT.RESULTS", file);
            String mergeValue = params.get("merge");
            if (mergeValue != null) {
                mergeValue = URLDecoder.decode(mergeValue, "UTF-8");
            }
            boolean merge = mergeValue != null ? mergeValue.equalsIgnoreCase("true") : !file.endsWith(".xml") && !file.endsWith(".php") && !file.endsWith(".php3");
            String name = params.get("name");
            String format = params.get("format");
            String locus = params.get("locus");
            String index = params.get("index");
            String coverage = params.get("coverage");
            String sort = params.get("sort");
            String sortTag = params.get("sortTag");
            return cmdExe.loadFiles(file, index, coverage, name, format, locus, merge, params, sort, sortTag);
        }
        if (!command.equals("/reload") && !command.equals("/goto")) {
            if (!command.equals("/execute")) return "ERROR Unknown command: " + command;
            String param = StringUtils.decodeURL(params.get("command"));
            return cmdExe.execute(param);
        }
        String locus = params.get("locus");
        IGV.getInstance().goToLocus(locus);
        return result;
    }

    private Map<String, String> parseParameters(String parameterString) {
        String[] kvPairs;
        parameterString = parameterString.replace("&amp;", "&");
        HashMap<String, String> params = new HashMap<String, String>();
        for (String kvString : kvPairs = parameterString.split("&")) {
            String[] kv = kvString.split("=", 2);
            if (kv.length == 1) {
                params.put(kv[0], null);
                continue;
            }
            String key = StringUtils.decodeURL(kv[0]);
            boolean cmdExeWillDecode = (fileParams.contains(key) || indexParams.contains(key)) && CommandExecutor.needsDecode(kv[1]);
            String value = cmdExeWillDecode ? kv[1] : StringUtils.decodeURL(kv[1]);
            params.put(kv[0], value);
        }
        return params;
    }

    static String computeResponseKey(String input) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest digest = null;
        digest = MessageDigest.getInstance("SHA-1");
        digest.reset();
        digest.update(input.getBytes("UTF-8"));
        return new String(Base64Coder.encode(digest.digest()));
    }

    static {
        String[] fps = new String[]{"file", "bigDataURL", "sessionURL", "dataURL"};
        fileParams = new LinkedHashSet<String>(Arrays.asList(fps));
        fileParams = Collections.unmodifiableSet(fileParams);
        indexParams = new HashSet<String>(Arrays.asList("index"));
    }
}

