/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.event;

import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.lang.reflect.Array;
import java.util.EventListener;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.event.EventDispatcher;
import org.apache.batik.gvt.event.GraphicsNodeKeyEvent;
import org.apache.batik.gvt.event.GraphicsNodeKeyListener;
import org.apache.batik.gvt.event.GraphicsNodeMouseEvent;
import org.apache.batik.gvt.event.GraphicsNodeMouseListener;
import org.apache.batik.gvt.event.GraphicsNodeMouseWheelListener;

public abstract class AbstractAWTEventDispatcher
implements EventDispatcher,
MouseListener,
MouseMotionListener,
KeyListener {
    protected GraphicsNode root;
    protected AffineTransform baseTransform;
    protected EventListenerList glisteners;
    protected GraphicsNode lastHit;
    protected GraphicsNode currentKeyEventTarget;
    protected List eventQueue = new LinkedList();
    protected boolean eventDispatchEnabled = true;
    protected int eventQueueMaxSize = 10;
    static final int MAX_QUEUE_SIZE = 10;
    private int nodeIncrementEventID = 401;
    private int nodeIncrementEventCode = 9;
    private int nodeIncrementEventModifiers = 0;
    private int nodeDecrementEventID = 401;
    private int nodeDecrementEventCode = 9;
    private int nodeDecrementEventModifiers = 1;
    static /* synthetic */ Class class$org$apache$batik$gvt$event$GraphicsNodeMouseListener;
    static /* synthetic */ Class class$org$apache$batik$gvt$event$GraphicsNodeMouseWheelListener;
    static /* synthetic */ Class class$org$apache$batik$gvt$event$GraphicsNodeKeyListener;

    public void setRootNode(GraphicsNode root) {
        if (this.root != root) {
            this.eventQueue.clear();
        }
        this.root = root;
    }

    public GraphicsNode getRootNode() {
        return this.root;
    }

    public void setBaseTransform(AffineTransform t2) {
        if (!(this.baseTransform == t2 || this.baseTransform != null && this.baseTransform.equals(t2))) {
            this.eventQueue.clear();
        }
        this.baseTransform = t2;
    }

    public AffineTransform getBaseTransform() {
        return new AffineTransform(this.baseTransform);
    }

    public void mousePressed(MouseEvent evt) {
        this.dispatchEvent(evt);
    }

    public void mouseReleased(MouseEvent evt) {
        this.dispatchEvent(evt);
    }

    public void mouseEntered(MouseEvent evt) {
        this.dispatchEvent(evt);
    }

    public void mouseExited(MouseEvent evt) {
        this.dispatchEvent(evt);
    }

    public void mouseClicked(MouseEvent evt) {
        this.dispatchEvent(evt);
    }

    public void mouseMoved(MouseEvent evt) {
        this.dispatchEvent(evt);
    }

    public void mouseDragged(MouseEvent evt) {
        this.dispatchEvent(evt);
    }

    public void keyPressed(KeyEvent evt) {
        this.dispatchEvent(evt);
    }

    public void keyReleased(KeyEvent evt) {
        this.dispatchEvent(evt);
    }

    public void keyTyped(KeyEvent evt) {
        this.dispatchEvent(evt);
    }

    public void addGraphicsNodeMouseListener(GraphicsNodeMouseListener l2) {
        if (this.glisteners == null) {
            this.glisteners = new EventListenerList();
        }
        this.glisteners.add(class$org$apache$batik$gvt$event$GraphicsNodeMouseListener == null ? (class$org$apache$batik$gvt$event$GraphicsNodeMouseListener = AbstractAWTEventDispatcher.class$("org.apache.batik.gvt.event.GraphicsNodeMouseListener")) : class$org$apache$batik$gvt$event$GraphicsNodeMouseListener, l2);
    }

    public void removeGraphicsNodeMouseListener(GraphicsNodeMouseListener l2) {
        if (this.glisteners != null) {
            this.glisteners.remove(class$org$apache$batik$gvt$event$GraphicsNodeMouseListener == null ? (class$org$apache$batik$gvt$event$GraphicsNodeMouseListener = AbstractAWTEventDispatcher.class$("org.apache.batik.gvt.event.GraphicsNodeMouseListener")) : class$org$apache$batik$gvt$event$GraphicsNodeMouseListener, l2);
        }
    }

    public void addGraphicsNodeMouseWheelListener(GraphicsNodeMouseWheelListener l2) {
        if (this.glisteners == null) {
            this.glisteners = new EventListenerList();
        }
        this.glisteners.add(class$org$apache$batik$gvt$event$GraphicsNodeMouseWheelListener == null ? (class$org$apache$batik$gvt$event$GraphicsNodeMouseWheelListener = AbstractAWTEventDispatcher.class$("org.apache.batik.gvt.event.GraphicsNodeMouseWheelListener")) : class$org$apache$batik$gvt$event$GraphicsNodeMouseWheelListener, l2);
    }

    public void removeGraphicsNodeMouseWheelListener(GraphicsNodeMouseWheelListener l2) {
        if (this.glisteners != null) {
            this.glisteners.remove(class$org$apache$batik$gvt$event$GraphicsNodeMouseWheelListener == null ? (class$org$apache$batik$gvt$event$GraphicsNodeMouseWheelListener = AbstractAWTEventDispatcher.class$("org.apache.batik.gvt.event.GraphicsNodeMouseWheelListener")) : class$org$apache$batik$gvt$event$GraphicsNodeMouseWheelListener, l2);
        }
    }

    public void addGraphicsNodeKeyListener(GraphicsNodeKeyListener l2) {
        if (this.glisteners == null) {
            this.glisteners = new EventListenerList();
        }
        this.glisteners.add(class$org$apache$batik$gvt$event$GraphicsNodeKeyListener == null ? (class$org$apache$batik$gvt$event$GraphicsNodeKeyListener = AbstractAWTEventDispatcher.class$("org.apache.batik.gvt.event.GraphicsNodeKeyListener")) : class$org$apache$batik$gvt$event$GraphicsNodeKeyListener, l2);
    }

    public void removeGraphicsNodeKeyListener(GraphicsNodeKeyListener l2) {
        if (this.glisteners != null) {
            this.glisteners.remove(class$org$apache$batik$gvt$event$GraphicsNodeKeyListener == null ? (class$org$apache$batik$gvt$event$GraphicsNodeKeyListener = AbstractAWTEventDispatcher.class$("org.apache.batik.gvt.event.GraphicsNodeKeyListener")) : class$org$apache$batik$gvt$event$GraphicsNodeKeyListener, l2);
        }
    }

    public EventListener[] getListeners(Class listenerType) {
        Object array = Array.newInstance(listenerType, this.glisteners.getListenerCount(listenerType));
        Object[] pairElements = this.glisteners.getListenerList();
        int i2 = 0;
        int j2 = 0;
        while (i2 < pairElements.length - 1) {
            if (pairElements[i2].equals(listenerType)) {
                Array.set(array, j2, pairElements[i2 + 1]);
                ++j2;
            }
            i2 += 2;
        }
        return (EventListener[])array;
    }

    public void setEventDispatchEnabled(boolean b2) {
        this.eventDispatchEnabled = b2;
        if (this.eventDispatchEnabled) {
            while (this.eventQueue.size() > 0) {
                EventObject evt = (EventObject)this.eventQueue.remove(0);
                this.dispatchEvent(evt);
            }
        }
    }

    public void setEventQueueMaxSize(int n2) {
        this.eventQueueMaxSize = n2;
        if (n2 == 0) {
            this.eventQueue.clear();
        }
        while (this.eventQueue.size() > this.eventQueueMaxSize) {
            this.eventQueue.remove(0);
        }
    }

    public void dispatchEvent(EventObject evt) {
        if (this.root == null) {
            return;
        }
        if (!this.eventDispatchEnabled) {
            if (this.eventQueueMaxSize > 0) {
                this.eventQueue.add(evt);
                while (this.eventQueue.size() > this.eventQueueMaxSize) {
                    this.eventQueue.remove(0);
                }
            }
            return;
        }
        if (evt instanceof MouseEvent) {
            this.dispatchMouseEvent((MouseEvent)evt);
        } else if (evt instanceof KeyEvent) {
            InputEvent e2 = (InputEvent)evt;
            if (this.isNodeIncrementEvent(e2)) {
                this.incrementKeyTarget();
            } else if (this.isNodeDecrementEvent(e2)) {
                this.decrementKeyTarget();
            } else {
                this.dispatchKeyEvent((KeyEvent)evt);
            }
        }
    }

    protected int getCurrentLockState() {
        Toolkit t2 = Toolkit.getDefaultToolkit();
        int lockState = 0;
        try {
            if (t2.getLockingKeyState(262)) {
                ++lockState;
            }
        }
        catch (UnsupportedOperationException ex) {
            // empty catch block
        }
        lockState <<= 1;
        try {
            if (t2.getLockingKeyState(145)) {
                ++lockState;
            }
        }
        catch (UnsupportedOperationException ex) {
            // empty catch block
        }
        lockState <<= 1;
        try {
            if (t2.getLockingKeyState(144)) {
                ++lockState;
            }
        }
        catch (UnsupportedOperationException ex) {
            // empty catch block
        }
        lockState <<= 1;
        try {
            if (t2.getLockingKeyState(20)) {
                ++lockState;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return lockState;
    }

    protected abstract void dispatchKeyEvent(KeyEvent var1);

    protected abstract int getModifiers(InputEvent var1);

    protected abstract int getButton(MouseEvent var1);

    protected void dispatchMouseEvent(MouseEvent evt) {
        GraphicsNodeMouseEvent gvtevt;
        Point screenPos;
        Point2D.Float p2 = new Point2D.Float(evt.getX(), evt.getY());
        Point2D gnp = p2;
        if (this.baseTransform != null) {
            gnp = this.baseTransform.transform(p2, null);
        }
        GraphicsNode node = this.root.nodeHitAt(gnp);
        if (!evt.getComponent().isShowing()) {
            screenPos = new Point(0, 0);
        } else {
            screenPos = evt.getComponent().getLocationOnScreen();
            screenPos.x += evt.getX();
            screenPos.y += evt.getY();
        }
        int currentLockState = this.getCurrentLockState();
        if (this.lastHit != node) {
            if (this.lastHit != null) {
                gvtevt = new GraphicsNodeMouseEvent(this.lastHit, 505, evt.getWhen(), this.getModifiers(evt), currentLockState, this.getButton(evt), (float)gnp.getX(), (float)gnp.getY(), (int)Math.floor(((Point2D)p2).getX()), (int)Math.floor(((Point2D)p2).getY()), screenPos.x, screenPos.y, evt.getClickCount(), node);
                this.processMouseEvent(gvtevt);
            }
            if (node != null) {
                gvtevt = new GraphicsNodeMouseEvent(node, 504, evt.getWhen(), this.getModifiers(evt), currentLockState, this.getButton(evt), (float)gnp.getX(), (float)gnp.getY(), (int)Math.floor(((Point2D)p2).getX()), (int)Math.floor(((Point2D)p2).getY()), screenPos.x, screenPos.y, evt.getClickCount(), this.lastHit);
                this.processMouseEvent(gvtevt);
            }
        }
        if (node != null) {
            gvtevt = new GraphicsNodeMouseEvent(node, evt.getID(), evt.getWhen(), this.getModifiers(evt), currentLockState, this.getButton(evt), (float)gnp.getX(), (float)gnp.getY(), (int)Math.floor(((Point2D)p2).getX()), (int)Math.floor(((Point2D)p2).getY()), screenPos.x, screenPos.y, evt.getClickCount(), null);
            this.processMouseEvent(gvtevt);
        } else {
            gvtevt = new GraphicsNodeMouseEvent(this.root, evt.getID(), evt.getWhen(), this.getModifiers(evt), currentLockState, this.getButton(evt), (float)gnp.getX(), (float)gnp.getY(), (int)Math.floor(((Point2D)p2).getX()), (int)Math.floor(((Point2D)p2).getY()), screenPos.x, screenPos.y, evt.getClickCount(), null);
            this.processMouseEvent(gvtevt);
        }
        this.lastHit = node;
    }

    protected void processMouseEvent(GraphicsNodeMouseEvent evt) {
        if (this.glisteners != null) {
            GraphicsNodeMouseListener[] listeners = (GraphicsNodeMouseListener[])this.getListeners(class$org$apache$batik$gvt$event$GraphicsNodeMouseListener == null ? (class$org$apache$batik$gvt$event$GraphicsNodeMouseListener = AbstractAWTEventDispatcher.class$("org.apache.batik.gvt.event.GraphicsNodeMouseListener")) : class$org$apache$batik$gvt$event$GraphicsNodeMouseListener);
            switch (evt.getID()) {
                case 503: {
                    int i2 = 0;
                    while (i2 < listeners.length) {
                        listeners[i2].mouseMoved(evt);
                        ++i2;
                    }
                    break;
                }
                case 506: {
                    int i3 = 0;
                    while (i3 < listeners.length) {
                        listeners[i3].mouseDragged(evt);
                        ++i3;
                    }
                    break;
                }
                case 504: {
                    int i4 = 0;
                    while (i4 < listeners.length) {
                        listeners[i4].mouseEntered(evt);
                        ++i4;
                    }
                    break;
                }
                case 505: {
                    int i5 = 0;
                    while (i5 < listeners.length) {
                        listeners[i5].mouseExited(evt);
                        ++i5;
                    }
                    break;
                }
                case 500: {
                    int i6 = 0;
                    while (i6 < listeners.length) {
                        listeners[i6].mouseClicked(evt);
                        ++i6;
                    }
                    break;
                }
                case 501: {
                    int i7 = 0;
                    while (i7 < listeners.length) {
                        listeners[i7].mousePressed(evt);
                        ++i7;
                    }
                    break;
                }
                case 502: {
                    int i8 = 0;
                    while (i8 < listeners.length) {
                        listeners[i8].mouseReleased(evt);
                        ++i8;
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown Mouse Event type: " + evt.getID());
                }
            }
        }
    }

    public void processKeyEvent(GraphicsNodeKeyEvent evt) {
        if (this.glisteners != null) {
            GraphicsNodeKeyListener[] listeners = (GraphicsNodeKeyListener[])this.getListeners(class$org$apache$batik$gvt$event$GraphicsNodeKeyListener == null ? (class$org$apache$batik$gvt$event$GraphicsNodeKeyListener = AbstractAWTEventDispatcher.class$("org.apache.batik.gvt.event.GraphicsNodeKeyListener")) : class$org$apache$batik$gvt$event$GraphicsNodeKeyListener);
            switch (evt.getID()) {
                case 401: {
                    int i2 = 0;
                    while (i2 < listeners.length) {
                        listeners[i2].keyPressed(evt);
                        ++i2;
                    }
                    break;
                }
                case 402: {
                    int i3 = 0;
                    while (i3 < listeners.length) {
                        listeners[i3].keyReleased(evt);
                        ++i3;
                    }
                    break;
                }
                case 400: {
                    int i4 = 0;
                    while (i4 < listeners.length) {
                        listeners[i4].keyTyped(evt);
                        ++i4;
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown Key Event type: " + evt.getID());
                }
            }
        }
        evt.consume();
    }

    private void incrementKeyTarget() {
        throw new UnsupportedOperationException("Increment not implemented.");
    }

    private void decrementKeyTarget() {
        throw new UnsupportedOperationException("Decrement not implemented.");
    }

    public void setNodeIncrementEvent(InputEvent e2) {
        this.nodeIncrementEventID = e2.getID();
        if (e2 instanceof KeyEvent) {
            this.nodeIncrementEventCode = ((KeyEvent)e2).getKeyCode();
        }
        this.nodeIncrementEventModifiers = e2.getModifiers();
    }

    public void setNodeDecrementEvent(InputEvent e2) {
        this.nodeDecrementEventID = e2.getID();
        if (e2 instanceof KeyEvent) {
            this.nodeDecrementEventCode = ((KeyEvent)e2).getKeyCode();
        }
        this.nodeDecrementEventModifiers = e2.getModifiers();
    }

    protected boolean isNodeIncrementEvent(InputEvent e2) {
        if (e2.getID() != this.nodeIncrementEventID) {
            return false;
        }
        if (e2 instanceof KeyEvent && ((KeyEvent)e2).getKeyCode() != this.nodeIncrementEventCode) {
            return false;
        }
        return (e2.getModifiers() & this.nodeIncrementEventModifiers) != 0;
    }

    protected boolean isNodeDecrementEvent(InputEvent e2) {
        if (e2.getID() != this.nodeDecrementEventID) {
            return false;
        }
        if (e2 instanceof KeyEvent && ((KeyEvent)e2).getKeyCode() != this.nodeDecrementEventCode) {
            return false;
        }
        return (e2.getModifiers() & this.nodeDecrementEventModifiers) != 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

