/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.List;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import sun.swing.CachedPainter;

public class MetalUtils {
    static void drawFlush3DBorder(Graphics g2, int x2, int y, int w2, int h2) {
        g2.translate(x2, y);
        g2.setColor(MetalLookAndFeel.getControlDarkShadow());
        g2.drawRect(0, 0, w2 - 2, h2 - 2);
        g2.setColor(MetalLookAndFeel.getControlHighlight());
        g2.drawRect(1, 1, w2 - 2, h2 - 2);
        g2.setColor(MetalLookAndFeel.getControl());
        g2.drawLine(0, h2 - 1, 1, h2 - 2);
        g2.drawLine(w2 - 1, 0, w2 - 2, 1);
        g2.translate(-x2, -y);
    }

    static void drawPressed3DBorder(Graphics g2, int x2, int y, int w2, int h2) {
        g2.translate(x2, y);
        MetalUtils.drawFlush3DBorder(g2, 0, 0, w2, h2);
        g2.setColor(MetalLookAndFeel.getControlShadow());
        g2.drawLine(1, 1, 1, h2 - 2);
        g2.drawLine(1, 1, w2 - 2, 1);
        g2.translate(-x2, -y);
    }

    static void drawActiveButtonBorder(Graphics g2, int x2, int y, int w2, int h2) {
        MetalUtils.drawFlush3DBorder(g2, x2, y, w2, h2);
        g2.setColor(MetalLookAndFeel.getPrimaryControl());
        g2.drawLine(x2 + 1, y + 1, x2 + 1, h2 - 3);
        g2.drawLine(x2 + 1, y + 1, w2 - 3, x2 + 1);
        g2.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
        g2.drawLine(x2 + 2, h2 - 2, w2 - 2, h2 - 2);
        g2.drawLine(w2 - 2, y + 2, w2 - 2, h2 - 2);
    }

    static boolean drawGradient(Component c2, Graphics g2, String key, int x2, int y, int w2, int h2, boolean vertical) {
        List gradient = (List)UIManager.get(key);
        if (gradient == null || !(g2 instanceof Graphics2D)) {
            return false;
        }
        if (w2 <= 0 || h2 <= 0) {
            return true;
        }
        GradientPainter.INSTANCE.paint(c2, (Graphics2D)g2, gradient, x2, y, w2, h2, vertical);
        return true;
    }

    private static class GradientPainter
    extends CachedPainter {
        public static final GradientPainter INSTANCE = new GradientPainter(8);
        private static final int IMAGE_SIZE = 64;
        private int w;
        private int h;

        GradientPainter(int count) {
            super(count);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Component c2, Graphics2D g2, List gradient, int x2, int y, int w2, int h2, boolean isVertical) {
            int imageHeight;
            int imageWidth;
            if (isVertical) {
                imageWidth = 64;
                imageHeight = h2;
            } else {
                imageWidth = w2;
                imageHeight = 64;
            }
            Object object = c2.getTreeLock();
            synchronized (object) {
                this.w = w2;
                this.h = h2;
                this.paint(c2, (Graphics)g2, x2, y, imageWidth, imageHeight, gradient, isVertical);
            }
        }

        protected void paintToImage(Component c2, Image image, Graphics g2, int w2, int h2, Object[] args) {
            Graphics2D g22 = (Graphics2D)g2;
            List gradient = (List)args[0];
            boolean isVertical = (Boolean)args[1];
            if (isVertical) {
                this.drawVerticalGradient(g22, ((Number)gradient.get(0)).floatValue(), ((Number)gradient.get(1)).floatValue(), (Color)gradient.get(2), (Color)gradient.get(3), (Color)gradient.get(4), w2, h2);
            } else {
                this.drawHorizontalGradient(g22, ((Number)gradient.get(0)).floatValue(), ((Number)gradient.get(1)).floatValue(), (Color)gradient.get(2), (Color)gradient.get(3), (Color)gradient.get(4), w2, h2);
            }
        }

        protected void paintImage(Component c2, Graphics g2, int x2, int y, int imageW, int imageH, Image image, Object[] args) {
            boolean isVertical = (Boolean)args[1];
            g2.translate(x2, y);
            if (isVertical) {
                for (int counter = 0; counter < this.w; counter += 64) {
                    int tileSize = Math.min(64, this.w - counter);
                    g2.drawImage(image, counter, 0, counter + tileSize, this.h, 0, 0, tileSize, this.h, null);
                }
            } else {
                for (int counter = 0; counter < this.h; counter += 64) {
                    int tileSize = Math.min(64, this.h - counter);
                    g2.drawImage(image, 0, counter, this.w, counter + tileSize, 0, 0, this.w, tileSize, null);
                }
            }
            g2.translate(-x2, -y);
        }

        private void drawVerticalGradient(Graphics2D g2, float ratio1, float ratio2, Color c1, Color c2, Color c3, int w2, int h2) {
            int mid = (int)(ratio1 * (float)h2);
            int mid2 = (int)(ratio2 * (float)h2);
            if (mid > 0) {
                g2.setPaint(this.getGradient(0.0f, 0.0f, c1, 0.0f, mid, c2));
                g2.fillRect(0, 0, w2, mid);
            }
            if (mid2 > 0) {
                g2.setColor(c2);
                g2.fillRect(0, mid, w2, mid2);
            }
            if (mid > 0) {
                g2.setPaint(this.getGradient(0.0f, (float)mid + (float)mid2, c2, 0.0f, (float)mid * 2.0f + (float)mid2, c1));
                g2.fillRect(0, mid + mid2, w2, mid);
            }
            if (h2 - mid * 2 - mid2 > 0) {
                g2.setPaint(this.getGradient(0.0f, (float)mid * 2.0f + (float)mid2, c1, 0.0f, h2, c3));
                g2.fillRect(0, mid * 2 + mid2, w2, h2 - mid * 2 - mid2);
            }
        }

        private void drawHorizontalGradient(Graphics2D g2, float ratio1, float ratio2, Color c1, Color c2, Color c3, int w2, int h2) {
            int mid = (int)(ratio1 * (float)w2);
            int mid2 = (int)(ratio2 * (float)w2);
            if (mid > 0) {
                g2.setPaint(this.getGradient(0.0f, 0.0f, c1, mid, 0.0f, c2));
                g2.fillRect(0, 0, mid, h2);
            }
            if (mid2 > 0) {
                g2.setColor(c2);
                g2.fillRect(mid, 0, mid2, h2);
            }
            if (mid > 0) {
                g2.setPaint(this.getGradient((float)mid + (float)mid2, 0.0f, c2, (float)mid * 2.0f + (float)mid2, 0.0f, c1));
                g2.fillRect(mid + mid2, 0, mid, h2);
            }
            if (w2 - mid * 2 - mid2 > 0) {
                g2.setPaint(this.getGradient((float)mid * 2.0f + (float)mid2, 0.0f, c1, w2, 0.0f, c3));
                g2.fillRect(mid * 2 + mid2, 0, w2 - mid * 2 - mid2, h2);
            }
        }

        private GradientPaint getGradient(float x1, float y1, Color c1, float x2, float y2, Color c2) {
            return new GradientPaint(x1, y1, c1, x2, y2, c2, true);
        }
    }
}

