/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import org.broad.igv.feature.genome.Genome;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.FlowSignalContext;
import org.broad.igv.sam.FlowSignalSubContext;

public class AlignmentBlockImpl
implements AlignmentBlock {
    private String chr;
    private int start;
    private byte[] bases;
    private int length = -1;
    public byte[] qualities;
    private boolean softClipped = false;
    private FlowSignalContext fContext = null;
    Alignment alignment;
    int offset;
    int end;

    public AlignmentBlockImpl(String chr, int start, byte[] bases, byte[] qualities) {
        this.chr = chr;
        this.start = start;
        this.bases = bases;
        this.length = bases.length;
        this.qualities = qualities;
    }

    protected AlignmentBlockImpl(String chr, int start, byte[] bases, byte[] qualities, FlowSignalContext fContext) {
        this(chr, start, bases, qualities);
        if (fContext != null && fContext.getNrSignals() == bases.length) {
            this.fContext = fContext;
        }
    }

    @Override
    public boolean contains(int position) {
        int offset = position - this.start;
        return offset >= 0 && offset < this.getLength();
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public byte getBase(int offset) {
        return this.bases != null && offset < this.bases.length ? this.bases[offset] : (byte)0;
    }

    @Override
    public byte[] getBases() {
        return this.bases;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public byte getQuality(int offset) {
        return this.qualities == null || offset >= this.qualities.length ? (byte)126 : this.qualities[offset];
    }

    @Override
    public byte[] getQualities() {
        return this.qualities;
    }

    @Override
    public int getEnd() {
        return this.start + this.getLength();
    }

    @Override
    public boolean isSoftClipped() {
        return this.softClipped;
    }

    @Override
    public void reduce(Genome genome) {
    }

    public void setSoftClipped(boolean softClipped) {
        this.softClipped = softClipped;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[block ");
        sb.append(this.isSoftClipped() ? "softClipped " : " ");
        sb.append(this.getStart());
        sb.append("-");
        sb.append(this.getEnd());
        sb.append(" ");
        for (int i2 = 0; i2 < this.bases.length; ++i2) {
            sb.append((char)this.bases[i2]);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean hasBases() {
        return this.bases != null;
    }

    @Override
    public FlowSignalSubContext getFlowSignalSubContext(int offset) {
        return this.fContext == null ? null : new FlowSignalSubContext(this.fContext.getSignalForOffset(offset), this.fContext.getBasesForOffset(offset), this.fContext.getFlowOrderIndexForOffset(offset));
    }

    @Override
    public boolean hasFlowSignals() {
        return null != this.fContext;
    }
}

