/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.linear.ArrayRealVector;
import org.apache.commons.math.linear.DecompositionSolver;
import org.apache.commons.math.linear.EigenDecomposition;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealVector;
import org.apache.commons.math.linear.SingularMatrixException;
import org.apache.commons.math.linear.TriDiagonalTransformer;
import org.apache.commons.math.util.FastMath;

public class EigenDecompositionImpl
implements EigenDecomposition {
    private byte maxIter = (byte)30;
    private double[] main;
    private double[] secondary;
    private TriDiagonalTransformer transformer;
    private double[] realEigenvalues;
    private double[] imagEigenvalues;
    private ArrayRealVector[] eigenvectors;
    private RealMatrix cachedV;
    private RealMatrix cachedD;
    private RealMatrix cachedVt;

    public EigenDecompositionImpl(RealMatrix matrix, double splitTolerance) throws InvalidMatrixException {
        if (!this.isSymmetric(matrix)) {
            throw new InvalidMatrixException(LocalizedFormats.ASSYMETRIC_EIGEN_NOT_SUPPORTED, new Object[0]);
        }
        this.transformToTridiagonal(matrix);
        this.findEigenVectors(this.transformer.getQ().getData());
    }

    public EigenDecompositionImpl(double[] main, double[] secondary, double splitTolerance) throws InvalidMatrixException {
        this.main = (double[])main.clone();
        this.secondary = (double[])secondary.clone();
        this.transformer = null;
        int size = main.length;
        double[][] z = new double[size][size];
        for (int i2 = 0; i2 < size; ++i2) {
            z[i2][i2] = 1.0;
        }
        this.findEigenVectors(z);
    }

    private boolean isSymmetric(RealMatrix matrix) {
        int rows = matrix.getRowDimension();
        int columns = matrix.getColumnDimension();
        double eps = (double)(10 * rows * columns) * (double)1.110223E-16f;
        for (int i2 = 0; i2 < rows; ++i2) {
            for (int j2 = i2 + 1; j2 < columns; ++j2) {
                double mji;
                double mij = matrix.getEntry(i2, j2);
                if (!(FastMath.abs(mij - (mji = matrix.getEntry(j2, i2))) > FastMath.max(FastMath.abs(mij), FastMath.abs(mji)) * eps)) continue;
                return false;
            }
        }
        return true;
    }

    public RealMatrix getV() throws InvalidMatrixException {
        if (this.cachedV == null) {
            int m2 = this.eigenvectors.length;
            this.cachedV = MatrixUtils.createRealMatrix(m2, m2);
            for (int k2 = 0; k2 < m2; ++k2) {
                this.cachedV.setColumnVector(k2, this.eigenvectors[k2]);
            }
        }
        return this.cachedV;
    }

    public RealMatrix getD() throws InvalidMatrixException {
        if (this.cachedD == null) {
            this.cachedD = MatrixUtils.createRealDiagonalMatrix(this.realEigenvalues);
        }
        return this.cachedD;
    }

    public RealMatrix getVT() throws InvalidMatrixException {
        if (this.cachedVt == null) {
            int m2 = this.eigenvectors.length;
            this.cachedVt = MatrixUtils.createRealMatrix(m2, m2);
            for (int k2 = 0; k2 < m2; ++k2) {
                this.cachedVt.setRowVector(k2, this.eigenvectors[k2]);
            }
        }
        return this.cachedVt;
    }

    public double[] getRealEigenvalues() throws InvalidMatrixException {
        return (double[])this.realEigenvalues.clone();
    }

    public double getRealEigenvalue(int i2) throws InvalidMatrixException, ArrayIndexOutOfBoundsException {
        return this.realEigenvalues[i2];
    }

    public double[] getImagEigenvalues() throws InvalidMatrixException {
        return (double[])this.imagEigenvalues.clone();
    }

    public double getImagEigenvalue(int i2) throws InvalidMatrixException, ArrayIndexOutOfBoundsException {
        return this.imagEigenvalues[i2];
    }

    public RealVector getEigenvector(int i2) throws InvalidMatrixException, ArrayIndexOutOfBoundsException {
        return this.eigenvectors[i2].copy();
    }

    public double getDeterminant() {
        double determinant = 1.0;
        for (double lambda : this.realEigenvalues) {
            determinant *= lambda;
        }
        return determinant;
    }

    public DecompositionSolver getSolver() {
        return new Solver(this.realEigenvalues, this.imagEigenvalues, this.eigenvectors);
    }

    private void transformToTridiagonal(RealMatrix matrix) {
        this.transformer = new TriDiagonalTransformer(matrix);
        this.main = this.transformer.getMainDiagonalRef();
        this.secondary = this.transformer.getSecondaryDiagonalRef();
    }

    private void findEigenVectors(double[][] householderMatrix) {
        int i2;
        double[][] z = (double[][])householderMatrix.clone();
        int n2 = this.main.length;
        this.realEigenvalues = new double[n2];
        this.imagEigenvalues = new double[n2];
        double[] e2 = new double[n2];
        for (int i3 = 0; i3 < n2 - 1; ++i3) {
            this.realEigenvalues[i3] = this.main[i3];
            e2[i3] = this.secondary[i3];
        }
        this.realEigenvalues[n2 - 1] = this.main[n2 - 1];
        e2[n2 - 1] = 0.0;
        double maxAbsoluteValue = 0.0;
        for (i2 = 0; i2 < n2; ++i2) {
            if (FastMath.abs(this.realEigenvalues[i2]) > maxAbsoluteValue) {
                maxAbsoluteValue = FastMath.abs(this.realEigenvalues[i2]);
            }
            if (!(FastMath.abs(e2[i2]) > maxAbsoluteValue)) continue;
            maxAbsoluteValue = FastMath.abs(e2[i2]);
        }
        if (maxAbsoluteValue != 0.0) {
            for (i2 = 0; i2 < n2; ++i2) {
                if (FastMath.abs(this.realEigenvalues[i2]) <= (double)1.110223E-16f * maxAbsoluteValue) {
                    this.realEigenvalues[i2] = 0.0;
                }
                if (!(FastMath.abs(e2[i2]) <= (double)1.110223E-16f * maxAbsoluteValue)) continue;
                e2[i2] = 0.0;
            }
        }
        for (int j2 = 0; j2 < n2; ++j2) {
            int m2;
            int its = 0;
            do {
                int i4;
                for (m2 = j2; m2 < n2 - 1; ++m2) {
                    double delta = FastMath.abs(this.realEigenvalues[m2]) + FastMath.abs(this.realEigenvalues[m2 + 1]);
                    if (FastMath.abs(e2[m2]) + delta == delta) break;
                }
                if (m2 == j2) continue;
                if (its == this.maxIter) {
                    throw new InvalidMatrixException(new MaxIterationsExceededException(this.maxIter));
                }
                ++its;
                double q2 = (this.realEigenvalues[j2 + 1] - this.realEigenvalues[j2]) / (2.0 * e2[j2]);
                double t2 = FastMath.sqrt(1.0 + q2 * q2);
                q2 = q2 < 0.0 ? this.realEigenvalues[m2] - this.realEigenvalues[j2] + e2[j2] / (q2 - t2) : this.realEigenvalues[m2] - this.realEigenvalues[j2] + e2[j2] / (q2 + t2);
                double u2 = 0.0;
                double s2 = 1.0;
                double c2 = 1.0;
                for (i4 = m2 - 1; i4 >= j2; --i4) {
                    double p2 = s2 * e2[i4];
                    double h2 = c2 * e2[i4];
                    if (FastMath.abs(p2) >= FastMath.abs(q2)) {
                        c2 = q2 / p2;
                        t2 = FastMath.sqrt(c2 * c2 + 1.0);
                        e2[i4 + 1] = p2 * t2;
                        s2 = 1.0 / t2;
                        c2 *= s2;
                    } else {
                        s2 = p2 / q2;
                        t2 = FastMath.sqrt(s2 * s2 + 1.0);
                        e2[i4 + 1] = q2 * t2;
                        c2 = 1.0 / t2;
                        s2 *= c2;
                    }
                    if (e2[i4 + 1] == 0.0) {
                        int n3 = i4 + 1;
                        this.realEigenvalues[n3] = this.realEigenvalues[n3] - u2;
                        e2[m2] = 0.0;
                        break;
                    }
                    q2 = this.realEigenvalues[i4 + 1] - u2;
                    t2 = (this.realEigenvalues[i4] - q2) * s2 + 2.0 * c2 * h2;
                    u2 = s2 * t2;
                    this.realEigenvalues[i4 + 1] = q2 + u2;
                    q2 = c2 * t2 - h2;
                    for (int ia = 0; ia < n2; ++ia) {
                        p2 = z[ia][i4 + 1];
                        z[ia][i4 + 1] = s2 * z[ia][i4] + c2 * p2;
                        z[ia][i4] = c2 * z[ia][i4] - s2 * p2;
                    }
                }
                if (t2 == 0.0 && i4 >= j2) continue;
                int n4 = j2;
                this.realEigenvalues[n4] = this.realEigenvalues[n4] - u2;
                e2[j2] = q2;
                e2[m2] = 0.0;
            } while (m2 != j2);
        }
        for (i2 = 0; i2 < n2; ++i2) {
            int j3;
            int k2 = i2;
            double p3 = this.realEigenvalues[i2];
            for (j3 = i2 + 1; j3 < n2; ++j3) {
                if (!(this.realEigenvalues[j3] > p3)) continue;
                k2 = j3;
                p3 = this.realEigenvalues[j3];
            }
            if (k2 == i2) continue;
            this.realEigenvalues[k2] = this.realEigenvalues[i2];
            this.realEigenvalues[i2] = p3;
            for (j3 = 0; j3 < n2; ++j3) {
                p3 = z[j3][i2];
                z[j3][i2] = z[j3][k2];
                z[j3][k2] = p3;
            }
        }
        maxAbsoluteValue = 0.0;
        for (i2 = 0; i2 < n2; ++i2) {
            if (!(FastMath.abs(this.realEigenvalues[i2]) > maxAbsoluteValue)) continue;
            maxAbsoluteValue = FastMath.abs(this.realEigenvalues[i2]);
        }
        if (maxAbsoluteValue != 0.0) {
            for (i2 = 0; i2 < n2; ++i2) {
                if (!(FastMath.abs(this.realEigenvalues[i2]) < (double)1.110223E-16f * maxAbsoluteValue)) continue;
                this.realEigenvalues[i2] = 0.0;
            }
        }
        this.eigenvectors = new ArrayRealVector[n2];
        double[] tmp = new double[n2];
        for (int i5 = 0; i5 < n2; ++i5) {
            for (int j4 = 0; j4 < n2; ++j4) {
                tmp[j4] = z[j4][i5];
            }
            this.eigenvectors[i5] = new ArrayRealVector(tmp);
        }
    }

    private static class Solver
    implements DecompositionSolver {
        private double[] realEigenvalues;
        private double[] imagEigenvalues;
        private final ArrayRealVector[] eigenvectors;

        private Solver(double[] realEigenvalues, double[] imagEigenvalues, ArrayRealVector[] eigenvectors) {
            this.realEigenvalues = realEigenvalues;
            this.imagEigenvalues = imagEigenvalues;
            this.eigenvectors = eigenvectors;
        }

        public double[] solve(double[] b2) throws IllegalArgumentException, InvalidMatrixException {
            if (!this.isNonSingular()) {
                throw new SingularMatrixException();
            }
            int m2 = this.realEigenvalues.length;
            if (b2.length != m2) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, b2.length, m2);
            }
            double[] bp = new double[m2];
            for (int i2 = 0; i2 < m2; ++i2) {
                ArrayRealVector v2 = this.eigenvectors[i2];
                double[] vData = v2.getDataRef();
                double s2 = v2.dotProduct(b2) / this.realEigenvalues[i2];
                for (int j2 = 0; j2 < m2; ++j2) {
                    int n2 = j2;
                    bp[n2] = bp[n2] + s2 * vData[j2];
                }
            }
            return bp;
        }

        public RealVector solve(RealVector b2) throws IllegalArgumentException, InvalidMatrixException {
            if (!this.isNonSingular()) {
                throw new SingularMatrixException();
            }
            int m2 = this.realEigenvalues.length;
            if (b2.getDimension() != m2) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, b2.getDimension(), m2);
            }
            double[] bp = new double[m2];
            for (int i2 = 0; i2 < m2; ++i2) {
                ArrayRealVector v2 = this.eigenvectors[i2];
                double[] vData = v2.getDataRef();
                double s2 = v2.dotProduct(b2) / this.realEigenvalues[i2];
                for (int j2 = 0; j2 < m2; ++j2) {
                    int n2 = j2;
                    bp[n2] = bp[n2] + s2 * vData[j2];
                }
            }
            return new ArrayRealVector(bp, false);
        }

        public RealMatrix solve(RealMatrix b2) throws IllegalArgumentException, InvalidMatrixException {
            if (!this.isNonSingular()) {
                throw new SingularMatrixException();
            }
            int m2 = this.realEigenvalues.length;
            if (b2.getRowDimension() != m2) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, b2.getRowDimension(), b2.getColumnDimension(), m2, "n");
            }
            int nColB = b2.getColumnDimension();
            double[][] bp = new double[m2][nColB];
            for (int k2 = 0; k2 < nColB; ++k2) {
                for (int i2 = 0; i2 < m2; ++i2) {
                    int j2;
                    ArrayRealVector v2 = this.eigenvectors[i2];
                    double[] vData = v2.getDataRef();
                    double s2 = 0.0;
                    for (j2 = 0; j2 < m2; ++j2) {
                        s2 += v2.getEntry(j2) * b2.getEntry(j2, k2);
                    }
                    s2 /= this.realEigenvalues[i2];
                    for (j2 = 0; j2 < m2; ++j2) {
                        double[] dArray = bp[j2];
                        int n2 = k2;
                        dArray[n2] = dArray[n2] + s2 * vData[j2];
                    }
                }
            }
            return MatrixUtils.createRealMatrix(bp);
        }

        public boolean isNonSingular() {
            for (int i2 = 0; i2 < this.realEigenvalues.length; ++i2) {
                if (this.realEigenvalues[i2] != 0.0 || this.imagEigenvalues[i2] != 0.0) continue;
                return false;
            }
            return true;
        }

        public RealMatrix getInverse() throws InvalidMatrixException {
            if (!this.isNonSingular()) {
                throw new SingularMatrixException();
            }
            int m2 = this.realEigenvalues.length;
            double[][] invData = new double[m2][m2];
            for (int i2 = 0; i2 < m2; ++i2) {
                double[] invI = invData[i2];
                for (int j2 = 0; j2 < m2; ++j2) {
                    double invIJ = 0.0;
                    for (int k2 = 0; k2 < m2; ++k2) {
                        double[] vK = this.eigenvectors[k2].getDataRef();
                        invIJ += vK[i2] * vK[j2] / this.realEigenvalues[k2];
                    }
                    invI[j2] = invIJ;
                }
            }
            return MatrixUtils.createRealMatrix(invData);
        }
    }
}

