/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.ContainerIO;
import htsjdk.samtools.cram.structure.CramHeader;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class CramSpanContainerIterator
implements Iterator<Container> {
    private final CramHeader cramHeader;
    private final SeekableStream seekableStream;
    private Iterator<Boundary> containerBoundaries;
    private Boundary currentBoundary;
    private long firstContainerOffset;

    private CramSpanContainerIterator(SeekableStream seekableStream, long[] coordinates) throws IOException {
        this.seekableStream = seekableStream;
        seekableStream.seek(0L);
        this.cramHeader = CramIO.readCramHeader(seekableStream);
        this.firstContainerOffset = seekableStream.position();
        ArrayList<Boundary> boundaries = new ArrayList<Boundary>();
        for (int i2 = 0; i2 < coordinates.length; i2 += 2) {
            boundaries.add(new Boundary(coordinates[i2], coordinates[i2 + 1]));
        }
        this.containerBoundaries = boundaries.iterator();
        this.currentBoundary = this.containerBoundaries.next();
    }

    public static CramSpanContainerIterator fromFileSpan(SeekableStream seekableStream, long[] coordinates) throws IOException {
        return new CramSpanContainerIterator(seekableStream, coordinates);
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.currentBoundary.hasNext()) {
                return true;
            }
            if (!this.containerBoundaries.hasNext()) {
                return false;
            }
            this.currentBoundary = this.containerBoundaries.next();
            return this.currentBoundary.hasNext();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public Container next() {
        try {
            return this.currentBoundary.next();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not allowed.");
    }

    public CramHeader getCramHeader() {
        return this.cramHeader;
    }

    public long getFirstContainerOffset() {
        return this.firstContainerOffset;
    }

    private class Boundary {
        final long start;
        final long end;

        public Boundary(long start, long end) {
            this.start = start;
            this.end = end;
            if (start >= end) {
                throw new RuntimeException("Boundary start is greater than end.");
            }
        }

        boolean hasNext() throws IOException {
            return CramSpanContainerIterator.this.seekableStream.position() <= this.end >> 16;
        }

        Container next() throws IOException {
            if (CramSpanContainerIterator.this.seekableStream.position() < this.start >> 16) {
                CramSpanContainerIterator.this.seekableStream.seek(this.start >> 16);
            }
            if (CramSpanContainerIterator.this.seekableStream.position() > this.end >> 16) {
                throw new RuntimeException("No more containers in this boundary.");
            }
            long offset = CramSpanContainerIterator.this.seekableStream.position();
            Container c2 = ContainerIO.readContainer(CramSpanContainerIterator.this.cramHeader.getVersion(), (InputStream)CramSpanContainerIterator.this.seekableStream);
            c2.offset = offset;
            return c2;
        }
    }
}

