/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.io;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteBufferInputStream
extends InputStream {
    final List<ByteBuffer> _lst;
    private int _pos = 0;

    public ByteBufferInputStream(List<ByteBuffer> lst) {
        this(lst, false);
    }

    public ByteBufferInputStream(List<ByteBuffer> lst, boolean flip) {
        this._lst = lst;
        if (flip) {
            for (ByteBuffer buf : this._lst) {
                buf.flip();
            }
        }
    }

    @Override
    public int available() {
        int avail = 0;
        for (int i2 = this._pos; i2 < this._lst.size(); ++i2) {
            avail += this._lst.get(i2).remaining();
        }
        return avail;
    }

    @Override
    public void close() {
    }

    @Override
    public void mark(int readlimit) {
        throw new RuntimeException("mark not supported");
    }

    @Override
    public void reset() {
        throw new RuntimeException("mark not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() {
        if (this._pos >= this._lst.size()) {
            return -1;
        }
        ByteBuffer buf = this._lst.get(this._pos);
        if (buf.remaining() > 0) {
            return buf.get() & 0xFF;
        }
        ++this._pos;
        return this.read();
    }

    @Override
    public int read(byte[] b2) {
        return this.read(b2, 0, b2.length);
    }

    @Override
    public int read(byte[] b2, int off, int len) {
        if (this._pos >= this._lst.size()) {
            return -1;
        }
        ByteBuffer buf = this._lst.get(this._pos);
        if (buf.remaining() == 0) {
            ++this._pos;
            return this.read(b2, off, len);
        }
        int toRead = Math.min(len, buf.remaining());
        buf.get(b2, off, toRead);
        if (toRead == len || this._pos + 1 >= this._lst.size()) {
            return toRead;
        }
        ++this._pos;
        return toRead + this.read(b2, off + toRead, len - toRead);
    }

    @Override
    public long skip(long n2) {
        long skipped = 0L;
        while (n2 >= 0L && this._pos < this._lst.size()) {
            ByteBuffer b2 = this._lst.get(this._pos);
            if ((long)b2.remaining() < n2) {
                skipped += (long)b2.remaining();
                n2 -= (long)b2.remaining();
                b2.position(b2.limit());
                ++this._pos;
                continue;
            }
            b2.position((int)((long)b2.position() + n2));
            return skipped += n2;
        }
        return skipped;
    }
}

