/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.windows;

import com.jidesoft.plaf.windows.TMSchema;
import com.jidesoft.plaf.windows.XPStyle;
import com.jidesoft.swing.TristateButtonModel;
import com.jidesoft.swing.TristateCheckBox;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class WindowsIconFactory {
    private static Icon checkBoxIcon;

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    private static class CheckBoxIcon
    implements Icon,
    Serializable,
    UIResource {
        static final int csize = 13;
        static int cw = -1;
        static int ch = -1;

        private CheckBoxIcon() {
        }

        public void paintIcon(Component c2, Graphics g2, int x2, int y) {
            JCheckBox cb = (JCheckBox)c2;
            ButtonModel model = cb.getModel();
            XPStyle xp = XPStyle.getXP();
            if (xp != null) {
                TMSchema.State state;
                if (model instanceof TristateButtonModel && ((TristateButtonModel)model).isMixed()) {
                    state = TMSchema.State.MIXEDNORMAL;
                    if (!model.isEnabled()) {
                        state = TMSchema.State.MIXEDDISABLED;
                    } else if (model.isPressed() && model.isArmed()) {
                        state = TMSchema.State.MIXEDPRESSED;
                    } else if (model.isRollover()) {
                        state = TMSchema.State.MIXEDHOT;
                    }
                } else if (model.isSelected()) {
                    state = TMSchema.State.CHECKEDNORMAL;
                    if (!model.isEnabled()) {
                        state = TMSchema.State.CHECKEDDISABLED;
                    } else if (model.isPressed() && model.isArmed()) {
                        state = TMSchema.State.CHECKEDPRESSED;
                    } else if (model.isRollover()) {
                        state = TMSchema.State.CHECKEDHOT;
                    }
                } else {
                    state = TMSchema.State.UNCHECKEDNORMAL;
                    if (!model.isEnabled()) {
                        state = TMSchema.State.UNCHECKEDDISABLED;
                    } else if (model.isPressed() && model.isArmed()) {
                        state = TMSchema.State.UNCHECKEDPRESSED;
                    } else if (model.isRollover()) {
                        state = TMSchema.State.UNCHECKEDHOT;
                    }
                }
                TMSchema.Part part = TMSchema.Part.BP_CHECKBOX;
                xp.getSkin(c2, part).paintSkin(g2, x2, y, state);
            } else {
                if (!cb.isBorderPaintedFlat()) {
                    g2.setColor(UIManager.getColor("CheckBox.shadow"));
                    g2.drawLine(x2, y, x2 + 11, y);
                    g2.drawLine(x2, y + 1, x2, y + 11);
                    g2.setColor(UIManager.getColor("CheckBox.highlight"));
                    g2.drawLine(x2 + 12, y, x2 + 12, y + 12);
                    g2.drawLine(x2, y + 12, x2 + 11, y + 12);
                    g2.setColor(UIManager.getColor("CheckBox.darkShadow"));
                    g2.drawLine(x2 + 1, y + 1, x2 + 10, y + 1);
                    g2.drawLine(x2 + 1, y + 2, x2 + 1, y + 10);
                    g2.setColor(UIManager.getColor("CheckBox.light"));
                    g2.drawLine(x2 + 1, y + 11, x2 + 11, y + 11);
                    g2.drawLine(x2 + 11, y + 1, x2 + 11, y + 10);
                    if (model.isPressed() && model.isArmed() || !model.isEnabled()) {
                        g2.setColor(UIManager.getColor("CheckBox.background"));
                    } else {
                        g2.setColor(UIManager.getColor("CheckBox.interiorBackground"));
                    }
                    g2.fillRect(x2 + 2, y + 2, 9, 9);
                } else {
                    g2.setColor(UIManager.getColor("CheckBox.shadow"));
                    g2.drawRect(x2 + 1, y + 1, 10, 10);
                    if (model.isPressed() && model.isArmed() || !model.isEnabled()) {
                        g2.setColor(UIManager.getColor("CheckBox.background"));
                    } else {
                        g2.setColor(UIManager.getColor("CheckBox.interiorBackground"));
                    }
                    g2.fillRect(x2 + 2, y + 2, 9, 9);
                }
                if (model.isEnabled()) {
                    g2.setColor(UIManager.getColor("CheckBox.foreground"));
                } else {
                    g2.setColor(UIManager.getColor("CheckBox.shadow"));
                }
                if (c2 instanceof TristateCheckBox && ((TristateCheckBox)c2).getModel() instanceof TristateButtonModel && ((TristateButtonModel)((TristateCheckBox)c2).getModel()).isMixed()) {
                    this.drawSquare(c2, g2, x2, y);
                } else if (model.isSelected()) {
                    g2.drawLine(x2 + 9, y + 3, x2 + 9, y + 3);
                    g2.drawLine(x2 + 8, y + 4, x2 + 9, y + 4);
                    g2.drawLine(x2 + 7, y + 5, x2 + 9, y + 5);
                    g2.drawLine(x2 + 6, y + 6, x2 + 8, y + 6);
                    g2.drawLine(x2 + 3, y + 7, x2 + 7, y + 7);
                    g2.drawLine(x2 + 4, y + 8, x2 + 6, y + 8);
                    g2.drawLine(x2 + 5, y + 9, x2 + 5, y + 9);
                    g2.drawLine(x2 + 3, y + 5, x2 + 3, y + 5);
                    g2.drawLine(x2 + 3, y + 6, x2 + 4, y + 6);
                }
            }
        }

        protected void drawSquare(Component c2, Graphics g2, int x2, int y) {
            int w2 = this.getIconWidth();
            int h2 = this.getIconHeight();
            int margin = w2 / 3;
            g2.fillRect(x2 + margin, y + margin, w2 - margin * 2, h2 - margin * 2);
        }

        public int getIconWidth() {
            XPStyle xp = XPStyle.getXP();
            if (xp != null) {
                if (cw == -1) {
                    cw = xp.getSkin(null, TMSchema.Part.BP_CHECKBOX).getWidth();
                }
                return cw;
            }
            return 13;
        }

        public int getIconHeight() {
            XPStyle xp = XPStyle.getXP();
            if (xp != null) {
                if (ch == -1) {
                    ch = xp.getSkin(null, TMSchema.Part.BP_CHECKBOX).getHeight();
                }
                return ch;
            }
            return 13;
        }
    }
}

